/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.recommender;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.rules.functions.CosineSimilarityFunction;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.models.rules.functions.NormAbsDiff;
import com.walmart.productgenome.matching.service.MockTable;
import com.walmart.productgenome.matching.service.explorer.AttrComb;
import com.walmart.productgenome.matching.service.explorer.AttrStats;
import com.walmart.productgenome.matching.service.explorer.Explorer;
import com.walmart.productgenome.matching.service.explorer.TableStats;
import com.walmart.productgenome.matching.service.recommender.FunctionRecommender;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FunctionRecommenderTest {
    Table table;
    TableStats tableStats;
    List<Function> allFunctions;
    Attribute year;
    Attribute title;

    @Before
    public void init() {
        this.table = new MockTable().getTable();
        this.tableStats = Explorer.getTableStats(this.table, 100, 100);
        this.allFunctions = new ArrayList<Function>();
        this.allFunctions.add(new CosineSimilarityFunction());
        this.allFunctions.add(new NormAbsDiff());
        this.year = this.table.getAttributeByName("year");
        this.title = this.table.getAttributeByName("title");
    }

    @Test
    public void testNumericRecommendation() {
        Assert.assertTrue((boolean)FunctionRecommender.getRecommendedFunctionsForType(this.allFunctions, this.year.getType()).contains(new NormAbsDiff()));
        Assert.assertFalse((boolean)FunctionRecommender.getRecommendedFunctionsForType(this.allFunctions, this.year.getType()).contains(new CosineSimilarityFunction()));
    }

    @Test
    public void testStringRecommendation() {
        Assert.assertFalse((boolean)FunctionRecommender.getRecommendedFunctionsForType(this.allFunctions, this.title.getType()).contains(new NormAbsDiff()));
        Assert.assertTrue((boolean)FunctionRecommender.getRecommendedFunctionsForType(this.allFunctions, this.title.getType()).contains(new CosineSimilarityFunction()));
    }

    @Test
    public void testNumericAttributeRecommendation() {
        AttrStats attrStats = this.tableStats.getAttrStats(new AttrComb(this.year));
        Assert.assertTrue((boolean)FunctionRecommender.getRecFunctionsForAttr(this.allFunctions, attrStats).contains(new NormAbsDiff()));
        Assert.assertFalse((boolean)FunctionRecommender.getRecFunctionsForAttr(this.allFunctions, attrStats).contains(new CosineSimilarityFunction()));
    }

    @Test
    public void testStringAttributeRecommendation() {
        AttrStats attrStats = this.tableStats.getAttrStats(new AttrComb(this.title));
        Assert.assertFalse((boolean)FunctionRecommender.getRecFunctionsForAttr(this.allFunctions, attrStats).contains(new NormAbsDiff()));
        Assert.assertTrue((boolean)FunctionRecommender.getRecFunctionsForAttr(this.allFunctions, attrStats).contains(new CosineSimilarityFunction()));
    }
}

