/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.service.skyline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Skyline {
    public static List<Object> getHintTuples(Map<Object, List<Float>> features, SimSelection selection, int simCount) {
        List<Object> tuples = Skyline.getMostLeastSim(features, selection);
        while (tuples.size() < simCount && features.size() > 0) {
            for (Object t : tuples) {
                features.remove(t);
            }
            tuples.addAll(Skyline.getMostLeastSim(features, selection));
        }
        if (tuples.size() > simCount) {
            int i = tuples.size() - 1;
            while (i >= simCount) {
                tuples.remove(i);
                --i;
            }
        }
        return tuples;
    }

    public static List<Object> getMostLeastSim(Map<Object, List<Float>> features, SimSelection selection) {
        boolean mostSimilar = false;
        if (selection == SimSelection.MOST_SIM) {
            mostSimilar = true;
        }
        ArrayList<Map.Entry<Object, List<Float>>> vectors = new ArrayList<Map.Entry<Object, List<Float>>>();
        vectors.addAll(features.entrySet());
        List<Map.Entry<Object, List<Float>>> sortedVectors = Skyline.sortVectorsBySum(vectors, mostSimilar);
        ArrayList<Object> selectedPairs = new ArrayList<Object>();
        ArrayList<List<Float>> selectedVectors = new ArrayList<List<Float>>();
        for (Map.Entry<Object, List<Float>> sortedVector : sortedVectors) {
            boolean dominated = false;
            for (List list : selectedVectors) {
                if (list.equals(sortedVector)) break;
                if (!Skyline.dominant(list, sortedVector.getValue(), mostSimilar)) continue;
                dominated = true;
                break;
            }
            if (dominated) continue;
            selectedPairs.add(sortedVector.getKey());
            selectedVectors.add(sortedVector.getValue());
        }
        ArrayList<Object> hintPairs = new ArrayList<Object>();
        hintPairs.addAll(selectedPairs);
        return hintPairs;
    }

    private static boolean dominant(List<Float> vector1, List<Float> vector2, boolean mostSimilar) {
        boolean necessary = false;
        int i = 0;
        while (i < vector1.size()) {
            Float v1 = vector1.get(i);
            Float v2 = vector2.get(i);
            if (mostSimilar) {
                if (!(v1.floatValue() >= v2.floatValue())) {
                    return false;
                }
                if (v1.floatValue() > v2.floatValue()) {
                    necessary = true;
                }
            } else {
                if (!(v1.floatValue() <= v2.floatValue())) {
                    return false;
                }
                if (v1.floatValue() < v2.floatValue()) {
                    necessary = true;
                }
            }
            ++i;
        }
        return necessary;
    }

    private static List<Map.Entry<Object, List<Float>>> sortVectorsBySum(List<Map.Entry<Object, List<Float>>> vectors, boolean mostSimilar) {
        Comparator<Map.Entry<Object, List<Float>>> vectorComparator = new Comparator<Map.Entry<Object, List<Float>>>(){

            @Override
            public int compare(Map.Entry<Object, List<Float>> a, Map.Entry<Object, List<Float>> b) {
                if (Skyline.getVectorSum(a.getValue()).floatValue() < Skyline.getVectorSum(b.getValue()).floatValue()) {
                    return -1;
                }
                if (Skyline.getVectorSum(a.getValue()).floatValue() > Skyline.getVectorSum(b.getValue()).floatValue()) {
                    return 1;
                }
                return 0;
            }
        };
        if (mostSimilar) {
            Comparator<Map.Entry<Object, List<Float>>> reversedVectorComparator = Collections.reverseOrder(vectorComparator);
            Collections.sort(vectors, reversedVectorComparator);
        } else {
            Collections.sort(vectors, vectorComparator);
        }
        return vectors;
    }

    private static Float getVectorSum(List<Float> vector) {
        Float sum = Float.valueOf(0.0f);
        for (Float v : vector) {
            sum = Float.valueOf(sum.floatValue() + v.floatValue());
        }
        return sum;
    }

    public static enum SimSelection {
        MOST_SIM,
        LEAST_SIM;

    }
}

