/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.utils;

import com.walmart.productgenome.matching.evaluate.EvaluationSummary;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.loaders.EvaluationSummaryLoader;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.utils.CSVUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONUtils {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String TABLE = "table";
    public static final String ID_ATTRIB = "idAttrib";
    public static final String TYPE = "type";
    public static final String PROJECT_NAME = "projectName";
    public static final String ATTRIBUTES = "attributes";
    public static final String PROJECT = "project";
    public static final String CREATED_ON = "createdOn";
    public static final String LAST_MODIFIED_ON = "lastModifiedOn";
    public static final String TABLES = "tables";
    public static final String TABLE1 = "table1";
    public static final String TABLE2 = "table2";
    public static final String ATTRIBUTE1 = "attribute1";
    public static final String ATTRIBUTE2 = "attribute2";
    public static final String FUNCTION = "function";
    public static final String CLASS_NAME = "className";
    public static final String FUNCTIONS = "functions";
    public static final String FEATURES = "features";
    public static final String RULES = "rules";
    public static final String RULE_STRING = "ruleString";
    public static final String MATCHERS = "matchers";
    public static final String FUNCTION_NAME = "functionName";
    public static final String EVALUATION_SUMMARIES = "evaluationSummaries";
    public static final String ATTRIBUTE1_NAME = "attribute1_name";
    public static final String ATTRIBUTE2_NAME = "attribute2_name";
    public static final String ATTRIBUTE1_TYPE = "attribute1_type";
    public static final String ATTRIBUTE2_TYPE = "attribute2_type";
    public static final String DEFAULTS = "defaults";
    public static final String CANDSET = "candset";
    public static final String MATCHES = "matches";
    public static final String GOLD = "gold";
    public static final String EVALUATION_SUMMARY = "evaluation_summary";
    public static final String PRECISION = "precision";
    public static final String RECALL = "recall";
    public static final String F1 = "f1";
    public static final String ACTUAL_POSITIVES = "actualPositives";
    public static final String TRUE_POSITIVES = "truePositives";
    public static final String FALSE_POSITIVES = "falsePositives";
    public static final String ID1 = "id1";
    public static final String ID2 = "id2";

    private static Attribute getAttributeFromJSON(JsonObject attribObj) {
        String attrName = attribObj.getString(NAME);
        String type = attribObj.getString(TYPE);
        Attribute.Type attrType = Attribute.Type.valueOf(type);
        return new Attribute(attrName, attrType);
    }

    private static Function getFunctionFromJSON(JsonObject functionObj) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String functionName = functionObj.getString(NAME);
        String functionDescription = functionObj.getString(DESCRIPTION);
        String className = functionObj.getString(CLASS_NAME);
        return JSONUtils.getFunction(functionName, functionDescription, className);
    }

    private static Function getFunction(String functionName, String functionDescription, String className) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> functionClass = Class.forName(className);
        Constructor<?> constructor = functionClass.getConstructor(String.class, String.class);
        return (Function)constructor.newInstance(functionName, functionDescription);
    }

    public static Table getTableFromJSON(String tableJSON) {
        JsonReader reader = Json.createReader((Reader)new StringReader(tableJSON));
        JsonObject obj = reader.readObject();
        JsonObject tableObj = obj.getJsonObject(TABLE);
        String name = tableObj.getString(NAME);
        String description = tableObj.getString(DESCRIPTION);
        JsonObject idAttribObj = tableObj.getJsonObject(ID_ATTRIB);
        Attribute idAttrib = null;
        if (idAttribObj != null) {
            idAttrib = JSONUtils.getAttributeFromJSON(idAttribObj);
        }
        String projectName = tableObj.getString(PROJECT_NAME);
        JsonArray attribs = tableObj.getJsonArray(ATTRIBUTES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (JsonObject attr : attribs.getValuesAs(JsonObject.class)) {
            attributes.add(JSONUtils.getAttributeFromJSON(attr));
        }
        Table table = new Table(name, idAttrib, attributes, projectName);
        table.setDescription(description);
        return table;
    }

    public static String getTableJSON(Table table) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jgf.createGenerator((Writer)sw);
        Attribute idAttribute = table.getIdAttribute();
        jg = jg.writeStartObject().writeStartObject(TABLE).write(NAME, table.getName()).write(DESCRIPTION, table.getDescription());
        if (idAttribute != null) {
            jg = jg.writeStartObject(ID_ATTRIB).write(NAME, table.getIdAttribute().getName()).write(TYPE, table.getIdAttribute().getType().name()).writeEnd();
        }
        jg = jg.write(PROJECT_NAME, table.getProjectName()).writeStartArray(ATTRIBUTES);
        for (Attribute attribute : table.getAttributes()) {
            jg = jg.writeStartObject().write(NAME, attribute.getName()).write(TYPE, attribute.getType().name()).writeEnd();
        }
        jg.writeEnd().writeEnd().writeEnd().close();
        return ((Object)sw).toString();
    }

    private static EvaluationSummary.IdPair getIdPairFromJSON(JsonObject idPairObj) {
        String id1 = idPairObj.getString(ID1);
        String id2 = idPairObj.getString(ID2);
        return new EvaluationSummary.IdPair(id1, id2);
    }

    public static EvaluationSummary getEvaluationSummaryFromJSON(String evalSumJSON) {
        JsonReader reader = Json.createReader((Reader)new StringReader(evalSumJSON));
        JsonObject obj = reader.readObject();
        JsonObject evalSumObj = obj.getJsonObject(EVALUATION_SUMMARY);
        String name = evalSumObj.getString(NAME);
        String projectName = evalSumObj.getString(PROJECT_NAME);
        String matchesName = evalSumObj.getString(MATCHES);
        String goldName = evalSumObj.getString(GOLD);
        EvaluationSummary evalSum = new EvaluationSummary(name, projectName, matchesName, goldName);
        float precision = (float)evalSumObj.getJsonNumber(PRECISION).doubleValue();
        float recall = (float)evalSumObj.getJsonNumber(RECALL).doubleValue();
        float f1 = (float)evalSumObj.getJsonNumber(F1).doubleValue();
        evalSum.setPrecision(precision);
        evalSum.setRecall(recall);
        evalSum.setF1(f1);
        JsonArray actualPositivesArray = evalSumObj.getJsonArray(ACTUAL_POSITIVES);
        for (JsonObject idPair : actualPositivesArray.getValuesAs(JsonObject.class)) {
            evalSum.addActualPositive(JSONUtils.getIdPairFromJSON(idPair));
        }
        JsonArray truePositivesArray = evalSumObj.getJsonArray(TRUE_POSITIVES);
        for (JsonObject idPair : truePositivesArray.getValuesAs(JsonObject.class)) {
            evalSum.addTruePositive(JSONUtils.getIdPairFromJSON(idPair));
        }
        JsonArray falsePositivesArray = evalSumObj.getJsonArray(FALSE_POSITIVES);
        for (JsonObject idPair : falsePositivesArray.getValuesAs(JsonObject.class)) {
            evalSum.addFalsePositive(JSONUtils.getIdPairFromJSON(idPair));
        }
        return evalSum;
    }

    public static String getEvaluationSummaryJSON(EvaluationSummary evaluationSummary) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jgf.createGenerator((Writer)sw);
        jg = jg.writeStartObject().writeStartObject(EVALUATION_SUMMARY).write(NAME, evaluationSummary.getName()).write(PROJECT_NAME, evaluationSummary.getProjectName()).write(MATCHES, evaluationSummary.getMatchesName()).write(GOLD, evaluationSummary.getGoldName()).write(PRECISION, (double)evaluationSummary.getPrecision()).write(RECALL, (double)evaluationSummary.getRecall()).write(F1, (double)evaluationSummary.getF1()).writeStartArray(ACTUAL_POSITIVES);
        for (EvaluationSummary.IdPair idPair : evaluationSummary.getActualPositives()) {
            jg = jg.writeStartObject().write(ID1, idPair.getId1().toString()).write(ID2, idPair.getId2().toString()).writeEnd();
        }
        jg.writeEnd().writeStartArray(TRUE_POSITIVES);
        for (EvaluationSummary.IdPair idPair : evaluationSummary.getTruePositives()) {
            jg = jg.writeStartObject().write(ID1, idPair.getId1().toString()).write(ID2, idPair.getId2().toString()).writeEnd();
        }
        jg.writeEnd().writeStartArray(FALSE_POSITIVES);
        for (EvaluationSummary.IdPair idPair : evaluationSummary.getFalsePositives()) {
            jg = jg.writeStartObject().write(ID1, idPair.getId1().toString()).write(ID2, idPair.getId2().toString()).writeEnd();
        }
        jg.writeEnd().writeEnd().writeEnd().close();
        return ((Object)sw).toString();
    }

    public static Project getProjectFromJSONFile(String projectName) throws ParseException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        File infoFile = new File("./ems//" + projectName + "/" + projectName + ".project");
        JsonReader reader = Json.createReader((Reader)new FileReader(infoFile));
        JsonObject obj = reader.readObject();
        JsonObject projObj = obj.getJsonObject(PROJECT);
        String name = projObj.getString(NAME);
        String description = projObj.getString(DESCRIPTION);
        String createdOn = projObj.getString(CREATED_ON);
        String lastModifiedOn = projObj.getString(LAST_MODIFIED_ON);
        Project p = new Project(name, description);
        p.setCreatedOn(createdOn);
        p.setLastModifiedOn(lastModifiedOn);
        String projectDirectoryName = "./ems//" + projectName;
        File projectDirectory = new File(projectDirectoryName);
        File[] tableFiles = projectDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".table");
            }
        });
        Arrays.sort(tableFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        ArrayList<String> tableNames = new ArrayList<String>();
        File[] fileArray = tableFiles;
        int n = tableFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File tableFile = fileArray[n2];
            String tableName = tableFile.getName();
            if (tableName.indexOf(".") > 0) {
                tableName = tableName.substring(0, tableName.lastIndexOf("."));
            }
            tableNames.add(tableName);
            ++n2;
        }
        p.addTableNames(tableNames);
        String csvFunctionFilePath = "./ems//" + projectName + "/" + "all.functions";
        List<Function> functions = CSVUtils.loadFunctions(csvFunctionFilePath);
        p.addFunctions(functions);
        String csvFeatureFilePath = "./ems//" + projectName + "/" + "all.features";
        List<Feature> features = CSVUtils.loadFeatures(p, csvFeatureFilePath);
        p.addFeatures(features);
        String csvRuleFilePath = "./ems//" + projectName + "/" + "all.rules";
        List<Rule> rules = CSVUtils.loadRules(p, csvRuleFilePath);
        p.addRules(rules);
        String csvMatcherFilePath = "./ems//" + projectName + "/" + "all.matchers";
        List<Matcher> matchers = CSVUtils.loadMatchers(p, csvMatcherFilePath);
        p.addMatchers(matchers);
        File[] evaluationSummaryFiles = projectDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".evalsum");
            }
        });
        Arrays.sort(evaluationSummaryFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        ArrayList<EvaluationSummary> evaluationSummaries = new ArrayList<EvaluationSummary>();
        File[] fileArray2 = evaluationSummaryFiles;
        int n3 = evaluationSummaryFiles.length;
        int n4 = 0;
        while (n4 < n3) {
            File evalSumFile = fileArray2[n4];
            EvaluationSummary evalSum = EvaluationSummaryLoader.loadEvaluationSummary(evalSumFile);
            evaluationSummaries.add(evalSum);
            ++n4;
        }
        p.addEvaluationSummaries(evaluationSummaries);
        JsonObject defaultsObj = projObj.getJsonObject(DEFAULTS);
        if (defaultsObj != null) {
            String table1Name = defaultsObj.getString(TABLE1);
            String table2Name = defaultsObj.getString(TABLE2);
            String candsetName = defaultsObj.getString(CANDSET);
            String matchesName = defaultsObj.getString(MATCHES);
            String goldName = defaultsObj.getString(GOLD);
            p.setDefaultTable1(table1Name);
            p.setDefaultTable2(table2Name);
            p.setDefaultCandset(candsetName);
            p.setDefaultMatches(matchesName);
            p.setDefaultGold(goldName);
        }
        return p;
    }

    public static String getProjectJSON(Project project) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jgf.createGenerator((Writer)sw);
        jg = jg.writeStartObject().writeStartObject(PROJECT).write(NAME, project.getName()).write(DESCRIPTION, project.getDescription()).write(CREATED_ON, project.getCreatedOnString()).write(LAST_MODIFIED_ON, project.getLastModifiedOnString()).writeStartArray(TABLES);
        for (String string : project.getTableNames()) {
            jg = jg.writeStartObject().write(NAME, string).writeEnd();
        }
        jg.writeEnd().writeStartArray(FUNCTIONS);
        for (Function function : project.getFunctions()) {
            jg = jg.writeStartObject().write(NAME, function.getName()).writeEnd();
        }
        jg.writeEnd().writeStartArray(FEATURES);
        for (Feature feature : project.getFeatures()) {
            jg = jg.writeStartObject().write(NAME, feature.getName()).writeEnd();
        }
        jg.writeEnd().writeStartArray(RULES);
        for (Rule rule : project.getRules()) {
            jg = jg.writeStartObject().write(NAME, rule.getName()).writeEnd();
        }
        jg.writeEnd().writeStartArray(MATCHERS);
        for (Matcher matcher : project.getMatchers()) {
            jg = jg.writeStartObject().write(NAME, matcher.getName()).writeEnd();
        }
        jg.writeEnd().writeStartArray(EVALUATION_SUMMARIES);
        for (String string : project.getEvaluationSummaryNames()) {
            jg = jg.writeStartObject().write(NAME, string).writeEnd();
        }
        jg.writeEnd().writeStartObject(DEFAULTS).write(TABLE1, project.getDefaultTable1()).write(TABLE2, project.getDefaultTable2()).write(CANDSET, project.getDefaultCandset()).write(MATCHES, project.getDefaultMatches()).write(GOLD, project.getDefaultGold()).writeEnd().writeEnd().writeEnd().close();
        return ((Object)sw).toString();
    }
}

