/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.utils;

import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.Term;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.utils.ParsingUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JSONUtilsNew {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String TABLE = "table";
    public static final String ID_ATTRIB = "idAttrib";
    public static final String TYPE = "type";
    public static final String PROJECT_NAME = "projectName";
    public static final String ATTRIBUTES = "attributes";
    public static final String PROJECT = "project";
    public static final String CREATED_ON = "createdOn";
    public static final String LAST_MODIFIED_ON = "lastModifiedOn";
    public static final String TABLES = "tables";
    public static final String TABLE1 = "table1";
    public static final String TABLE2 = "table2";
    public static final String ATTRIBUTE1 = "attribute1";
    public static final String ATTRIBUTE2 = "attribute2";
    public static final String FUNCTION = "function";
    public static final String CLASS_NAME = "className";
    public static final String FUNCTIONS = "functions";
    public static final String FEATURES = "features";
    public static final String RULES = "rules";
    public static final String RULE_STRING = "ruleString";
    public static final String MATCHERS = "matchers";
    public static final String FUNCTION_NAME = "functionName";
    public static final String ATTRIBUTE1_NAME = "attribute1_name";
    public static final String ATTRIBUTE2_NAME = "attribute2_name";
    public static final String ATTRIBUTE1_TYPE = "attribute1_type";
    public static final String ATTRIBUTE2_TYPE = "attribute2_type";

    private static Attribute getAttributeFromJSON(JsonObject attribObj) {
        String attrName = attribObj.getString(NAME);
        String type = attribObj.getString(TYPE);
        Attribute.Type attrType = Attribute.Type.valueOf(type);
        return new Attribute(attrName, attrType);
    }

    private static Function getFunctionFromJSON(JsonObject functionObj) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String functionName = functionObj.getString(NAME);
        String functionDescription = functionObj.getString(DESCRIPTION);
        String className = functionObj.getString(CLASS_NAME);
        Class<?> functionClass = Class.forName(className);
        Constructor<?> constructor = functionClass.getConstructor(String.class, String.class);
        return (Function)constructor.newInstance(functionName, functionDescription);
    }

    public static Table getTableFromJSON(String tableJSON) {
        JsonReader reader = Json.createReader((Reader)new StringReader(tableJSON));
        JsonObject obj = reader.readObject();
        JsonObject tableObj = obj.getJsonObject(TABLE);
        String name = tableObj.getString(NAME);
        String description = tableObj.getString(DESCRIPTION);
        JsonObject idAttribObj = tableObj.getJsonObject(ID_ATTRIB);
        Attribute idAttrib = null;
        if (idAttribObj != null) {
            idAttrib = JSONUtilsNew.getAttributeFromJSON(idAttribObj);
        }
        String projectName = tableObj.getString(PROJECT_NAME);
        JsonArray attribs = tableObj.getJsonArray(ATTRIBUTES);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (JsonObject attr : attribs.getValuesAs(JsonObject.class)) {
            attributes.add(JSONUtilsNew.getAttributeFromJSON(attr));
        }
        Table table = new Table(name, idAttrib, attributes, projectName);
        table.setDescription(description);
        return table;
    }

    public static String getTableJSON(Table table) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jgf.createGenerator((Writer)sw);
        Attribute idAttribute = table.getIdAttribute();
        jg = jg.writeStartObject().writeStartObject(TABLE).write(NAME, table.getName()).write(DESCRIPTION, table.getDescription());
        if (idAttribute != null) {
            jg = jg.writeStartObject(ID_ATTRIB).write(NAME, table.getIdAttribute().getName()).write(TYPE, table.getIdAttribute().getType().name()).writeEnd();
        }
        jg = jg.write(PROJECT_NAME, table.getProjectName()).writeStartArray(ATTRIBUTES);
        for (Attribute attribute : table.getAttributes()) {
            jg = jg.writeStartObject().write(NAME, attribute.getName()).write(TYPE, attribute.getType().name()).writeEnd();
        }
        jg.writeEnd().writeEnd().writeEnd().close();
        return ((Object)sw).toString();
    }

    public static Project getProjectFromJSONFile(File infoFile) throws FileNotFoundException, ParseException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        JsonReader reader = Json.createReader((Reader)new FileReader(infoFile));
        JsonObject obj = reader.readObject();
        JsonObject projObj = obj.getJsonObject(PROJECT);
        String name = projObj.getString(NAME);
        String description = projObj.getString(DESCRIPTION);
        String createdOn = projObj.getString(CREATED_ON);
        String lastModifiedOn = projObj.getString(LAST_MODIFIED_ON);
        Project p = new Project(name, description);
        p.setCreatedOn(createdOn);
        p.setLastModifiedOn(lastModifiedOn);
        JsonArray tables = projObj.getJsonArray(TABLES);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (JsonObject table : tables.getValuesAs(JsonObject.class)) {
            String tableName = table.getString(NAME);
            tableNames.add(tableName);
        }
        p.addTableNames(tableNames);
        JsonArray functionList = projObj.getJsonArray(FUNCTIONS);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (JsonObject functionObj : functionList.getValuesAs(JsonObject.class)) {
            Function function = JSONUtilsNew.getFunctionFromJSON(functionObj);
            functions.add(function);
        }
        p.addFunctions(functions);
        JsonArray featureList = projObj.getJsonArray(FEATURES);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (JsonObject featureObj : featureList.getValuesAs(JsonObject.class)) {
            String featureName = featureObj.getString(NAME);
            String table1Name = featureObj.getString(TABLE1);
            String table2Name = featureObj.getString(TABLE2);
            String functionName = featureObj.getString(FUNCTION_NAME);
            Function function = p.findFunctionByName(functionName);
            Attribute attribute1 = new Attribute(featureObj.getString(ATTRIBUTE1_NAME), Attribute.Type.valueOf(featureObj.getString(ATTRIBUTE1_TYPE)));
            Attribute attribute2 = new Attribute(featureObj.getString(ATTRIBUTE2_NAME), Attribute.Type.valueOf(featureObj.getString(ATTRIBUTE2_TYPE)));
            Feature feature = new Feature(featureName, function, name, table1Name, table2Name, attribute1, attribute2);
            features.add(feature);
        }
        p.addFeatures(features);
        JsonArray ruleList = projObj.getJsonArray(RULES);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (JsonObject ruleObj : ruleList.getValuesAs(JsonObject.class)) {
            String ruleName = ruleObj.getString(NAME);
            String table1Name = ruleObj.getString(TABLE1);
            String table2Name = ruleObj.getString(TABLE2);
            String ruleString = ruleObj.getString(RULE_STRING);
            List<Term> terms = ParsingUtils.parseRule(p, ruleString);
            rules.add(new Rule(ruleName, name, table1Name, table2Name, terms));
        }
        p.addRules(rules);
        JsonArray matcherList = projObj.getJsonArray(MATCHERS);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (JsonObject matcherObj : matcherList.getValuesAs(JsonObject.class)) {
            String matcherName = matcherObj.getString(NAME);
            String table1Name = matcherObj.getString(TABLE1);
            String table2Name = matcherObj.getString(TABLE2);
            JsonArray matcherRuleList = matcherObj.getJsonArray(RULES);
            ArrayList<Rule> matcherRules = new ArrayList<Rule>();
            for (JsonObject ruleObj : matcherRuleList.getValuesAs(JsonObject.class)) {
                String ruleName = ruleObj.getString(NAME);
                Rule rule = p.findRuleByName(ruleName);
                matcherRules.add(rule);
            }
            matchers.add(new Matcher(matcherName, name, table1Name, table2Name, matcherRules));
        }
        p.addMatchers(matchers);
        return p;
    }

    public static String getProjectJSON(Project project) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jgf.createGenerator((Writer)sw);
        jg = jg.writeStartObject().writeStartObject(PROJECT).write(NAME, project.getName()).write(DESCRIPTION, project.getDescription()).write(CREATED_ON, project.getCreatedOnString()).write(LAST_MODIFIED_ON, project.getLastModifiedOnString()).writeStartArray(TABLES);
        for (String string : project.getTableNames()) {
            jg = jg.writeStartObject().write(NAME, string).writeEnd();
        }
        jg.writeEnd().writeStartArray(FUNCTIONS);
        for (Function function : project.getFunctions()) {
            jg = jg.writeStartObject().write(NAME, function.getName()).write(DESCRIPTION, function.getDescription()).write(CLASS_NAME, function.getClass().getName()).writeEnd();
        }
        jg.writeEnd().writeStartArray(FEATURES);
        for (Feature feature : project.getFeatures()) {
            System.out.println(feature);
            Function func = feature.getFunction();
            jg = jg.writeStartObject().write(NAME, feature.getName()).write(TABLE1, feature.getTable1Name()).write(TABLE2, feature.getTable2Name()).write(FUNCTION_NAME, func.getName()).write(ATTRIBUTE1_NAME, feature.getAttribute1().getName()).write(ATTRIBUTE2_NAME, feature.getAttribute2().getName()).write(ATTRIBUTE1_TYPE, feature.getAttribute1().getType().name()).write(ATTRIBUTE2_TYPE, feature.getAttribute2().getType().name()).writeEnd();
        }
        jg.writeEnd().writeStartArray(RULES);
        for (Rule rule : project.getRules()) {
            jg = jg.writeStartObject().write(NAME, rule.getName()).write(TABLE1, rule.getTable1Name()).write(TABLE2, rule.getTable2Name()).write(RULE_STRING, rule.getRuleString()).writeEnd();
        }
        jg.writeEnd().writeStartArray(MATCHERS);
        for (Matcher matcher : project.getMatchers()) {
            List<Rule> rules = matcher.getRules();
            jg = jg.writeStartObject().write(NAME, matcher.getName()).write(TABLE1, matcher.getTable1Name()).write(TABLE2, matcher.getTable2Name()).writeStartArray(RULES);
            for (Rule r : rules) {
                jg = jg.writeStartObject().write(NAME, r.getName()).writeEnd();
            }
            jg = jg.writeEnd().writeEnd();
        }
        jg.writeEnd().writeEnd().writeEnd().close();
        return ((Object)sw).toString();
    }
}

