/*
 * Decompiled with CFR 0.152.
 */
package com.walmart.productgenome.matching.utils;

import com.walmart.productgenome.matching.daos.TableDao;
import com.walmart.productgenome.matching.models.RelationalOperator;
import com.walmart.productgenome.matching.models.data.Attribute;
import com.walmart.productgenome.matching.models.data.Project;
import com.walmart.productgenome.matching.models.data.Table;
import com.walmart.productgenome.matching.models.rules.Feature;
import com.walmart.productgenome.matching.models.rules.Matcher;
import com.walmart.productgenome.matching.models.rules.Rule;
import com.walmart.productgenome.matching.models.rules.Term;
import com.walmart.productgenome.matching.models.rules.functions.Function;
import com.walmart.productgenome.matching.models.savers.RuleSaver;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ParsingUtils {
    public static int SYS_RULE_NUM = 1;
    public static final String SYS_RULE = "SYS_RULE_";

    public static Matcher readMatcher(String programName, Project project, Table table1, Table table2, String programFilePath) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(programFilePath));
        String line = br.readLine();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        while ((line = br.readLine()) != null) {
            String ruleName = line.trim();
            System.out.println("Rule name: " + ruleName);
            Rule rule = project.findRuleByName(ruleName);
            System.out.println("Rule: " + rule);
            rules.add(rule);
        }
        br.close();
        System.out.println("Rules' size: " + rules.size());
        return new Matcher(programName, project.getName(), table1.getName(), table2.getName(), rules);
    }

    public static List<Term> parseRule(Project p, String ruleString) {
        String[] termValues;
        ArrayList<Term> terms = new ArrayList<Term>();
        String[] stringArray = termValues = ruleString.split(" AND ");
        int n = termValues.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            System.out.println("[ParsingUtils] Term: " + t);
            String[] values = t.split(",");
            String featureName = values[0];
            String comparison = values[1];
            String rvalue = values[2];
            Feature feature1 = p.findFeatureByName(featureName);
            RelationalOperator relop = RelationalOperator.valueOf(comparison);
            float value = Float.NaN;
            Feature feature2 = null;
            try {
                value = Float.parseFloat(rvalue);
            }
            catch (NumberFormatException nfe) {
                feature2 = p.findFeatureByName(rvalue);
            }
            Term term = feature2 != null ? new Term(feature1, relop, feature2) : new Term(feature1, relop, value);
            terms.add(term);
            ++n2;
        }
        return terms;
    }

    public static Feature parseFeatureFromDisplayString(Project p, String featureName, String featureString) throws IOException {
        Feature feature = p.findFeatureByName(featureName);
        String[] values = featureString.split(",");
        String functionName = values[0];
        if (!feature.getFunction().getName().equals(functionName)) {
            Function function = p.findFunctionByName(functionName);
            feature.setFunction(function);
        }
        String tableAttr1 = values[1];
        String tableAttr2 = values[2];
        String[] vals1 = tableAttr1.split(":");
        String table1Name = vals1[0];
        String attr1Name = vals1[1];
        String[] vals2 = tableAttr2.split(":");
        String table2Name = vals2[0];
        String attr2Name = vals2[1];
        if (!feature.getTable1Name().equals(table1Name) || !feature.getAttribute1().getName().equals(attr1Name)) {
            Table table1 = TableDao.open(p.getName(), table1Name);
            Attribute attribute1 = table1.getAttributeByName(attr1Name);
            feature.setTable1Name(table1Name);
            feature.setAttribute1(attribute1);
        }
        if (!feature.getTable2Name().equals(table2Name) || !feature.getAttribute2().getName().equals(attr2Name)) {
            Table table2 = TableDao.open(p.getName(), table2Name);
            Attribute attribute2 = table2.getAttributeByName(attr2Name);
            feature.setTable2Name(table2Name);
            feature.setAttribute2(attribute2);
        }
        return feature;
    }

    public static List<Term> parseRuleFromDisplayString(Project p, String ruleString) {
        String[] termValues;
        ArrayList<Term> terms = new ArrayList<Term>();
        String[] stringArray = termValues = ruleString.split(" AND ");
        int n = termValues.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            System.out.println("[ParsingUtils] Term: " + t);
            String[] values = t.split(" ");
            String featureName = values[0];
            String comparison = values[1];
            String rvalue = values[2];
            Feature feature1 = p.findFeatureByName(featureName);
            RelationalOperator relop = RelationalOperator.valueOfFromName(comparison);
            float value = Float.NaN;
            Feature feature2 = null;
            try {
                value = Float.parseFloat(rvalue);
            }
            catch (NumberFormatException nfe) {
                feature2 = p.findFeatureByName(rvalue);
            }
            Term term = feature2 != null ? new Term(feature1, relop, feature2) : new Term(feature1, relop, value);
            terms.add(term);
            ++n2;
        }
        return terms;
    }

    public static List<Rule> parseMatcherFromShortDisplayString(Project p, String matcherString) {
        String[] ruleNames;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String[] stringArray = ruleNames = matcherString.split(" OR ");
        int n = ruleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleName = stringArray[n2];
            Rule rule = p.findRuleByName(ruleName);
            rules.add(rule);
            ++n2;
        }
        return rules;
    }

    public static Matcher parseMatcherFromDisplayString(Project p, String matcherName, String matcherString, boolean saveToDisk) throws IOException {
        String[] ruleStrings;
        Matcher matcher = p.findMatcherByName(matcherName);
        String table1Name = matcher.getTable1Name();
        String table2Name = matcher.getTable2Name();
        List<Rule> rules = matcher.getRules();
        ArrayList<Rule> newRules = new ArrayList<Rule>();
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        for (Rule r : rules) {
            ruleMap.put(r.getDisplayString(), r);
        }
        String[] stringArray = ruleStrings = matcherString.split(" OR ");
        int n = ruleStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String ruleString = stringArray[n2];
            Rule rule = (Rule)ruleMap.get(ruleString);
            if (rule == null) {
                String ruleName = SYS_RULE + SYS_RULE_NUM;
                ++SYS_RULE_NUM;
                List<Term> terms = ParsingUtils.parseRuleFromDisplayString(p, ruleString);
                rule = new Rule(ruleName, p.getName(), table1Name, table2Name, terms);
                p.addRule(rule);
                if (saveToDisk) {
                    RuleSaver.saveRule(p.getName(), rule, p);
                    p.removeUnsavedRule(ruleName);
                } else {
                    p.addUnsavedRule(ruleName);
                }
            }
            newRules.add(rule);
            ++n2;
        }
        matcher.setRules(newRules);
        return matcher;
    }

    public static void main(String[] args) throws IOException {
    }
}

