/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics;

import java.util.Collection;
import org.paukov.combinatorics.CombinatoricsVector;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.combination.multi.MultiCombinationGenerator;
import org.paukov.combinatorics.combination.simple.SimpleCombinationGenerator;
import org.paukov.combinatorics.composition.CompositionGenerator;
import org.paukov.combinatorics.partition.PartitionGenerator;
import org.paukov.combinatorics.permutations.PermutationGenerator;
import org.paukov.combinatorics.permutations.PermutationWithRepetitionGenerator;
import org.paukov.combinatorics.subsets.SubSetGenerator;

public class Factory {
    public static <T> ICombinatoricsVector<T> createVector() {
        return new CombinatoricsVector();
    }

    public static <T> ICombinatoricsVector<T> createVector(T[] TArray) {
        return new CombinatoricsVector<T>(TArray);
    }

    public static <T> ICombinatoricsVector<T> createVector(Collection<? extends T> collection) {
        return new CombinatoricsVector<T>(collection);
    }

    public static <T> ICombinatoricsVector<T> createVector(ICombinatoricsVector<T> iCombinatoricsVector) {
        return new CombinatoricsVector<T>(iCombinatoricsVector);
    }

    public static ICombinatoricsVector<Integer> range(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Range value must be more or equal to 0");
        }
        if (n == 0) {
            return new CombinatoricsVector<Integer>();
        }
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = i + 1;
        }
        return new CombinatoricsVector<Integer>(integerArray);
    }

    public static ICombinatoricsVector<Integer> range(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("From parameter must be less then To parameter");
        }
        Integer[] integerArray = new Integer[n2 - n + 1];
        for (int i = 0; i < n2 - n + 1; ++i) {
            integerArray[i] = new Integer(i + n);
        }
        return new CombinatoricsVector<Integer>(integerArray);
    }

    public static <T> Generator<T> createSimpleCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        return new SimpleCombinationGenerator<T>(iCombinatoricsVector, n);
    }

    public static <T> Generator<T> createMultiCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        return new MultiCombinationGenerator<T>(iCombinatoricsVector, n);
    }

    public static <T> Generator<T> createPermutationGenerator(ICombinatoricsVector<T> iCombinatoricsVector) {
        return new PermutationGenerator<T>(iCombinatoricsVector);
    }

    public static <T> Generator<T> createPermutationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, boolean bl) {
        return new PermutationGenerator<T>(iCombinatoricsVector, bl);
    }

    public static <T> Generator<T> createPermutationWithRepetitionGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        return new PermutationWithRepetitionGenerator<T>(iCombinatoricsVector, n);
    }

    public static <T> Generator<T> createSubSetGenerator(ICombinatoricsVector<T> iCombinatoricsVector) {
        return new SubSetGenerator<T>(iCombinatoricsVector);
    }

    public static <T> Generator<T> createSubSetGenerator(ICombinatoricsVector<T> iCombinatoricsVector, boolean bl) {
        return new SubSetGenerator<T>(iCombinatoricsVector, bl);
    }

    public static Generator<Integer> createCompositionGenerator(Integer n) {
        return new CompositionGenerator(n);
    }

    public static Generator<Integer> createPartitionGenerator(Integer n) {
        return new PartitionGenerator(n);
    }
}

