/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.combination.multi;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.combination.multi.MultiCombinationIterator;
import org.paukov.combinatorics.util.Util;

public class MultiCombinationGenerator<T>
extends Generator<T> {
    protected final ICombinatoricsVector<T> _originalVector;
    protected final int _combinationLength;

    public MultiCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        this._originalVector = Factory.createVector(iCombinatoricsVector);
        this._combinationLength = n < 0 ? 0 : n;
    }

    @Override
    public ICombinatoricsVector<T> getOriginalVector() {
        return this._originalVector;
    }

    public int getCombinationLength() {
        return this._combinationLength;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        return Util.combination(this._originalVector.getSize() + this._combinationLength - 1, this._combinationLength);
    }

    @Override
    public Iterator<ICombinatoricsVector<T>> iterator() {
        return new MultiCombinationIterator(this);
    }
}

