/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.composition;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.composition.CompositionIterator;
import org.paukov.combinatorics.util.Util;

public class CompositionGenerator
extends Generator<Integer> {
    public static final int MAXN = 100;
    protected final Integer _initialValue;

    public CompositionGenerator(Integer n) {
        this._initialValue = n;
    }

    @Override
    public ICombinatoricsVector<Integer> getOriginalVector() {
        return Factory.createVector(new Integer[]{this._initialValue});
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        return Util.pow2(this._initialValue - 1);
    }

    @Override
    public Iterator<ICombinatoricsVector<Integer>> iterator() {
        return new CompositionIterator(this);
    }
}

