/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.composition;

import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.composition.CompositionGenerator;

public class CompositionIterator
implements Iterator<ICombinatoricsVector<Integer>> {
    protected final CompositionGenerator _generator;
    protected ICombinatoricsVector<Integer> _currentComposition = null;
    protected long _currentIndex = 0L;
    protected final Generator<Integer> _subsetGenerator;
    protected final Iterator<ICombinatoricsVector<Integer>> _subsetIterator;
    protected ICombinatoricsVector<Integer> _currentSubset = null;

    public CompositionIterator(CompositionGenerator compositionGenerator) {
        this._generator = compositionGenerator;
        ICombinatoricsVector<Integer> iCombinatoricsVector = Factory.createVector();
        for (int i = 1; i < this._generator._initialValue; ++i) {
            iCombinatoricsVector.addValue(i);
        }
        this._subsetGenerator = Factory.createSubSetGenerator(iCombinatoricsVector);
        this._subsetIterator = this._subsetGenerator.iterator();
    }

    @Override
    public ICombinatoricsVector<Integer> next() {
        ++this._currentIndex;
        this._currentSubset = this._subsetIterator.next();
        return this.getCurrentItem();
    }

    @Override
    public boolean hasNext() {
        return this._subsetIterator.hasNext();
    }

    protected ICombinatoricsVector<Integer> getCurrentItem() {
        this._currentComposition = Factory.createVector();
        List<Integer> list = this._currentSubset.getVector();
        Iterator<Integer> iterator = list.iterator();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            Integer n4 = iterator.next();
            n3 = n4 - n;
            this._currentComposition.setValue(n2, n3);
            ++n2;
            n = n4;
        }
        this._currentComposition.setValue(n2, this._generator._initialValue - n);
        return this._currentComposition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CompositionIterator=[#" + this._currentIndex + ", " + this._currentComposition + "]";
    }
}

