/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.composition;

import java.util.Iterator;
import org.paukov.combinatorics.IntegerFactory;
import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;
import org.paukov.combinatorics.composition.IntegerCompositionGenerator;

public class IntegerCompositionIterator
implements Iterator<IntegerVector> {
    protected final IntegerCompositionGenerator _generator;
    protected IntegerVector _currentComposition = null;
    protected long _currentIndex = 0L;
    protected final IntegerGenerator _subsetGenerator;
    protected final Iterator<IntegerVector> _subsetIterator;
    protected IntegerVector _currentSubset = null;

    public IntegerCompositionIterator(IntegerCompositionGenerator integerCompositionGenerator) {
        this._generator = integerCompositionGenerator;
        int n = 0;
        if (this._generator._initialValue > 0) {
            n = this._generator._initialValue - 1;
        }
        IntegerVector integerVector = IntegerFactory.createIntegerVector(n);
        for (int i = 1; i < this._generator._initialValue; ++i) {
            integerVector.setValue(i - 1, i);
        }
        this._subsetGenerator = IntegerFactory.createIntegerSubSetGenerator(integerVector);
        this._subsetIterator = this._subsetGenerator.iterator();
    }

    @Override
    public IntegerVector next() {
        ++this._currentIndex;
        this._currentSubset = this._subsetIterator.next();
        return this.getCurrentItem();
    }

    @Override
    public boolean hasNext() {
        return this._subsetIterator.hasNext();
    }

    protected IntegerVector getCurrentItem() {
        int[] nArray = this._currentSubset.getVector();
        this._currentComposition = IntegerFactory.createIntegerVector(nArray.length + 1);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            n2 = n3 - n;
            this._currentComposition.setValue(i, n2);
            n = n3;
        }
        this._currentComposition.setValue(nArray.length, this._generator._initialValue - n);
        return this._currentComposition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "IntegerCompositionIterator=[#" + this._currentIndex + ", " + this._currentComposition + "]";
    }
}

