/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.partition;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.partition.PartitionIterator;

public class PartitionGenerator
extends Generator<Integer> {
    public static final int MAXN = 100;
    protected final Integer _initialValue;

    public PartitionGenerator(Integer n) {
        this._initialValue = n;
    }

    @Override
    public Iterator<ICombinatoricsVector<Integer>> iterator() {
        return new PartitionIterator(this);
    }

    @Override
    public ICombinatoricsVector<Integer> getOriginalVector() {
        return Factory.createVector(new Integer[]{this._initialValue});
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        if (this._initialValue == 0) {
            return 0L;
        }
        if (this._initialValue > 0 && this._initialValue <= 100) {
            double d = 2.0 * (double)this._initialValue.intValue() / 3.0;
            d = Math.exp(Math.PI * Math.sqrt(d));
            return (long)(d /= 4.0 * (double)this._initialValue.intValue() * Math.sqrt(3.0));
        }
        throw new RuntimeException("Unable to calculate the number of the pertitions for the value N=" + this._initialValue);
    }
}

