/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.partition;

import java.util.ArrayList;
import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.partition.PartitionGenerator;

public class PartitionIterator
implements Iterator<ICombinatoricsVector<Integer>> {
    protected final PartitionGenerator _generator;
    protected ICombinatoricsVector<Integer> _currentPartition = null;
    protected long _currentIndex = 0L;
    private int[] _mVector = null;
    private int[] _zVector = null;
    private int _kIndex = 1;

    public PartitionIterator(PartitionGenerator partitionGenerator) {
        this._generator = partitionGenerator;
        this._mVector = new int[partitionGenerator._initialValue + 2];
        this._zVector = new int[partitionGenerator._initialValue + 2];
        this.init();
    }

    private void init() {
        if (this._generator._initialValue < 1) {
            this._kIndex = 0;
            return;
        }
        this._currentIndex = 0L;
        this._kIndex = 1;
        this.setInternalVectorValue(-1, this._zVector, 0);
        this.setInternalVectorValue(-1, this._mVector, 0);
        this.setInternalVectorValue(0, this._zVector, this._generator._initialValue + 1);
        this.setInternalVectorValue(0, this._mVector, 0);
        this.setInternalVectorValue(1, this._zVector, 1);
        this.setInternalVectorValue(1, this._mVector, this._generator._initialValue);
    }

    @Override
    public boolean hasNext() {
        return this._kIndex != 0;
    }

    @Override
    public ICombinatoricsVector<Integer> next() {
        ++this._currentIndex;
        this.createCurrentPartition(this._kIndex);
        int n = this.getInternalVectorValue(this._kIndex, this._mVector) * this.getInternalVectorValue(this._kIndex, this._zVector);
        if (this.getInternalVectorValue(this._kIndex, this._mVector) == 1) {
            --this._kIndex;
            n += this.getInternalVectorValue(this._kIndex, this._mVector) * this.getInternalVectorValue(this._kIndex, this._zVector);
        }
        if (this.getInternalVectorValue(this._kIndex - 1, this._zVector) == this.getInternalVectorValue(this._kIndex, this._zVector) + 1) {
            --this._kIndex;
            this.setInternalVectorValue(this._kIndex, this._mVector, this.getInternalVectorValue(this._kIndex, this._mVector) + 1);
        } else {
            this.setInternalVectorValue(this._kIndex, this._zVector, this.getInternalVectorValue(this._kIndex, this._zVector) + 1);
            this.setInternalVectorValue(this._kIndex, this._mVector, 1);
        }
        if (n > this.getInternalVectorValue(this._kIndex, this._zVector)) {
            this.setInternalVectorValue(this._kIndex + 1, this._zVector, 1);
            this.setInternalVectorValue(this._kIndex + 1, this._mVector, n - this.getInternalVectorValue(this._kIndex, this._zVector));
            ++this._kIndex;
        }
        return this._currentPartition;
    }

    private void createCurrentPartition(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < this.getInternalVectorValue(i, this._mVector); ++j) {
                arrayList.add(this.getInternalVectorValue(i, this._zVector));
            }
        }
        this._currentPartition = Factory.createVector(arrayList);
    }

    private final int getInternalVectorValue(int n, int[] nArray) {
        return nArray[n + 1];
    }

    private final void setInternalVectorValue(int n, int[] nArray, int n2) {
        nArray[n + 1] = n2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "PartitionIterator=[#" + this._currentIndex + ", " + this._currentPartition + "]";
    }
}

