/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.subsets;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;

public class SubSetIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final Generator<T> _generator;
    protected ICombinatoricsVector<T> _currentSubSet = null;
    protected long _currentIndex = 0L;
    protected final int _length;
    private int[] _bitVector = null;

    public SubSetIterator(Generator<T> generator) {
        this._generator = generator;
        this._length = ((ICombinatoricsVector)generator.getOriginalVector()).getSize();
        this._currentSubSet = Factory.createVector();
        this._bitVector = new int[this._length + 2];
        this.init();
    }

    private void init() {
        this._currentIndex = 0L;
        for (int i = 0; i <= this._length + 1; ++i) {
            this._bitVector[i] = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this._bitVector[this._length + 1] != 1;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        int n;
        ++this._currentIndex;
        this._currentSubSet.clearVector();
        for (n = 1; n <= this._length; ++n) {
            if (this._bitVector[n] != 1) continue;
            Object t = ((ICombinatoricsVector)this._generator.getOriginalVector()).getValue(n - 1);
            this._currentSubSet.addValue(t);
        }
        n = 1;
        while (this._bitVector[n] == 1) {
            this._bitVector[n] = 0;
            ++n;
        }
        this._bitVector[n] = 1;
        return Factory.createVector(this._currentSubSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SubSetIterator=[#" + this._currentIndex + ", " + this._currentSubSet + "]";
    }
}

