/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.MemoMatrix;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringWrapper;
import org.apache.log4j.Logger;

public abstract class ApproxMemoMatrix
extends MemoMatrix {
    private static Logger log = Logger.getLogger(ApproxMemoMatrix.class);
    private double[][] valuesNearDiagonal;
    private boolean[][] wasComputed;
    private double defaultValue;
    private double scale;
    private int width;

    ApproxMemoMatrix(StringWrapper s, StringWrapper t, int width, double defaultValue) {
        super(new BasicStringWrapper(""), new BasicStringWrapper(""));
        this.s = s;
        this.t = t;
        this.valuesNearDiagonal = new double[s.length() + 1][2 * width];
        this.wasComputed = new boolean[s.length() + 1][2 * width];
        this.defaultValue = defaultValue;
        this.width = width;
        this.scale = ((double)t.length() + 1.0) / ((double)s.length() + 1.0);
    }

    private int offsetFromDiagonal(int i, int j) {
        int diagForI = (int)Math.round((double)i * this.scale);
        int k = diagForI - j + this.width;
        return k;
    }

    private boolean nearDiagonal(int k) {
        return k >= 1 && k < 2 * this.width;
    }

    @Override
    double get(int i, int j) {
        int k = this.offsetFromDiagonal(i, j);
        if (!this.nearDiagonal(k)) {
            return this.defaultValue;
        }
        if (this.wasComputed[i][k]) {
            return this.valuesNearDiagonal[i][k];
        }
        this.valuesNearDiagonal[i][k] = this.compute(i, j);
        this.wasComputed[i][k] = true;
        return this.valuesNearDiagonal[i][k];
    }

    public boolean outOfRange(int i, int j) {
        boolean out;
        boolean bl = out = i < 1 || i > this.s.length() || j < 1 || j > this.t.length();
        if (out) {
            log.error((Object)("out of range: |s|=" + this.s.length() + " |t|=" + this.t.length() + " s = '" + this.s + "' t=" + this.t + "'"));
        }
        return out;
    }

    int getWidth() {
        return this.width;
    }

    double getScale() {
        return this.scale;
    }

    int getFirstStoredEntryInRow(int i) {
        int diagForI = (int)Math.round((double)i * this.scale);
        return Math.max(1, diagForI - this.width);
    }

    int getLastStoredEntryInRow(int i) {
        int diagForI = (int)Math.round((double)i * this.scale);
        return Math.min(this.t.length(), diagForI + this.width);
    }

    @Override
    public String toString() {
        int i;
        PrintfFormat fmt = new PrintfFormat(this.cellFormat);
        StringBuffer buf = new StringBuffer();
        buf.append("   ");
        buf.append("   ");
        for (i = 1; i <= this.s.length(); ++i) {
            buf.append(fmt.sprintf((double)i));
        }
        buf.append("\n");
        buf.append("   ");
        buf.append("   ");
        for (i = 1; i <= this.s.length(); ++i) {
            buf.append(" " + this.trapNewline(this.sAt(i)) + " ");
        }
        buf.append("\n");
        buf.append("   ");
        buf.append("   ");
        for (i = 1; i <= this.s.length(); ++i) {
            buf.append("---");
        }
        buf.append("\n");
        for (int j = 1; j <= this.t.length(); ++j) {
            buf.append(fmt.sprintf((double)j));
            buf.append(" " + this.trapNewline(this.tAt(j)) + "|");
            for (int i2 = 1; i2 <= this.s.length(); ++i2) {
                if (!this.nearDiagonal(this.offsetFromDiagonal(i2, j)) || this.defaultValue == this.get(i2, j)) {
                    buf.append(" * ");
                    continue;
                }
                double v = this.printNegativeValues ? -this.get(i2, j) : this.get(i2, j);
                buf.append(fmt.sprintf(v));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private char trapNewline(char ch) {
        return Character.isWhitespace(ch) ? (char)' ' : (char)ch;
    }
}

