/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class Airport {
    public List<String> connections = new ArrayList<String>();
    public List<Float> hours = new ArrayList<Float>();
    public String name;
    public int connectionCount = 0;

    Airport(String myName) {
        this.name = myName;
    }

    public void addConnection(String aName, float hrs) {
        this.connections.add(aName);
        this.hours.add(Float.valueOf(hrs));
        ++this.connectionCount;
    }

    public void removeConnection(String aName) {
        this.connections.remove(aName);
    }

    public void updateConnection(String aName, float hrs) {
        this.removeConnection(aName);
        this.addConnection(aName, hrs);
    }

    public float getHoursTo(String aName) {
        int idx = this.connections.indexOf(aName);
        float hrs = -1.0f;
        if (idx != -1) {
            hrs = this.hours.get(idx).floatValue();
        }
        return hrs;
    }

    public String[] getAllConnections() {
        String[] connectionList = new String[this.connections.size()];
        int idx = 0;
        while (idx < connectionList.length) {
            connectionList[idx] = this.connections.get(idx);
            ++idx;
        }
        return connectionList;
    }

    public float[] getAllHours() {
        float[] hoursList = new float[this.hours.size()];
        int idx = 0;
        while (idx < hoursList.length) {
            hoursList[idx] = this.hours.get(idx).floatValue();
            ++idx;
        }
        return hoursList;
    }

    public void print() {
        System.out.println("\tOrigin: " + this.name);
        System.out.println("\t\tDestination: ");
        int i = 0;
        while (i < this.connectionCount) {
            System.out.println("\t\t--> " + this.connections.get(i) + " : " + this.hours.get(i));
            ++i;
        }
    }
}

