/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class AirportGraph {
    HashMap<String, Airport> airport_list = new HashMap();

    AirportGraph() {
    }

    public String[] getAirportNames() {
        Set<String> key = this.airport_list.keySet();
        String[] aptNames = key.toArray(new String[key.size()]);
        return aptNames;
    }

    public void addConnection(String origin, String destination, float hrs) {
        if (this.airport_list.containsKey(origin)) {
            Airport anAirport = this.airport_list.get(origin);
            anAirport.addConnection(destination, hrs);
        } else {
            Airport anAirport = new Airport(origin);
            anAirport.addConnection(destination, hrs);
            this.airport_list.put(origin, anAirport);
        }
    }

    public String getAirportsNStopsAway(String origin, int nStops) {
        ArrayList<String> airportNamesList = new ArrayList<String>();
        ArrayList<Airport> checkList = new ArrayList<Airport>();
        Airport oriAirport = this.airport_list.get(origin);
        if (oriAirport == null) {
            return "";
        }
        checkList.add(oriAirport);
        airportNamesList.add(origin);
        int hopCount = 0;
        while (hopCount < nStops) {
            ++hopCount;
            Airport[] setOfAirports = new Airport[checkList.size()];
            int idx1 = 0;
            while (idx1 < setOfAirports.length) {
                setOfAirports[idx1] = (Airport)checkList.get(idx1);
                ++idx1;
            }
            checkList.clear();
            airportNamesList.clear();
            int idx2 = 0;
            while (idx2 < setOfAirports.length) {
                Airport anAirport = setOfAirports[idx2];
                String[] airportNeightbors = anAirport.getAllConnections();
                int idx3 = 0;
                while (idx3 < airportNeightbors.length) {
                    String nextAirport = this.airport_list.get((Object)airportNeightbors[idx3]).name;
                    if (airportNamesList.indexOf(nextAirport) < 0) {
                        checkList.add(this.airport_list.get(airportNeightbors[idx3]));
                        airportNamesList.add(nextAirport);
                    }
                    ++idx3;
                }
                ++idx2;
            }
        }
        Collections.sort(airportNamesList);
        return this.listToString(airportNamesList);
    }

    public PathInfo getRoundTrip(String origin) {
        float hrs = Float.MIN_VALUE;
        ArrayList<String> path = new ArrayList<String>();
        PathInfo info = new PathInfo(origin, hrs);
        LinkedList<NextAirportWithList> aptsList = new LinkedList<NextAirportWithList>();
        if (!this.airport_list.containsKey(origin)) {
            return info;
        }
        this.addToQWithList(origin, origin, path, 0.0f, aptsList);
        while (!aptsList.isEmpty()) {
            NextAirportWithList anAirport = (NextAirportWithList)aptsList.poll();
            String justSeen = anAirport.name;
            if (justSeen.compareTo(origin) == 0) {
                if (!(anAirport.hours > info.getHours())) continue;
                anAirport.path.add(justSeen);
                info.setInfo(this.listToString(anAirport.path), anAirport.hours);
                continue;
            }
            this.addToQWithList(origin, justSeen, anAirport.path, anAirport.hours, aptsList);
        }
        return info;
    }

    public void addToQWithList(String origin, String aptName, List<String> aPath, float hrsTillNow, Queue<NextAirportWithList> aptsList) {
        Airport anAirport = this.airport_list.get(aptName);
        String[] connections = anAirport.getAllConnections();
        float[] hours = anAirport.getAllHours();
        int idx = 0;
        while (idx < anAirport.connectionCount) {
            String nxtAptName = connections[idx];
            if (!aPath.contains(nxtAptName) || origin.compareTo(nxtAptName) == 0) {
                ArrayList<String> aPath2 = new ArrayList<String>(aPath);
                aPath2.add(aptName);
                NextAirportWithList nxt = new NextAirportWithList(connections[idx], hours[idx] + hrsTillNow, aPath2);
                aptsList.add(nxt);
            }
            ++idx;
        }
    }

    public PathInfo getShortestHours(String origin, String destination) {
        float hrs = 0.0f;
        String path = origin;
        PathInfo info = new PathInfo(path, hrs);
        if (!this.airport_list.containsKey(origin) || !this.airport_list.containsKey(destination)) {
            info.setHours(Float.MIN_VALUE);
            return info;
        }
        if (origin.compareTo(destination) == 0) {
            return info;
        }
        LeastHoursComparator comparator = new LeastHoursComparator();
        PriorityQueue<NextAirport> aptsList = new PriorityQueue<NextAirport>(this.airport_list.size(), comparator);
        ArrayList<String> alreadySeen = new ArrayList<String>();
        String justSeen = origin;
        this.addToQ(origin, "", 0.0f, alreadySeen, aptsList, comparator);
        while (justSeen.compareTo(destination) != 0) {
            NextAirport anAirport = aptsList.poll();
            justSeen = anAirport.name;
            if (justSeen.compareTo(destination) == 0) {
                info.setInfo(String.valueOf(anAirport.path) + justSeen, anAirport.hours);
                continue;
            }
            this.addToQ(justSeen, anAirport.path, anAirport.hours, alreadySeen, aptsList, comparator);
        }
        return info;
    }

    public void addToQ(String aptName, String aPath, float hrsTillNow, List<String> alreadySeen, PriorityQueue<NextAirport> aptsList, Comparator<NextAirport> comparator) {
        alreadySeen.add(aptName);
        Airport anAirport = this.airport_list.get(aptName);
        String[] connections = anAirport.getAllConnections();
        float[] hours = anAirport.getAllHours();
        aPath = String.valueOf(aPath) + aptName + ",";
        int i = 0;
        while (i < anAirport.connectionCount) {
            String nxtAptName = connections[i];
            if (!alreadySeen.contains(nxtAptName)) {
                NextAirport nxt = new NextAirport(connections[i], hours[i] + hrsTillNow, aPath);
                aptsList.add(nxt);
            }
            ++i;
        }
    }

    public String listToString(List<String> aList) {
        String outString = "";
        int i = 0;
        while (i < aList.size()) {
            outString = String.valueOf(outString) + aList.get(i);
            if (i < aList.size() - 1) {
                outString = String.valueOf(outString) + ",";
            }
            ++i;
        }
        return outString;
    }

    public void print() {
        for (Map.Entry<String, Airport> entry : this.airport_list.entrySet()) {
            Airport aAirport = entry.getValue();
            aAirport.print();
        }
    }

    public class LeastHoursComparator
    implements Comparator<NextAirport> {
        @Override
        public int compare(NextAirport apt1, NextAirport apt2) {
            if (apt1.hours < apt2.hours) {
                return -1;
            }
            if (apt1.hours > apt2.hours) {
                return 1;
            }
            return 0;
        }
    }

    public class MostHoursComparator
    implements Comparator<NextAirportWithList> {
        @Override
        public int compare(NextAirportWithList apt1, NextAirportWithList apt2) {
            if (apt1.hours > apt2.hours) {
                return -1;
            }
            if (apt1.hours < apt2.hours) {
                return 1;
            }
            return 0;
        }
    }

    public class NextAirport {
        String name;
        String path = "";
        float hours = -1.0f;

        NextAirport() {
        }

        NextAirport(String aName, float hrs, String aPath) {
            this.name = aName;
            this.hours = hrs;
            this.path = aPath;
        }
    }

    public class NextAirportWithList
    extends NextAirport {
        List<String> path = new ArrayList<String>();

        NextAirportWithList(String aName, float hrs, List<String> aPath) {
            this.name = aName;
            this.hours = hrs;
            this.path = aPath;
        }
    }
}

