/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class flightTest {
    static final boolean DO_TESTS = false;

    public static void main(String[] args) throws NumberFormatException, IOException {
        if (args.length != 2) {
            System.out.println("ERROR: (usage) flightTest <flights-file> <task-file>");
            System.exit(-1);
        }
        AirportGraph airport_list = new AirportGraph();
        try {
            BufferedReader in = new BufferedReader(new FileReader(args[0]));
            int lineCount = 0;
            while (in.ready()) {
                String aLine = in.readLine();
                ++lineCount;
                String[] data = aLine.split(",");
                if (data.length != 3) {
                    System.out.println("Flights file (" + args[0] + ") should be formatted as " + "<airport1>,<airport2>,<time> [line:" + lineCount + "]");
                    System.exit(-1);
                }
                airport_list.addConnection(data[0], data[1], Float.valueOf(data[2]).floatValue());
            }
            in.close();
            in = new BufferedReader(new FileReader(args[1]));
            File outDir = new File("out");
            if (!outDir.exists()) {
                if (outDir.mkdir()) {
                    System.out.println("out directory is created!");
                } else {
                    System.exit(-1);
                    System.out.println("Failed to create out directory!");
                }
            }
            PrintWriter writer = new PrintWriter("out/solutions.txt");
            String aLine = in.readLine();
            String[] data = aLine.split(",");
            PathInfo pathInformation = airport_list.getShortestHours(data[0], data[1]);
            writer.println(pathInformation.getPath());
            aLine = in.readLine();
            data = aLine.split(",");
            String listOfAirports = airport_list.getAirportsNStopsAway(data[0], Integer.valueOf(data[1]));
            writer.println(listOfAirports.toString());
            aLine = in.readLine();
            pathInformation = airport_list.getRoundTrip(aLine);
            writer.println(pathInformation.getPath());
            in.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println("ERROR: File Not Found!");
            System.exit(-1);
        }
    }
}

