/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.interfaces;

import java.util.ArrayList;
import java.util.List;
import org.xvolks.jnative.Convention;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.com.interfaces.IUnknown;
import org.xvolks.jnative.com.interfaces.structures.FUNCDESC;
import org.xvolks.jnative.com.interfaces.structures.TYPEATTR;
import org.xvolks.jnative.com.interfaces.structures.VARDESC;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.ole.Oleaut32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITypeInfo
extends IUnknown {
    public ITypeInfo(int address) {
        super(address);
    }

    public List<String> GetNames(int memid, int cMaxNames) throws NativeException, IllegalAccessException {
        ArrayList<String> names = new ArrayList<String>(cMaxNames);
        int address = this.getVtblPointer(7);
        JNative GetDocumentation = new JNative(address, Convention.STDCALL);
        GetDocumentation.setRetVal(Type.INT);
        int pos = 0;
        Pointer rgBstrNames = new Pointer(MemoryBlockFactory.createMemoryBlock(cMaxNames * 4));
        LONG pcNames = new LONG(0);
        GetDocumentation.setParameter(pos++, this.getPIUnknown());
        GetDocumentation.setParameter(pos++, memid);
        GetDocumentation.setParameter(pos++, rgBstrNames.getPointer());
        GetDocumentation.setParameter(pos++, cMaxNames);
        GetDocumentation.setParameter(pos++, pcNames.getPointer());
        GetDocumentation.invoke();
        if (GetDocumentation.getRetValAsInt() == 0) {
            for (int i = 0; i < pcNames.getValue(); ++i) {
                int asInt = rgBstrNames.getAsInt(4 * i);
                names.add(this.getBSTRString(asInt));
            }
        }
        return names;
    }

    public Documentation GetDocumentation(int index) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(12);
        JNative GetDocumentation = new JNative(address, Convention.STDCALL);
        GetDocumentation.setRetVal(Type.INT);
        int pos = 0;
        LONG pBstrName = new LONG(0);
        LONG pBstrDocString = new LONG(0);
        LONG pdwHelpContext = new LONG(0);
        LONG pBstrHelpFile = new LONG(0);
        GetDocumentation.setParameter(pos++, this.getPIUnknown());
        GetDocumentation.setParameter(pos++, index);
        GetDocumentation.setParameter(pos++, pBstrName.getPointer());
        GetDocumentation.setParameter(pos++, pBstrDocString.getPointer());
        GetDocumentation.setParameter(pos++, pdwHelpContext.getPointer());
        GetDocumentation.setParameter(pos++, pBstrHelpFile.getPointer());
        GetDocumentation.invoke();
        if (GetDocumentation.getRetValAsInt() == 0) {
            String name = this.getBSTRString(pBstrName);
            String doc = this.getBSTRString(pBstrDocString);
            int helpContext = pdwHelpContext.getValue();
            String helpFile = this.getBSTRString(pBstrHelpFile);
            return new Documentation(index, name, doc, helpContext, helpFile);
        }
        return null;
    }

    private String getBSTRString(LONG pBstrValue) throws NativeException, IllegalAccessException {
        return this.getBSTRString(pBstrValue.getValue());
    }

    private String getBSTRString(int pBstrValue) throws NativeException, IllegalAccessException {
        String value = null;
        if (pBstrValue != 0) {
            Pointer bstr = new Pointer(new NativeMemoryBlock(pBstrValue, 1024));
            int size = Oleaut32.SysStringByteLen(bstr);
            if (size > 0) {
                value = Kernel32.WideCharToMultiByte(Kernel32.CodePage.CP_UTF8, 0, bstr, size, 1024);
            }
            Oleaut32.SysFreeString(bstr);
        }
        return value;
    }

    public VARDESC GetVarDesc(int index) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(6);
        JNative GetVarDesc = new JNative(address, Convention.STDCALL);
        GetVarDesc.setRetVal(Type.INT);
        LONG addr = new LONG(0);
        GetVarDesc.setParameter(0, this.getPIUnknown());
        GetVarDesc.setParameter(1, index);
        GetVarDesc.setParameter(2, addr.getPointer());
        GetVarDesc.invoke();
        if (GetVarDesc.getRetValAsInt() == 0) {
            return new VARDESC(this, addr).getValueFromPointer();
        }
        JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, String.format("GetFuncDesc returned %08x", GetVarDesc.getRetValAsInt()));
        return null;
    }

    public FUNCDESC GetFuncDesc(int index) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(5);
        JNative GetFuncDesc = new JNative(address, Convention.STDCALL);
        GetFuncDesc.setRetVal(Type.INT);
        LONG addr = new LONG(0);
        GetFuncDesc.setParameter(0, this.getPIUnknown());
        GetFuncDesc.setParameter(1, index);
        GetFuncDesc.setParameter(2, addr.getPointer());
        GetFuncDesc.invoke();
        if (GetFuncDesc.getRetValAsInt() == 0) {
            return new FUNCDESC(this, addr).getValueFromPointer();
        }
        JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, String.format("GetFuncDesc returned %08x", GetFuncDesc.getRetValAsInt()));
        return null;
    }

    public TYPEATTR GetTypeAttr() throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(3);
        JNative GetTypeAttr = new JNative(address, Convention.STDCALL);
        GetTypeAttr.setRetVal(Type.INT);
        LONG addr = new LONG(0);
        GetTypeAttr.setParameter(0, this.getPIUnknown());
        GetTypeAttr.setParameter(1, addr.getPointer());
        GetTypeAttr.invoke();
        TYPEATTR attr = new TYPEATTR(this, addr);
        if (GetTypeAttr.getRetValAsInt() == 0) {
            System.err.println(String.format("Reading object at address : %08x", attr.getPointer().getPointer()));
            return attr.getValueFromPointer();
        }
        return null;
    }

    public void ReleaseTypeAttr(TYPEATTR addr) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(19);
        JNative ReleaseTypeAttr = new JNative(address, Convention.STDCALL);
        ReleaseTypeAttr.setRetVal(Type.VOID);
        ReleaseTypeAttr.setParameter(0, this.getPIUnknown());
        ReleaseTypeAttr.setParameter(1, addr.getPointer().getPointer());
        ReleaseTypeAttr.invoke();
    }

    public void ReleaseFuncDesc(FUNCDESC funcdesc) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(20);
        JNative ReleaseFuncDesc = new JNative(address, Convention.STDCALL);
        ReleaseFuncDesc.setRetVal(Type.VOID);
        ReleaseFuncDesc.setParameter(0, this.getPIUnknown());
        ReleaseFuncDesc.setParameter(1, funcdesc.getPointer().getPointer());
        ReleaseFuncDesc.invoke();
    }

    public void ReleaseVarDesc(VARDESC vardesc) throws NativeException, IllegalAccessException {
        int address = this.getVtblPointer(21);
        JNative ReleaseVarDesc = new JNative(address, Convention.STDCALL);
        ReleaseVarDesc.setRetVal(Type.VOID);
        ReleaseVarDesc.setParameter(0, this.getPIUnknown());
        ReleaseVarDesc.setParameter(1, vardesc.getPointer().getPointer());
        ReleaseVarDesc.invoke();
    }

    public class Documentation {
        private final int index;
        private final String name;
        private final String doc;
        private final int helpContext;
        private final String helpFile;

        public Documentation(int index, String name, String doc, int helpContext, String helpFile) {
            this.name = name;
            this.index = index;
            this.doc = doc;
            this.helpContext = helpContext;
            this.helpFile = helpFile;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getDoc() {
            return this.doc;
        }

        public int getHelpContext() {
            return this.helpContext;
        }

        public String getHelpFile() {
            return this.helpFile;
        }
    }
}

