/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.interfaces;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Native;
import org.xvolks.jnative.com.utils.Logger;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.util.StructConverter;
import org.xvolks.jnative.util.windows.structures.GUID;

public class IUnknown {
    public static final GUID IIDIUnknown = new GUID("{00000000-0000-0000-C000-000000000046}");
    @Native
    private int address;
    @Native
    private int hWnd;
    @Native
    private int ownerThreadId;
    private Logger logger = Logger.getInstance(this.getClass().getName());
    private Pointer vtbl = null;

    protected IUnknown() {
    }

    public IUnknown(int address) {
        this();
        this.address = address;
    }

    protected IUnknown(int hWnd, int ownerThreadId) throws Throwable {
        this(0);
        this.hWnd = hWnd;
        this.ownerThreadId = ownerThreadId;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getPIUnknown() {
        return this.address;
    }

    @Native
    protected void setPIUnknown(int dispatch) {
        this.address = dispatch;
    }

    @Native
    protected void setHWnd(int wnd) {
        this.hWnd = wnd;
    }

    protected int getHWnd() {
        return this.hWnd;
    }

    protected int getOwnerThreadId() {
        return this.ownerThreadId;
    }

    @Native
    protected void setOwnerThreadId(int ownerThreadId) {
        this.ownerThreadId = ownerThreadId;
    }

    public long addRef() throws NativeException {
        return this.AddRef();
    }

    public long release() throws NativeException {
        return this.Release();
    }

    public LONG queryInteface(GUID refId) throws Throwable {
        LONG vObject = new LONG(0);
        if (this.QueryInterface(refId, vObject.getPointer().getPointer())) {
            return vObject;
        }
        return null;
    }

    public int getVtblPointer(int vtblIndex) throws NativeException {
        int offset = vtblIndex + 1 << 2;
        if (this.vtbl == null || this.vtbl.getSize() < offset) {
            int tabAddress = StructConverter.bytesIntoInt(JNative.getMemory(this.getPIUnknown(), 4), 0);
            System.err.println("TabAddress = " + tabAddress);
            this.vtbl = new Pointer(new NativeMemoryBlock(tabAddress, offset));
        }
        return this.vtbl.getAsInt(offset - 4);
    }

    private native long AddRef() throws NativeException;

    private native long Release() throws NativeException;

    private native boolean QueryInterface(GUID var1, int var2) throws NativeException;
}

