/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IP_ADDR_STRING
extends AbstractBasicData<IP_ADDR_STRING> {
    int next;
    String IpAddress;
    String IpMask;
    int Context;

    protected IP_ADDR_STRING() {
        super(null);
        try {
            this.createPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private IP_ADDR_STRING(int address) {
        super(null);
        this.pointer = new Pointer(new NativeMemoryBlock(address, this.getSizeOf()));
    }

    private IP_ADDR_STRING(Pointer pointer) {
        super(null);
        this.pointer = pointer;
    }

    public static IP_ADDR_STRING fromAddress(int address) throws NativeException {
        return new IP_ADDR_STRING(address).getValueFromPointer();
    }

    public static IP_ADDR_STRING fromPointer(Pointer pointer) throws NativeException {
        return new IP_ADDR_STRING(pointer).getValueFromPointer();
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return 40;
    }

    private String getString(byte[] buffer, int pos, int len) {
        String s = new String(buffer, pos, len);
        int pos0 = s.indexOf(0);
        if (pos != -1) {
            s = s.substring(0, pos0);
        }
        return s;
    }

    @Override
    public IP_ADDR_STRING getValueFromPointer() throws NativeException {
        this.next = this.pointer.getAsInt(0);
        byte[] buffer = this.pointer.getMemory();
        this.IpAddress = this.getString(buffer, 4, 16);
        this.IpMask = this.getString(buffer, 20, 16);
        this.Context = this.pointer.getAsInt(36);
        return this;
    }

    public int getNext() {
        return this.next;
    }

    public String getIpAddress() {
        return this.IpAddress;
    }

    public String getIpMask() {
        return this.IpMask;
    }

    public int getContext() {
        return this.Context;
    }
}

