/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.toolkit;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileToolkit {
    public static final void selectDirectory(JTextField textField, String message) {
        FileToolkit.selectFile(textField, message, false, null);
    }

    public static final void selectFile(JTextField textField, String message, String type) {
        FileToolkit.selectFile(textField, message, true, type);
    }

    public static final void selectFile(JTextField textField, String message, boolean isFile, String fileType) {
        JFileChooser fc = new JFileChooser(textField.getText());
        fc.setFileHidingEnabled(true);
        fc.setFileSelectionMode(isFile ? 0 : 1);
        if (fileType != null) {
            final String[] params = fileType.split(";");
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(params[0]);
                }

                public String getDescription() {
                    return params[1];
                }
            });
        }
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(message);
        int returned = fc.showDialog(textField, "Choisir");
        switch (returned) {
            default: {
                break;
            }
            case 0: {
                textField.setText(fc.getSelectedFile().getPath());
            }
        }
    }
}

