/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.ole;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HRESULT;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.toolkit.StringToolkit;
import org.xvolks.jnative.util.ole.Oleaut32;
import org.xvolks.jnative.util.windows.structures.GUID;

public class Ole32 {
    public static final DWORD CLSCTX_ALL = new DWORD(CLSCTX.CLSCTX_INPROC_SERVER.getValue() | CLSCTX.CLSCTX_INPROC_HANDLER.getValue() | CLSCTX.CLSCTX_LOCAL_SERVER.getValue());
    public static final DWORD CLSCTX_INPROC = new DWORD(CLSCTX.CLSCTX_INPROC_SERVER.getValue() | CLSCTX.CLSCTX_INPROC_HANDLER.getValue());
    public static final DWORD CLSCTX_SERVER = new DWORD(CLSCTX.CLSCTX_INPROC_SERVER.getValue() | CLSCTX.CLSCTX_LOCAL_SERVER.getValue() | CLSCTX.CLSCTX_REMOTE_SERVER.getValue());
    public static final String DLL_NAME = "ole32.dll";

    public static final GUID CLSIDFromString(String lpsz) throws NativeException, IllegalAccessException {
        JNative CLSIDFromString = new JNative(DLL_NAME, "CLSIDFromString");
        CLSIDFromString.setRetVal(Type.INT);
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
        Pointer bstr = Oleaut32.SysAllocString(lpsz);
        CLSIDFromString.setParameter(0, bstr);
        CLSIDFromString.setParameter(1, p);
        CLSIDFromString.invoke();
        int ret = CLSIDFromString.getRetValAsInt();
        if (ret != 0) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "CLSIDFromString returned " + ret);
        }
        GUID guid = new GUID();
        guid.setValue(p.getMemory(), 0);
        return guid;
    }

    public static final GUID CLSIDFromProgID(String lpsz) throws NativeException, IllegalAccessException {
        JNative CLSIDFromString = new JNative(DLL_NAME, "CLSIDFromProgID");
        CLSIDFromString.setRetVal(Type.INT);
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(16));
        Pointer bstr = Oleaut32.SysAllocString(lpsz);
        if (bstr == null) {
            throw new NativeException("Can't allocate BSTR string");
        }
        System.err.println(StringToolkit.toHexString(bstr.getMemory()));
        CLSIDFromString.setParameter(0, bstr);
        CLSIDFromString.setParameter(1, p);
        Pointer pp = new Pointer(new NativeMemoryBlock(bstr.getPointer() - 4, 4 + lpsz.length() * 2));
        System.err.println(StringToolkit.toHexString(pp.getMemory()));
        CLSIDFromString.invoke();
        int ret = CLSIDFromString.getRetValAsInt();
        if (ret != 0) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, "CLSIDFromString returned " + ret);
            return null;
        }
        GUID guid = new GUID();
        guid.setValue(p.getMemory(), 0);
        return guid;
    }

    public static final HRESULT CoInitialize() throws NativeException, IllegalAccessException {
        JNative CoInitialize = new JNative(DLL_NAME, "CoInitialize");
        CoInitialize.setRetVal(Type.INT);
        CoInitialize.setParameter(0, 0);
        CoInitialize.invoke();
        return new HRESULT(CoInitialize.getRetValAsInt());
    }

    public static final Pointer CoCreateInstance(GUID rclsid, Pointer pUnkOuter, DWORD dwClsContext, GUID riid) throws NativeException, IllegalAccessException {
        JNative CoCreateInstance = new JNative(DLL_NAME, "CoCreateInstance");
        CoCreateInstance.setRetVal(Type.INT);
        int pos = 0;
        LONG ppIUnknown = new LONG(0);
        CoCreateInstance.setParameter(pos++, rclsid.getPointer());
        CoCreateInstance.setParameter(pos++, pUnkOuter);
        CoCreateInstance.setParameter(pos++, dwClsContext.getValue());
        CoCreateInstance.setParameter(pos++, riid.getPointer());
        CoCreateInstance.setParameter(pos++, ppIUnknown.getPointer());
        CoCreateInstance.invoke();
        return ppIUnknown.getPointer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CLSCTX {
        CLSCTX_INPROC_SERVER(1),
        CLSCTX_INPROC_HANDLER(2),
        CLSCTX_LOCAL_SERVER(4),
        CLSCTX_INPROC_SERVER16(8),
        CLSCTX_REMOTE_SERVER(16);

        private final int value;

        private CLSCTX(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

