/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.ole;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.com.utils.Basic;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.pointers.memory.NativeMemoryBlock;
import org.xvolks.jnative.toolkit.StringToolkit;

public class Oleaut32 {
    public static final String DLL_NAME = "Oleaut32.dll";

    public static final Pointer LoadRegTypeLib(Pointer rguid, int wVerMajor, int wVerMinor, int lcid) throws NativeException, IllegalAccessException {
        Pointer p = new Pointer(MemoryBlockFactory.createMemoryBlock(4));
        JNative LoadRegTypeLib = new JNative(DLL_NAME, "LoadRegTypeLib");
        LoadRegTypeLib.setRetVal(Type.INT);
        LoadRegTypeLib.setParameter(0, rguid);
        LoadRegTypeLib.setParameter(1, wVerMajor);
        LoadRegTypeLib.setParameter(2, wVerMinor);
        LoadRegTypeLib.setParameter(3, lcid);
        LoadRegTypeLib.setParameter(4, p);
        LoadRegTypeLib.invoke();
        if (LoadRegTypeLib.getRetValAsInt() == 0) {
            return p;
        }
        return null;
    }

    public static final Pointer SysAllocString(String sz) throws NativeException, IllegalAccessException {
        int ret = Basic.SysAllocString(sz);
        if (ret == 0) {
            throw new OutOfMemoryError("Cannot allocate memory in SysAllocString(" + sz + "");
        }
        return new Pointer(new NativeMemoryBlock(ret, 4)){

            protected void finalize() throws Throwable {
                this.dispose();
            }

            public void dispose() {
                try {
                    Oleaut32.SysFreeString(this);
                }
                catch (NativeException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static final void SysFreeString(Pointer bstr) throws NativeException, IllegalAccessException {
        Basic.SysFreeString(bstr.getPointer());
    }

    public static final int SysStringLen(Pointer bstr) throws NativeException, IllegalAccessException {
        return Basic.SysStringLen(bstr.getPointer());
    }

    public static final int SysStringByteLen(Pointer bstr) throws NativeException, IllegalAccessException {
        return Basic.SysStringByteLen(bstr.getPointer());
    }

    public static void main(String[] args) throws NativeException, InterruptedException, IllegalAccessException {
        System.setProperty("jnative.com.logLevel", "5");
        JNative.setLoggingEnabled(true);
        Pointer p = Oleaut32.SysAllocString("toto");
        Pointer pp = new Pointer(new NativeMemoryBlock(p.getPointer() - 4, 12));
        System.err.println(StringToolkit.toHexString(p.getMemory()));
        System.err.println(StringToolkit.toHexString(pp.getMemory()));
        System.exit(0);
        for (String s : JNative.getDLLFileExports(System.getenv("windir") + "/system32/" + DLL_NAME)) {
            System.err.println(s);
        }
    }
}

