/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.BITMAP;
import org.xvolks.jnative.misc.BITMAPINFOHEADER;
import org.xvolks.jnative.misc.ICONINFO;
import org.xvolks.jnative.misc.PROCESSENTRY32;
import org.xvolks.jnative.misc.TOKEN_PRIVILEGES;
import org.xvolks.jnative.misc.basicStructures.DC;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.LRECT;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.Advapi32;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Gdi32;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.PsAPI;
import org.xvolks.jnative.util.StructConverter;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.constants.winuser.WM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsUtils {
    public static final int ABOVE_NORMAL_PRIORITY_CLASS = 2048;
    public static final int BELOW_NORMAL_PRIORITY_CLASS = 1024;
    public static final int HIGH_PRIORITY_CLASS = 8;
    public static final int IDLE_PRIORITY_CLASS = 4;
    public static final int NORMAL_PRIORITY_CLASS = 2;
    public static final int REALTIME_PRIORITY_CLASS = 16;

    public static int[] nativeImageToJavaImage(Pointer bitmap, int width, int height) throws NativeException {
        int[] pixels = new int[width * height];
        byte[] b_Bitmap = bitmap.getMemory();
        for (int i = 0; i <= pixels.length - 4; ++i) {
            pixels[i] = StructConverter.bytesIntoInt(b_Bitmap, i * 4);
        }
        return pixels;
    }

    public static ImageIcon iconHandleToImageIcon(LONG hIcon, boolean destroyIconHandle) throws NativeException, IllegalAccessException {
        ICONINFO info = new ICONINFO();
        if (!User32.GetIconInfo(hIcon, info)) {
            throw new RuntimeException("User32.GetIconInfo: Could not retrieve IconInfo!");
        }
        if (destroyIconHandle) {
            User32.DestroyIcon(hIcon);
        }
        BITMAP hBitmap = new BITMAP();
        Gdi32.GetObject(info.getBitmapColor(), hBitmap.getSizeOf(), hBitmap);
        Pointer bitmap = hBitmap.createBitmapBuffer();
        Gdi32.GetBitmapBits(info.getBitmapColor(), bitmap.getSize(), bitmap);
        int[] pixels = WindowsUtils.nativeImageToJavaImage(bitmap, hBitmap.getWidth(), hBitmap.getHeight());
        MemoryImageSource mis = new MemoryImageSource(hBitmap.getWidth(), hBitmap.getHeight(), pixels, 0, hBitmap.getWidth());
        Image _image = Toolkit.getDefaultToolkit().createImage(mis);
        mis = null;
        pixels = null;
        info.dispose();
        bitmap.dispose();
        hBitmap.getPointer().dispose();
        return new ImageIcon(_image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean takeScreenShotAndWriteToDisk(HWND hwnd, String path, boolean useNative) throws InterruptedException, IllegalAccessException, NativeException, FileNotFoundException, IOException {
        int hbmOld;
        int hbmScreen;
        DC hdcTemp;
        DC hdcScreen;
        Pointer bitmap;
        Pointer bfheader;
        HWND foregroundHWND;
        block26: {
            boolean bl;
            block25: {
                boolean bl2;
                block24: {
                    boolean bl3;
                    block23: {
                        if (hwnd == null || (Integer)hwnd.getValue() == 0) {
                            JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "HWND is null!");
                            return false;
                        }
                        foregroundHWND = User32.GetForegroundWindow();
                        WindowsUtils.SetForegroundWindowEx(hwnd);
                        bfheader = null;
                        bitmap = null;
                        hdcScreen = new DC(0);
                        hdcTemp = new DC(0);
                        hbmScreen = 0;
                        hbmOld = 0;
                        try {
                            while (((Integer)User32.GetForegroundWindow().getValue()).intValue() != ((Integer)hwnd.getValue()).intValue()) {
                                Thread.sleep(10L);
                            }
                            LRECT screenDimension = new LRECT();
                            if (!User32.GetWindowRect(hwnd, screenDimension)) {
                                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "Could not get screenDimension of HWND: " + hwnd);
                                bl3 = false;
                                Object var21_13 = null;
                                break block23;
                            }
                            int width = screenDimension.getWidth();
                            int height = screenDimension.getHeight();
                            hdcScreen = User32.GetWindowDC(hwnd);
                            hdcTemp = Gdi32.CreateCompatibleDC(hdcScreen);
                            hbmScreen = Gdi32.CreateCompatibleBitmap(hdcScreen, width, height);
                            hbmOld = Gdi32.SelectObject(hdcTemp, hbmScreen);
                            if (!Gdi32.BitBlt(hdcTemp, 0, 0, width, height, hdcScreen, 0, 0, 0xCC0020)) {
                                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "BitBlt was not successful!");
                                bl2 = false;
                                break block24;
                            }
                            BITMAPINFOHEADER infobmp = new BITMAPINFOHEADER();
                            infobmp.getPointer().zeroMemory();
                            infobmp.getPointer().setIntAt(0, infobmp.getSizeOf());
                            infobmp.getPointer().setIntAt(4, width);
                            infobmp.getPointer().setIntAt(8, height);
                            infobmp.getPointer().setShortAt(12, (short)1);
                            infobmp.getPointer().setShortAt(14, (short)24);
                            infobmp.getPointer().setIntAt(16, 0);
                            infobmp.getPointer().setIntAt(20, 0);
                            infobmp.getPointer().setIntAt(24, 0);
                            infobmp.getPointer().setIntAt(28, 0);
                            infobmp.getPointer().setIntAt(32, 0);
                            infobmp.getPointer().setIntAt(36, 0);
                            bitmap = new Pointer(MemoryBlockFactory.createMemoryBlock(width * height * 3));
                            if (Gdi32.GetDIBits(hdcTemp, hbmScreen, 0, height, bitmap, infobmp, 0) == 0) {
                                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "GetDIBits was not successful!");
                                bl = false;
                                break block25;
                            }
                            bfheader = new Pointer(MemoryBlockFactory.createMemoryBlock(14));
                            bfheader.setShortAt(0, (short)19778);
                            bfheader.setIntAt(2, bfheader.getSize() + bitmap.getSize() + infobmp.getSizeOf());
                            bfheader.setShortAt(6, (short)0);
                            bfheader.setShortAt(8, (short)0);
                            bfheader.setIntAt(10, bfheader.getSize() + infobmp.getSizeOf());
                            if (useNative) {
                                HANDLE hfile = Kernel32.CreateFile(path, Kernel32.AccessMask.GENERIC_WRITE.getValue(), 0, null, Kernel32.CreationDisposition.OPEN_ALWAYS.getValue(), 0, 0);
                                if (hfile.getValue() != 0) {
                                    try {
                                        DWORD bytesWritten = new DWORD(0);
                                        Kernel32.WriteFile(hfile, bfheader, bfheader.getSize(), bytesWritten, NullPointer.NULL);
                                        Kernel32.WriteFile(hfile, infobmp.getPointer(), infobmp.getPointer().getSize(), bytesWritten, NullPointer.NULL);
                                        Kernel32.WriteFile(hfile, bitmap, bitmap.getSize(), bytesWritten, NullPointer.NULL);
                                        Object var17_25 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var17_26 = null;
                                        Kernel32.CloseHandle(hfile);
                                        throw throwable;
                                    }
                                    Kernel32.CloseHandle(hfile);
                                    break block26;
                                }
                                JNative.getLogger().log(JNativeLogger.SEVERITY.ERROR, "CreateFile was not successful!");
                                break block26;
                            }
                            RandomAccessFile ra = new RandomAccessFile(path, "rw");
                            try {
                                ra.writeShort(StructConverter.swapShort((short)19778));
                                ra.writeInt(StructConverter.swapInt(bfheader.getSize() + bitmap.getSize() + infobmp.getSizeOf()));
                                ra.writeShort(StructConverter.swapShort((short)0));
                                ra.writeShort(StructConverter.swapShort((short)0));
                                ra.writeInt(StructConverter.swapInt(bfheader.getSize() + infobmp.getSizeOf()));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(0)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(4)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(8)));
                                ra.writeShort(StructConverter.swapShort(infobmp.getPointer().getAsShort(12)));
                                ra.writeShort(StructConverter.swapShort(infobmp.getPointer().getAsShort(14)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(16)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(20)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(24)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(28)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(32)));
                                ra.writeInt(StructConverter.swapInt(infobmp.getPointer().getAsInt(36)));
                                ra.write(bitmap.getMemory());
                                Object var19_28 = null;
                                if (ra == null) break block26;
                            }
                            catch (Throwable throwable) {
                                Object var19_29 = null;
                                if (ra == null) throw throwable;
                                ra.close();
                                throw throwable;
                            }
                            ra.close();
                            break block26;
                        }
                        catch (Throwable throwable) {
                            Object var21_17 = null;
                            Gdi32.SelectObject(hdcTemp, hbmOld);
                            Gdi32.DeleteObject(hbmScreen);
                            Gdi32.DeleteDC(hdcTemp);
                            User32.ReleaseDC(hwnd, hdcScreen);
                            if (bitmap != null) {
                                bitmap.dispose();
                            }
                            if (bfheader != null) {
                                bfheader.dispose();
                            }
                            if ((Integer)foregroundHWND.getValue() == 0) throw throwable;
                            if (foregroundHWND.getValue() == hwnd.getValue()) throw throwable;
                            WindowsUtils.SetForegroundWindowEx(foregroundHWND);
                            throw throwable;
                        }
                    }
                    Gdi32.SelectObject(hdcTemp, hbmOld);
                    Gdi32.DeleteObject(hbmScreen);
                    Gdi32.DeleteDC(hdcTemp);
                    User32.ReleaseDC(hwnd, hdcScreen);
                    if (bitmap != null) {
                        bitmap.dispose();
                    }
                    if (bfheader != null) {
                        bfheader.dispose();
                    }
                    if ((Integer)foregroundHWND.getValue() == 0) return bl3;
                    if (foregroundHWND.getValue() == hwnd.getValue()) return bl3;
                    WindowsUtils.SetForegroundWindowEx(foregroundHWND);
                    return bl3;
                }
                Object var21_14 = null;
                Gdi32.SelectObject(hdcTemp, hbmOld);
                Gdi32.DeleteObject(hbmScreen);
                Gdi32.DeleteDC(hdcTemp);
                User32.ReleaseDC(hwnd, hdcScreen);
                if (bitmap != null) {
                    bitmap.dispose();
                }
                if (bfheader != null) {
                    bfheader.dispose();
                }
                if ((Integer)foregroundHWND.getValue() == 0) return bl2;
                if (foregroundHWND.getValue() == hwnd.getValue()) return bl2;
                WindowsUtils.SetForegroundWindowEx(foregroundHWND);
                return bl2;
            }
            Object var21_15 = null;
            Gdi32.SelectObject(hdcTemp, hbmOld);
            Gdi32.DeleteObject(hbmScreen);
            Gdi32.DeleteDC(hdcTemp);
            User32.ReleaseDC(hwnd, hdcScreen);
            if (bitmap != null) {
                bitmap.dispose();
            }
            if (bfheader != null) {
                bfheader.dispose();
            }
            if ((Integer)foregroundHWND.getValue() == 0) return bl;
            if (foregroundHWND.getValue() == hwnd.getValue()) return bl;
            WindowsUtils.SetForegroundWindowEx(foregroundHWND);
            return bl;
        }
        Object var21_16 = null;
        Gdi32.SelectObject(hdcTemp, hbmOld);
        Gdi32.DeleteObject(hbmScreen);
        Gdi32.DeleteDC(hdcTemp);
        User32.ReleaseDC(hwnd, hdcScreen);
        if (bitmap != null) {
            bitmap.dispose();
        }
        if (bfheader != null) {
            bfheader.dispose();
        }
        if ((Integer)foregroundHWND.getValue() == 0) return true;
        if (foregroundHWND.getValue() == hwnd.getValue()) return true;
        WindowsUtils.SetForegroundWindowEx(foregroundHWND);
        return true;
    }

    public static boolean setAlwaysOnTop(HWND hWnd, boolean b) {
        try {
            if (b) {
                return User32.SetWindowPos(hWnd, User32.HWND_TOPMOST, 0, 0, 0, 0, 3);
            }
            return User32.SetWindowPos(hWnd, User32.HWND_NOTOPMOST, 0, 0, 0, 0, 19);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SetForegroundWindowEx(HWND hWnd) throws NativeException, IllegalAccessException {
        int lThreadForeWin;
        int lThreadWindow;
        block3: {
            boolean bl;
            User32.SwitchToThisWindow(hWnd, true);
            WindowsUtils.setAlwaysOnTop(hWnd, true);
            try {
                lThreadWindow = User32.GetWindowThreadProcessId(hWnd);
                lThreadForeWin = User32.GetWindowThreadProcessId(User32.GetForegroundWindow());
                if (lThreadWindow != lThreadForeWin) break block3;
                bl = User32.SetForegroundWindow(hWnd);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                WindowsUtils.setAlwaysOnTop(hWnd, false);
                throw throwable;
            }
            WindowsUtils.setAlwaysOnTop(hWnd, false);
            return bl;
        }
        User32.AttachThreadInput(lThreadForeWin, lThreadWindow, true);
        boolean b = User32.SetForegroundWindow(hWnd);
        User32.AttachThreadInput(lThreadForeWin, lThreadWindow, false);
        boolean bl = b;
        Object var6_6 = null;
        WindowsUtils.setAlwaysOnTop(hWnd, false);
        return bl;
    }

    public static int[] grabImage(ImageIcon icon) throws InterruptedException {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        pg.grabPixels();
        if ((pg.getStatus() & 0x80) != 0) {
            return null;
        }
        return pixels;
    }

    public static LONG CreateIcon(LONG hInstance, int cPlanes, int cBitsPixel, ImageIcon icon) throws InterruptedException, NativeException, IllegalAccessException {
        if (icon == null) {
            return new LONG(0);
        }
        int[] pixels = WindowsUtils.grabImage(icon);
        if (pixels == null) {
            return new LONG(0);
        }
        return User32.CreateIcon(hInstance, icon.getIconWidth(), icon.getIconHeight(), cPlanes, cBitsPixel, pixels, pixels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setSeDebugPrivilege() throws NativeException, IllegalAccessException {
        LONG tmpLuid;
        HANDLE hdlTokenHandle;
        TOKEN_PRIVILEGES tkp;
        block4: {
            boolean bl;
            tkp = new TOKEN_PRIVILEGES();
            HANDLE hdlProcessHandle = Kernel32.GetCurrentProcess();
            if (!Advapi32.OpenProcessToken(hdlProcessHandle, 40, hdlTokenHandle = new HANDLE(0))) {
                return false;
            }
            try {
                tmpLuid = new LONG(0);
                if (Advapi32.LookupPrivilegeValue("", "SeDebugPrivilege", tmpLuid)) break block4;
                bl = false;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Kernel32.CloseHandle(hdlTokenHandle);
                throw throwable;
            }
            Kernel32.CloseHandle(hdlTokenHandle);
            return bl;
        }
        tkp.PrivilegeCount = 1;
        tkp.TheLuid = tmpLuid.getValue();
        tkp.Attributes = 2;
        boolean bl = Advapi32.AdjustTokenPrivileges(hdlTokenHandle, false, tkp);
        Object var6_7 = null;
        Kernel32.CloseHandle(hdlTokenHandle);
        return bl;
    }

    public static Map<DWORD, String> enumerateProcesses(boolean inclucdeSystemProcesses) throws NativeException, IllegalAccessException {
        HashMap<DWORD, String> processes = new HashMap<DWORD, String>();
        if (inclucdeSystemProcesses) {
            PROCESSENTRY32 Pc = new PROCESSENTRY32();
            HANDLE hSnapshot = Kernel32.CreateToolhelp32Snapshot(15, 0);
            if (hSnapshot.getValue() != 0 && Kernel32.Process32First(hSnapshot, Pc)) {
                do {
                    if (Pc.getValueFromPointer().th32ProcessID.getValue() != 0) {
                        processes.put(Pc.th32ProcessID, Pc.szExeFile);
                    }
                    Pc.resetPointer();
                } while (Kernel32.Process32Next(hSnapshot, Pc));
            }
            Kernel32.CloseHandle(hSnapshot);
        } else {
            int[] pids = PsAPI.EnumProcess(1024);
            HANDLE handle = null;
            for (int i = 0; i < pids.length; ++i) {
                handle = Kernel32.OpenProcess(0x1F0FFF, false, pids[i]);
                if (handle.getValue() != 0) {
                    Pointer hModuleEtoile = PsAPI.EnumProcessModules(handle, 1024);
                    if (hModuleEtoile.equals(NullPointer.NULL)) continue;
                    String name = PsAPI.GetModuleBaseName(handle, hModuleEtoile.getAsInt(0), 1024);
                    DWORD dwProcessId = WindowsUtils.getProcessId(name);
                    if (dwProcessId.getValue() != 0) {
                        processes.put(dwProcessId, name);
                    }
                    hModuleEtoile.dispose();
                }
                Kernel32.CloseHandle(handle);
            }
        }
        return processes;
    }

    public static boolean setProcessPriority(String processName, int priority) throws NativeException, IllegalAccessException {
        if (processName == null) {
            return false;
        }
        boolean ret = false;
        DWORD dwProcessId = WindowsUtils.getProcessId(processName);
        if (dwProcessId.getValue() != 0) {
            HANDLE hProc = Kernel32.OpenProcess(0x1F0FFF, false, dwProcessId.getValue());
            if (hProc.getValue() != 0) {
                ret = Kernel32.SetPriorityClass(hProc, new DWORD(priority));
            }
            Kernel32.CloseHandle(hProc);
        }
        return ret;
    }

    public static final DWORD getProcessId(String szExeName) throws NativeException, IllegalAccessException {
        if (szExeName != null) {
            PROCESSENTRY32 Pc = new PROCESSENTRY32();
            HANDLE hSnapshot = Kernel32.CreateToolhelp32Snapshot(15, 0);
            if (hSnapshot.getValue() != 0 && Kernel32.Process32First(hSnapshot, Pc)) {
                do {
                    if (Pc.getValueFromPointer().szExeFile.equalsIgnoreCase(szExeName)) {
                        return Pc.th32ProcessID;
                    }
                    Pc.resetPointer();
                } while (Kernel32.Process32Next(hSnapshot, Pc));
            }
            Kernel32.CloseHandle(hSnapshot);
        }
        return new DWORD(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean attachDllToProcess(String szModuleName, String szProcessName) throws NativeException, IllegalAccessException {
        DWORD dwProcessId = WindowsUtils.getProcessId(szProcessName);
        JNative.getLogger().log("getProcessId: " + dwProcessId.getValue());
        if (dwProcessId.getValue() == 0) return false;
        DWORD ExitCode = new DWORD(0);
        HANDLE hProc = Kernel32.OpenProcess(0x1F0FFF, false, dwProcessId.getValue());
        JNative.getLogger().log("OpenProcess: " + hProc.getValue());
        try {
            int AllocSpace;
            if (hProc.getValue() != 0 && Kernel32.WriteProcessMemory(hProc, AllocSpace = Kernel32.VirtualAllocEx(hProc, 0, szModuleName.length(), new DWORD(4096), new DWORD(4)), Pointer.createPointerFromString(szModuleName), szModuleName.length())) {
                HANDLE thread;
                block6: {
                    boolean bl;
                    thread = Kernel32.CreateRemoteThread(hProc, null, 0, Kernel32.GetProcAddress(new HANDLE(Kernel32.GetModuleHandle("Kernel32")), "LoadLibraryA"), AllocSpace, new DWORD(0), new DWORD(0));
                    JNative.getLogger().log("CreateRemoteThread: " + thread.getValue());
                    try {
                        if (thread.getValue() == 0) break block6;
                        JNative.getLogger().log("WaitForSingleObjectEx:" + Kernel32.WaitForSingleObjectEx(thread, new DWORD(65535), false));
                        JNative.getLogger().log("GetExitCodeThread: " + Kernel32.GetExitCodeThread(thread, ExitCode));
                        bl = true;
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        Kernel32.VirtualFreeEx(hProc, AllocSpace, 0, new DWORD(32768));
                        Kernel32.CloseHandle(thread);
                        throw throwable;
                    }
                    Kernel32.VirtualFreeEx(hProc, AllocSpace, 0, new DWORD(32768));
                    Kernel32.CloseHandle(thread);
                    Object var11_11 = null;
                    Kernel32.CloseHandle(hProc);
                    return bl;
                }
                Object var9_9 = null;
                Kernel32.VirtualFreeEx(hProc, AllocSpace, 0, new DWORD(32768));
                Kernel32.CloseHandle(thread);
            }
            Object var11_12 = null;
            Kernel32.CloseHandle(hProc);
            return false;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Kernel32.CloseHandle(hProc);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean enumerateWindows(final List<HWND> list, final boolean onlyVisible) throws NativeException, IllegalAccessException {
        boolean bl;
        Callback c = null;
        try {
            c = new Callback(){
                private int myAddress = -1;

                public int callback(long[] values) {
                    if (values.length == 2) {
                        try {
                            if (values[0] > 0L) {
                                HWND hwnd = new HWND(Long.valueOf(values[0]).intValue());
                                if (onlyVisible) {
                                    if (User32.IsWindowVisible(hwnd)) {
                                        list.add(hwnd);
                                    }
                                } else {
                                    list.add(hwnd);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return 1;
                    }
                    return 0;
                }

                public int getCallbackAddress() throws NativeException {
                    if (this.myAddress == -1) {
                        this.myAddress = JNative.createCallback(2, this);
                    }
                    return this.myAddress;
                }
            };
            bl = User32.EnumWindows(c, 0);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JNative.releaseCallback(c);
            throw throwable;
        }
        JNative.releaseCallback(c);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean enumerateChildWindows(HWND parent, final List<HWND> list) throws NativeException, IllegalAccessException {
        boolean bl;
        Callback c = null;
        try {
            c = new Callback(){
                private int myAddress = -1;

                public int callback(long[] values) {
                    if (values.length == 2) {
                        try {
                            if (values[0] > 0L) {
                                list.add(new HWND(Long.valueOf(values[0]).intValue()));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return 1;
                    }
                    return 0;
                }

                public int getCallbackAddress() throws NativeException {
                    if (this.myAddress == -1) {
                        this.myAddress = JNative.createCallback(2, this);
                    }
                    return this.myAddress;
                }
            };
            bl = User32.EnumChildWindows(parent, c, 0);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JNative.releaseCallback(c);
            throw throwable;
        }
        JNative.releaseCallback(c);
        return bl;
    }

    public static boolean terminateWin32App(HWND hwnd, DWORD dwTimeout) throws NativeException, IllegalAccessException {
        if (hwnd != null) {
            return WindowsUtils.terminateWin32App(new DWORD(User32.GetWindowThreadProcessId(hwnd)), dwTimeout);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean terminateWin32App(DWORD dwPID, DWORD dwTimeout) throws NativeException, IllegalAccessException {
        Callback c;
        HANDLE hProc;
        block4: {
            boolean bl;
            hProc = Kernel32.OpenProcess(0x100001, false, dwPID.getValue());
            if (hProc.getValue() == 0) {
                return false;
            }
            c = null;
            try {
                c = new Callback(){
                    private int myAddress = -1;
                    private HWND hwnd = null;
                    private int dwID = 0;

                    public int callback(long[] values) {
                        if (values.length == 2) {
                            try {
                                if (values[0] > 0L) {
                                    this.hwnd = new HWND((int)values[0]);
                                    this.dwID = User32.GetWindowThreadProcessId(this.hwnd);
                                    if (this.dwID == (int)values[1]) {
                                        User32.PostMessage(this.hwnd, new UINT(WM.WM_CLOSE.getValue()), new WPARAM(0), new LPARAM(0));
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return 1;
                        }
                        return 0;
                    }

                    public int getCallbackAddress() throws NativeException {
                        if (this.myAddress == -1) {
                            this.myAddress = JNative.createCallback(2, this);
                        }
                        return this.myAddress;
                    }
                };
                User32.EnumWindows(c, dwPID.getValue());
                if (Kernel32.WaitForSingleObjectEx(hProc, dwTimeout, false) == 0) break block4;
                JNative.getLogger().log("Could not cleanly shutdown process with PID " + dwPID + ", forcing termination.");
                bl = Kernel32.TerminateProcess(hProc, 0);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Kernel32.CloseHandle(hProc);
                JNative.releaseCallback(c);
                throw throwable;
            }
            Kernel32.CloseHandle(hProc);
            JNative.releaseCallback(c);
            return bl;
        }
        boolean bl = true;
        Object var6_7 = null;
        Kernel32.CloseHandle(hProc);
        JNative.releaseCallback(c);
        return bl;
    }
}

