/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows.hotkey;

import java.awt.Window;
import java.util.Random;
import java.util.Vector;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.MSG;
import org.xvolks.jnative.misc.basicStructures.HWND;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.misc.basicStructures.LPARAM;
import org.xvolks.jnative.misc.basicStructures.UINT;
import org.xvolks.jnative.misc.basicStructures.WPARAM;
import org.xvolks.jnative.util.Callback;
import org.xvolks.jnative.util.Kernel32;
import org.xvolks.jnative.util.User32;
import org.xvolks.jnative.util.constants.winuser.WM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hotkey
implements Callback,
Runnable {
    public static final int MOD_ALT = 1;
    public static final int MOD_SHIFT = 4;
    public static final int MOD_CONTROL = 2;
    public static final int MOD_WIN = 8;
    private HWND messageWindow = null;
    private static final Vector<Hotkey> hotkeys = new Vector();
    private int myAddress = -1;
    private int iAtom = 0;
    private int prevWndProc = 0;
    private int modifiers = -1;
    private int key = -1;
    private Callback callback = null;
    private boolean isRegistered = false;
    private Thread thread = null;
    private boolean loopStarted = false;
    private Window wind;

    private Hotkey() {
    }

    public Hotkey(int modifiers, int key) {
        this.modifiers = modifiers;
        this.key = key;
    }

    public Hotkey(int modifiers, int key, Callback c) {
        this(modifiers, key);
        this.callback = c;
    }

    @Override
    public void run() {
        try {
            this.createNativeWindow();
            if (this.callback == null) {
                this.setCallback(this);
            }
            this.prevWndProc = User32.SetWindowLong(this.messageWindow, -4, new LONG(this.callback.getCallbackAddress()));
            this.registerHotkeyInternal();
            this.startNativeMessageLoop();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
    }

    public void stopNativeMessageLoop() {
        this.loopStarted = false;
        try {
            User32.PostMessage(this.messageWindow, new UINT(WM.WM_QUIT.getValue()), new WPARAM(this.iAtom), new LPARAM(0));
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NativeException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startNativeMessageLoop() throws NativeException, IllegalAccessException {
        if (this.loopStarted) {
            return;
        }
        this.loopStarted = true;
        try {
            MSG Msg = new MSG();
            while (User32.GetMessage(Msg, this.messageWindow, 0, 0) > 0) {
                User32.TranslateMessage(Msg);
                User32.DispatchMessage(Msg);
                Msg.getPointer().zeroMemory();
            }
            Object var3_2 = null;
            this.loopStarted = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.loopStarted = false;
            throw throwable;
        }
    }

    public static Vector<Hotkey> getInstalledHotkeys() {
        return hotkeys;
    }

    public static final void unregisterAllHotkeys() throws NativeException, IllegalAccessException {
        for (int i = hotkeys.size() - 1; i >= 0; --i) {
            Hotkey k = hotkeys.get(i);
            JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Trying to unregister hotkey: " + k.getKey());
            if (!k.isRegistered()) continue;
            k.unregisterHotkey();
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKey() {
        return this.key;
    }

    public int getPrevWndProc() {
        return this.prevWndProc;
    }

    public int getAtom() {
        return this.iAtom;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public HWND getNativeHWND() {
        return this.messageWindow;
    }

    private void createNativeWindow() throws NativeException, IllegalAccessException {
        this.messageWindow = new HWND(User32.CreateWindowEx(0, "Button", "" + new Random().nextInt(Integer.MAX_VALUE), 0, 0, 0, 0, 0, 0, 0, 0, 0));
    }

    private void destroyNativeWindow() throws NativeException, IllegalAccessException {
        if (this.messageWindow != null) {
            User32.DestroyWindow(this.messageWindow);
        }
        this.messageWindow = null;
    }

    public final void registerHotkey() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    private final boolean registerHotkeyInternal() throws NativeException, IllegalAccessException {
        this.iAtom = Kernel32.GlobalAddAtom("HotKey" + new Random().nextInt(Integer.MAX_VALUE));
        if (this.iAtom != 0) {
            this.isRegistered = User32.RegisterHotKey(this.messageWindow, this.iAtom, this.modifiers, this.key);
            if (this.isRegistered) {
                hotkeys.add(this);
                JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Hotkey: " + this.getKey() + " successfully registered!");
                return true;
            }
            this.unregisterHotkey();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterHotkey() throws NativeException, IllegalAccessException {
        block8: {
            try {
                this.stopNativeMessageLoop();
                if (this.messageWindow != null) {
                    User32.UnregisterHotKey(this.messageWindow, this.iAtom);
                    User32.SetWindowLong(this.messageWindow, -4, new LONG(this.prevWndProc));
                }
                Kernel32.GlobalDeleteAtom(this.iAtom);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.destroyNativeWindow();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (NativeException ex) {
                    ex.printStackTrace();
                }
                this.isRegistered = false;
                this.iAtom = 0;
                this.prevWndProc = 0;
                hotkeys.remove(this);
                JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Hotkey: " + this.getKey() + " unregistered!");
                throw throwable;
            }
            try {
                this.destroyNativeWindow();
                break block8;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                break block8;
            }
            catch (NativeException ex) {
                ex.printStackTrace();
            }
            {
            }
        }
        this.isRegistered = false;
        this.iAtom = 0;
        this.prevWndProc = 0;
        hotkeys.remove(this);
        JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "Hotkey: " + this.getKey() + " unregistered!");
    }

    public void setCallback(Callback c) throws NativeException, IllegalAccessException {
        if (c == null) {
            JNative.getLogger().log("Callback is null!");
            return;
        }
        if (this.callback != null) {
            if (this.messageWindow != null) {
                User32.SetWindowLong(this.messageWindow, -4, new LONG(this.prevWndProc));
            }
            JNative.releaseCallback(this.callback);
        }
        this.callback = c;
    }

    @Override
    public int callback(long[] values) {
        try {
            return User32.CallWindowProc(this.getPrevWndProc(), (int)values[0], (int)values[1], (int)values[2], (int)values[3]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    public int getCallbackAddress() throws NativeException {
        if (this.myAddress == -1) {
            this.myAddress = JNative.createCallback(4, this);
        }
        return this.myAddress;
    }

    public Callback getCallback() {
        return this.callback;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    Hotkey.unregisterAllHotkeys();
                }
                catch (NativeException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

