/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.ResultsUtils;
import org.continuousassurance.swamp.eclipse.StatusChecker;
import org.continuousassurance.swamp.eclipse.ui.SwampPerspective;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.continuousassurance.swamp.eclipse";
    private static String hostname;
    private static boolean loggedIn;
    private static Activator plugin;
    private static final String DEFAULT_HOST = "https://www.mir-swamp.org";
    private static final String HOST_FILENAME = ".host";
    private static final String MARKER_PREFS_FILENAME = ".marker_preferences";
    private static final String UNFINISHED_ASSESS_FILENAME = ".unfinished_assess";
    private static final String FINISHED_ASSESS_FILENAME = ".finished_assess";
    private static StatusChecker sc;
    public static final String SWAMP_PLUGIN_CONSOLE_NAME = "SWAMP Plugin";
    public static final String ENCODING = "UTF-8";
    private static List<Pattern> patterns;
    private static List<String> icons;
    private static final String[] COLORS;
    private static final String[] SHAPES;
    public static final String MARKER_SUFFIX = "-marker";
    public static final String MARKER_PREFIX = "eclipseplugin.";
    private static final String SWAMP_SETTINGS_DIR_NAME = ".SWAMP_SETTINGS";
    private static final String SWAMP_SETTINGS_PATH;
    private static final String CORE_NET_BUNDLE = "org.eclipse.core.net";

    static {
        COLORS = new String[]{"red", "yellow", "green", "black", "blue", "orange", "purple", "gray", "white"};
        SHAPES = new String[]{"circle"};
        SWAMP_SETTINGS_PATH = String.valueOf(System.getProperty("user.home")) + File.separator + SWAMP_SETTINGS_DIR_NAME;
    }

    public void start(BundleContext context) throws Exception {
        IWorkbenchWindow window;
        super.start(context);
        plugin = this;
        String hostnamePath = Activator.getHostnamePath();
        File file = new File(hostnamePath);
        Activator.setLoggedIn(false);
        hostname = DEFAULT_HOST;
        if (file.exists()) {
            InputStreamReader filereader = null;
            BufferedReader reader = null;
            try {
                SwampApiWrapper api;
                filereader = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING);
                reader = new BufferedReader(filereader);
                String host = reader.readLine();
                reader.close();
                if (host != null && !host.equals("") && (api = new SwampApiWrapper()) != null) {
                    hostname = host;
                    Activator.setLoggedIn(api.restoreSession());
                }
            }
            catch (Exception exception) {}
        }
        this.getMarkerPreferences();
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (window = wb.getActiveWorkbenchWindow()) != null) {
            SwampPerspective.initializeFileChangeListener(window);
        }
    }

    private void getMarkerPreferences() {
        String DEFAULT_REGEX = ".*:.*:.*";
        Pattern DEFAULT_PATTERN = Pattern.compile(DEFAULT_REGEX);
        String DEFAULT_COLOR = "black";
        String DEFAULT_SHAPE = "circle";
        String DASH = "-";
        String COMMENT_CHAR = "#";
        String SPACE_SEPARATOR = "  ";
        HashSet<String> VALID_COLORS = new HashSet<String>();
        String[] stringArray = COLORS;
        int n = COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String color = stringArray[n2];
            VALID_COLORS.add(color);
            ++n2;
        }
        patterns = new ArrayList<Pattern>();
        icons = new ArrayList<String>();
        String markerPrefPath = Activator.getMarkerPrefsPath();
        File file = new File(markerPrefPath);
        if (file.exists()) {
            InputStreamReader filereader = null;
            BufferedReader reader = null;
            try {
                filereader = new InputStreamReader((InputStream)new FileInputStream(file), ENCODING);
                reader = new BufferedReader(filereader);
                String ln = reader.readLine();
                while (ln != null) {
                    String[] parts;
                    if (!ln.contains(COMMENT_CHAR) && (parts = ln.split(SPACE_SEPARATOR)).length >= 2) {
                        String regex = parts[0];
                        String figure = parts[1];
                        String[] attr = figure.split(DASH);
                        if (attr.length >= 2) {
                            String color = attr[0];
                            String shape = attr[1];
                            if (Activator.isValidColor(color, VALID_COLORS) && Activator.isValidShape(shape)) {
                                try {
                                    Pattern pattern = Pattern.compile(regex);
                                    patterns.add(pattern);
                                    icons.add(String.valueOf(color.toLowerCase()) + DASH + shape.toLowerCase());
                                }
                                catch (PatternSyntaxException patternSyntaxException) {}
                            }
                        }
                    }
                    ln = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        patterns.add(DEFAULT_PATTERN);
        icons.add(String.valueOf(DEFAULT_COLOR) + DASH + DEFAULT_SHAPE);
    }

    private static boolean isValidShape(String shape) {
        String[] stringArray = SHAPES;
        int n = SHAPES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(shape)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isValidColor(String color, Set<String> validColors) {
        if (color == null) {
            return false;
        }
        return validColors.contains(color.toLowerCase());
    }

    public static void setHostname(String name) {
        hostname = name;
        File f = new File(Activator.getHostnamePath());
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OutputStreamWriter filewriter = null;
        BufferedWriter writer = null;
        try {
            filewriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f), ENCODING);
            writer = new BufferedWriter(filewriter);
            writer.write(name);
            writer.close();
        }
        catch (Exception e) {
            System.err.println("Unable to serialize file");
            e.printStackTrace();
        }
    }

    private static String getHostnamePath() {
        return String.valueOf(SwampApiWrapper.SWAMP_DIR_PATH) + HOST_FILENAME;
    }

    private static String getMarkerPrefsPath() {
        return String.valueOf(SWAMP_SETTINGS_PATH) + File.separator + MARKER_PREFS_FILENAME;
    }

    public static String getUnfinishedAssessmentsPath() {
        return String.valueOf(ResultsUtils.getTopLevelResultsDirectory()) + File.separator + UNFINISHED_ASSESS_FILENAME;
    }

    public static String getFinishedAssessmentsPath() {
        return String.valueOf(ResultsUtils.getTopLevelResultsDirectory()) + File.separator + FINISHED_ASSESS_FILENAME;
    }

    public void stop(BundleContext context) throws Exception {
        if (sc != null) {
            sc.cancel();
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static boolean getLoggedIn() {
        return loggedIn;
    }

    public static void setLoggedIn(boolean loggedIn) {
        if (sc != null && !loggedIn) {
            sc.cancel();
            sc = null;
        } else if (sc == null && loggedIn) {
            sc = new StatusChecker();
            sc.schedule();
        }
        Activator.loggedIn = loggedIn;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getLastHostname() {
        return hostname;
    }

    public static StatusChecker getStatusChecker() {
        return sc;
    }

    public static String getMarkerType(String toolName, String bugGroup, String bugSeverity) {
        String DELIMITER = ":";
        if (bugGroup == null) {
            bugGroup = "";
        }
        String input = String.valueOf(toolName) + DELIMITER + bugGroup + DELIMITER + bugSeverity;
        System.out.println("Input: " + input);
        int i = 0;
        while (i < patterns.size()) {
            if (patterns.get(i).matcher(input).matches()) {
                return MARKER_PREFIX + icons.get(i) + MARKER_SUFFIX;
            }
            ++i;
        }
        System.out.println("Pattern didn't match anything. Should never happen");
        return MARKER_PREFIX + icons.get(icons.size() - 1) + MARKER_SUFFIX;
    }

    public static String[] getValidColors() {
        return COLORS;
    }

    public static String[] getValidShapes() {
        return SHAPES;
    }

    public IProxyService getProxyService() {
        Bundle bundle = Platform.getBundle((String)CORE_NET_BUNDLE);
        while (bundle.getState() != 32) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ServiceReference ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName());
        if (ref != null) {
            return (IProxyService)bundle.getBundleContext().getService(ref);
        }
        return null;
    }
}

