/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.ResultsRetriever;
import org.continuousassurance.swamp.eclipse.exceptions.ResultsRetrievalException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StatusChecker
extends Job {
    private boolean running = true;
    private static final String JOB_NAME = "Status Checker";

    public StatusChecker() {
        super(JOB_NAME);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.schedule(30000L);
        if (StatusChecker.unfinishedAssessmentsExist()) {
            try {
                ResultsRetriever.retrieveResults();
            }
            catch (ResultsRetrievalException resultsRetrievalException) {
                System.err.println("Error in results retrieval");
            }
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.getState() == 4;
    }

    private static boolean unfinishedAssessmentsExist() {
        File f = new File(Activator.getUnfinishedAssessmentsPath());
        return f.length() > 0L;
    }
}

