/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.continuousassurance.swamp.eclipse.ui.SortListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Utils {
    public static String INT_TYPE = "INT";
    public static String STR_TYPE = "STR";

    private Utils() {
    }

    public static String getCurrentTimestamp() {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String timeString = timestamp.toString();
        timeString = timeString.substring(0, timeString.lastIndexOf(46));
        timeString = timeString.replace(" ", "-");
        return timeString;
    }

    public static String getBracketedTimestamp() {
        return "[" + Utils.getCurrentTimestamp() + "] ";
    }

    public static String convertListToDelimitedString(List<String> list, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size() - 1) {
            sb.append(list.get(i));
            sb.append(delimiter);
            ++i;
        }
        sb.append(list.get(list.size() - 1));
        return sb.toString();
    }

    public static List<String> convertDelimitedStringToList(String delimitedString, String delimiter) {
        String[] array = delimitedString.split(delimiter);
        ArrayList<String> list = new ArrayList(array.length);
        list = Arrays.asList(array);
        return list;
    }

    public static int[] convertIntListToArray(List<Integer> list) {
        int size = list.size();
        int[] array = new int[size];
        int i = 0;
        while (i < size) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static List<Integer> convertIntArrayToList(int[] array) {
        int size = array.length;
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        int i = 0;
        while (i < size) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static String[] convertStringListToArray(List<String> list) {
        String[] ary = null;
        if (list != null) {
            ary = new String[list.size()];
            list.toArray(ary);
        }
        return ary;
    }

    public static java.nio.file.Path zipFiles(Set<String> files, String zipFilePath, String zipFileName) {
        String finalPath = String.valueOf(zipFilePath) + File.separator + zipFileName;
        FileOutputStream fileOS = null;
        try {
            fileOS = new FileOutputStream(finalPath);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(fileOS));
            for (String file : files) {
                String lastSegment = new Path(file).lastSegment();
                File f = new File(file);
                System.out.println(file);
                if (f.isDirectory()) {
                    Utils.addEntries(file, lastSegment, out);
                    continue;
                }
                Utils.addFileToZip(file, lastSegment, out);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Paths.get(finalPath, new String[0]);
    }

    private static void addEntries(String pathname, String basePath, ZipOutputStream out) {
        File file = new File(pathname);
        String[] files = file.list();
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String filename = String.valueOf(pathname) + File.separator + files[i];
            File f = new File(filename);
            if (f.isDirectory()) {
                String dirPath = "".equals(basePath) ? files[i] : String.valueOf(basePath) + File.separator + files[i];
                ZipEntry entry = new ZipEntry(String.valueOf(dirPath) + File.separator);
                try {
                    out.putNextEntry(entry);
                    out.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Utils.addEntries(filename, dirPath, out);
            } else {
                System.out.println("File name: " + filename);
                Utils.addFileToZip(filename, String.valueOf(basePath) + File.separator + files[i], out);
            }
            ++i;
        }
    }

    private static void addFileToZip(String pathname, String relPath, ZipOutputStream out) {
        int BUF_SIZE = 2048;
        byte[] data = new byte[BUF_SIZE];
        try {
            int cnt;
            FileInputStream fi = new FileInputStream(pathname);
            BufferedInputStream in = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(relPath);
            out.putNextEntry(entry);
            while ((cnt = in.read(data, 0, BUF_SIZE)) != -1) {
                out.write(data, 0, cnt);
            }
            out.closeEntry();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getProjectDirectory(IProject p) {
        IPath path = p.getLocation();
        return path.lastSegment();
    }

    public static Comparator<TableItem> INT_CMP(final int col) {
        Comparator<TableItem> cmp = new Comparator<TableItem>(){

            @Override
            public int compare(TableItem t1, TableItem t2) {
                int i1 = Utils.getIntValue(t1.getText(col));
                int i2 = Utils.getIntValue(t2.getText(col));
                return Integer.compare(i1, i2);
            }
        };
        return cmp;
    }

    private static int getIntValue(String str) {
        int val = -1;
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {}
        return val;
    }

    public static Comparator<TableItem> STR_CMP(final int col) {
        Comparator<TableItem> cmp = new Comparator<TableItem>(){

            @Override
            public int compare(TableItem t1, TableItem t2) {
                String t1Caps = t1.getText(col).toUpperCase();
                String t2Caps = t2.getText(col).toUpperCase();
                return t1Caps.compareTo(t2Caps);
            }
        };
        return cmp;
    }

    public static Table constructTable(Composite parent) {
        Table table = new Table(parent, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gd);
        return table;
    }

    public static TableColumn addTableColumn(Table table, String name, int width, int index, String type, String ... dataKeys) {
        TableColumn col = new TableColumn(table, 0);
        col.setText(name);
        col.setWidth(width);
        if (type.equals(INT_TYPE)) {
            col.setData(Utils.INT_CMP(index));
        } else {
            col.setData(Utils.STR_CMP(index));
        }
        col.addListener(13, (Listener)new SortListener(dataKeys));
        return col;
    }
}

