/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.util.ArrayList;
import java.util.List;
import org.continuousassurance.scarf.datastructures.BugInstance;
import org.continuousassurance.scarf.datastructures.Location;

public class BugDetail {
    private BugInstance bug;
    private final String platform;
    private final String tool;
    private String filename;
    private String lineNumber;
    private List<String> flow;
    private static String UNSPECIFIED = "?";

    public BugDetail(BugInstance bug, String tool, String platform) {
        this.bug = bug;
        this.platform = platform;
        this.tool = tool;
        this.filename = UNSPECIFIED;
        this.lineNumber = UNSPECIFIED;
        this.flow = new ArrayList<String>();
    }

    private static String formatLineNumber(Location l) {
        int start = l.getStartLine();
        int end = l.getEndLine();
        if (start <= 0) {
            return "";
        }
        if (start == end) {
            return Integer.toString(start);
        }
        return String.valueOf(Integer.toString(start)) + "-" + Integer.toString(end);
    }

    public static String formatSingleLineNumber(int ln) {
        if (ln <= 0) {
            return "";
        }
        return Integer.toString(ln);
    }

    public BugInstance getBugInstance() {
        return this.bug;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getTool() {
        return this.tool;
    }

    public void addLocation(Location l) {
        String fileLocation = String.valueOf(l.getSourceFile()) + ":" + BugDetail.formatLineNumber(l);
        this.flow.add(fileLocation);
    }

    public void setPrimaryFilename(String filename) {
        this.filename = filename;
    }

    public void setPrimaryLineNumber(Location l) {
        this.lineNumber = BugDetail.formatLineNumber(l);
    }

    public List<String> getFlow() {
        return new ArrayList<String>(this.flow);
    }

    public String getPrimaryFilename() {
        return this.filename;
    }

    public String getPrimaryLineNumber() {
        return this.lineNumber;
    }
}

