/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class PackageInfo {
    public static final String PACKAGE_CONF_NAME = "package.conf";
    private static final String MD5_HASH = "MD5";
    private static final String SHA512_HASH = "SHA-512";
    private static final String UTF_8_ENCODING = "UTF-8";

    private static String getDigest(byte[] bytes, MessageDigest m) {
        byte[] retArray = m.digest(bytes);
        return Hex.encodeHexString((byte[])retArray);
    }

    public static File generatePkgConfFile(Path archivePath, String outputDir, String shortName, String version, String pkgDir, String language, String pkgType, String buildSys, String buildDir, String buildFile, String buildTarget, String buildOpts, String configDir, String configCmd, String configOpts) {
        byte[] zipBytes;
        MessageDigest md5 = null;
        MessageDigest sha512 = null;
        try {
            md5 = MessageDigest.getInstance(MD5_HASH);
            sha512 = MessageDigest.getInstance(SHA512_HASH);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        Path path = Paths.get(archivePath.toString(), new String[0]);
        String archiveName = path.getFileName().toString();
        try {
            zipBytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (zipBytes == null) {
            return null;
        }
        String md5hash = PackageInfo.getDigest(zipBytes, md5);
        String sha512hash = PackageInfo.getDigest(zipBytes, sha512);
        File pkgConf = new File(String.valueOf(outputDir) + File.separator + PACKAGE_CONF_NAME);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(pkgConf.getAbsolutePath(), UTF_8_ENCODING);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        writer.println("package-short-name=" + shortName);
        writer.println("package-version=" + version);
        writer.println("package-archive=" + archiveName);
        writer.println("package-archive-md5=" + md5hash);
        writer.println("package-archive-sha512=" + sha512hash);
        writer.println("package-dir=" + pkgDir);
        writer.println("package-language=" + language);
        if (pkgType.equals("java-7") || pkgType.equals("java-8")) {
            writer.println("package-language-version=" + pkgType);
        } else {
            writer.println("package-type=" + pkgType);
        }
        writer.println("build-sys=" + buildSys);
        if (!buildDir.equals("")) {
            System.out.println("Build dir: " + buildDir);
            System.out.println("Build file: " + buildFile);
            System.out.println("Build target: " + buildTarget);
            writer.println("build-dir=" + buildDir);
            writer.println("build-file=" + buildFile);
            writer.println("build-target=" + buildTarget);
            writer.println("build-opt=" + buildOpts);
        }
        if (!configDir.equals("")) {
            writer.println("config-dir=" + configDir);
            writer.println("config-cmd=" + configCmd);
            writer.println("config-opt=" + configOpts);
        }
        writer.close();
        return pkgConf;
    }
}

