/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.continuousassurance.swamp.api.AssessmentRun;
import org.continuousassurance.swamp.api.PackageThing;
import org.continuousassurance.swamp.api.PackageVersion;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.cli.exceptions.IncompatibleAssessmentTupleException;
import org.continuousassurance.swamp.cli.exceptions.InvalidIdentifierException;
import org.continuousassurance.swamp.cli.exceptions.SessionExpiredException;
import org.continuousassurance.swamp.cli.exceptions.SessionRestoreException;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.AssessmentDetails;
import org.continuousassurance.swamp.eclipse.BuildfileGenerator;
import org.continuousassurance.swamp.eclipse.FileSerializer;
import org.continuousassurance.swamp.eclipse.ImprovedClasspathHandler;
import org.continuousassurance.swamp.eclipse.PackageInfo;
import org.continuousassurance.swamp.eclipse.ResultsUtils;
import org.continuousassurance.swamp.eclipse.SubmissionInfo;
import org.continuousassurance.swamp.eclipse.TarUtils;
import org.continuousassurance.swamp.eclipse.Utils;
import org.continuousassurance.swamp.eclipse.dialogs.AuthenticationDialog;
import org.continuousassurance.swamp.eclipse.dialogs.ConfigDialog;
import org.continuousassurance.swamp.eclipse.dialogs.PlatformDialog;
import org.continuousassurance.swamp.eclipse.dialogs.ToolDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Version;

public class SwampSubmitter {
    private MessageConsoleStream out;
    private SwampApiWrapper api;
    private IWorkbenchWindow window;
    private String configFilepath;
    private static final String SWAMP_FAMILY = "SWAMP_FAMILY";
    public static final String SWAMP_RESULTS_DIRNAME = ".SWAMP_RESULTS";
    private static final String CONFIG_FILENAME = "swampconfig.txt";
    private static final String PLUGIN_EXIT_MANUAL = "Status: Plugin exited manually.";
    private static final String SWAMP_JOB_TITLE = "SWAMP Assessment Submission";
    private static final int UNABLE_TO_DESERIALIZE = 0;
    private static final int UNABLE_TO_GENERATE_BUILD = 1;
    private static final int CYCLICAL_DEPENDENCIES = 2;
    private static final String[] FILE_PATTERNS = new String[]{".*\\.xml", "swampbin", "package.conf", ".*\\.zip"};
    private static final int UPLOAD_TICKS = 80;
    private static final int SUBMISSION_TICKS = 10;
    private static final int PKG_CONF_TICKS = 10;
    private static final int ZIP_TICKS = 40;
    private static final int CLEAN_PROJECTS_TICKS = 10;
    public static final int CLASSPATH_ENTRY_TICKS = 5;
    private static final String CONSOLE_NAME = "SWAMP Plugin";

    public SwampSubmitter(IWorkbenchWindow window) {
        this.window = window;
        this.out = this.initializeConsole(CONSOLE_NAME);
    }

    private MessageConsoleStream initializeConsole(String consoleName) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMgr = plugin.getConsoleManager();
        MessageConsole console = new MessageConsole(consoleName, null);
        conMgr.addConsoles(new IConsole[]{console});
        IWorkbenchPage page = this.window.getActivePage();
        try {
            IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
            view.display((IConsole)console);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        MessageConsoleStream stream = console.newMessageStream();
        SwampSubmitter.printInitialInfo(stream);
        return stream;
    }

    private void printToConsole(String msg) {
        if (this.out == null) {
            this.out = this.initializeConsole(CONSOLE_NAME);
        }
        if (this.out != null) {
            this.out.println(msg);
        }
    }

    private void submitPreConfiguredJob(final SubmissionInfo si) {
        Job job = new Job(SWAMP_JOB_TITLE){

            public boolean belongsTo(Object family) {
                return family.equals(SwampSubmitter.SWAMP_FAMILY);
            }

            protected IStatus run(IProgressMonitor monitor) {
                int total = SwampSubmitter.this.calculateTotalTicks(true, 0, si.getSelectedToolIDs().size());
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Packaging project " + si.getProjectName());
                String pluginLoc = si.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
                Date date = new Date();
                String timestamp = date.toString();
                String filename = String.valueOf(timestamp) + "-" + si.getPackageName() + ".tar.gz";
                String archiveName = filename.replace(" ", "-").replace(":", "").toLowerCase();
                HashSet<String> files = new HashSet<String>();
                files.add(si.getProjectPath());
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                subMonitor.split(40);
                Path archivePath = null;
                try {
                    archivePath = TarUtils.createTarGzip(files, pluginLoc, archiveName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                subMonitor.split(10);
                File pkgConf = PackageInfo.generatePkgConfFile(archivePath, pluginLoc, si.getPackageName(), si.getPackageVersion(), ".", si.getPackageLanguage(), si.getPkgConfPackageType(), si.getBuildSystem(), si.getBuildDirectory(), si.getBuildFile(), si.getBuildTarget(), si.getBuildOpts(), si.getConfigDir(), si.getConfigCmd(), si.getConfigOpts());
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Uploading package " + si.getPackageName() + " to SWAMP");
                String prjUUID = si.getSelectedProjectID();
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                subMonitor.split(80);
                String pkgVersUUID = SwampSubmitter.this.uploadPackage(pkgConf.getPath(), archivePath.toString(), prjUUID, si.isNewPackage());
                si.setPackageThing(SwampSubmitter.this.api.getPackageVersion(pkgVersUUID, prjUUID).getPackageThing());
                SwampSubmitter.this.doNewPackageResultsSetup(si.getPackageThingUUID());
                String pkgThingUUID = si.getPackageThingUUID();
                SwampSubmitter.this.setEclipseProjectToPackageThingMapping(pkgThingUUID, si.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString());
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Submitting assessments");
                AssessmentDetails details = new AssessmentDetails(prjUUID, si.getPackageName(), si.getPackageVersion(), si.getProjectName());
                for (String toolUUID : si.getSelectedToolIDs()) {
                    for (String platformUUID : si.getSelectedPlatformIDs()) {
                        subMonitor.split(10);
                        details.setResultsFilepath(ResultsUtils.constructFilepath(prjUUID, pkgThingUUID, toolUUID, platformUUID));
                        details.setToolName(SwampSubmitter.this.api.getTool(toolUUID, prjUUID).getName());
                        details.setPlatformName(SwampSubmitter.this.api.getPlatformVersion(platformUUID).getName());
                        SwampSubmitter.this.submitAssessment(pkgVersUUID, toolUUID, prjUUID, platformUUID, details);
                    }
                }
                IStatus status = Status.OK_STATUS;
                this.done(status);
                return status;
            }
        };
        String pluginLocation = si.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
        job.addJobChangeListener((IJobChangeListener)new JobCancellationListener(pluginLocation, FILE_PATTERNS, this.out));
        job.setRule((ISchedulingRule)si.getProject());
        job.setUser(true);
        job.schedule();
    }

    private void submitAutoGenJob(final SubmissionInfo si) {
        Job job = new Job(SWAMP_JOB_TITLE){

            public boolean belongsTo(Object family) {
                return family.equals(SwampSubmitter.SWAMP_FAMILY);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IJavaProject jp = JavaCore.create((IProject)si.getProject());
                int total = 0;
                int numClasspathEntries = 0;
                IClasspathEntry[] entries = null;
                try {
                    entries = jp.getRawClasspath();
                    numClasspathEntries = entries.length;
                }
                catch (Exception exception) {
                    SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Unable to parse classpath.");
                    Status status = new Status(4, "eclipsepluin", 1, "Unable to generate build for this project", null);
                    this.done((IStatus)status);
                    return status;
                }
                total = SwampSubmitter.this.calculateTotalTicks(false, numClasspathEntries, si.getSelectedToolIDs().size());
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                if (jp.hasClasspathCycle(entries)) {
                    SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Classpath has cyclical dependencies. Please resolve these issues and resubmit.");
                    Status status = new Status(4, "org.continuousassurance.swamp.eclipse", 2, "Project has cyclical dependencies", null);
                    this.done((IStatus)status);
                    return status;
                }
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Generating build file");
                SubMonitor childSubMonitor = subMonitor.split(numClasspathEntries * 5);
                ImprovedClasspathHandler ich = new ImprovedClasspathHandler(jp, null, !si.packageSystemLibraries(), childSubMonitor);
                Set<String> files = ich.getFilesToArchive();
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                System.out.println("Java Classpath: " + System.getProperty("java.classpath"));
                BuildfileGenerator.generateBuildFile(ich, files);
                try {
                    SwampSubmitter.this.cleanProjects(si.getProject());
                }
                catch (CoreException coreException) {
                    SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Unable to clean project or dependent projects. The tools may be unable to assess this package.");
                }
                subMonitor.split(40);
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Packaging project " + si.getProjectName());
                String pluginLoc = ich.getRootProjectPluginLocation();
                Date date = new Date();
                String timestamp = date.toString();
                String filename = String.valueOf(timestamp) + "-" + si.getPackageName() + ".tar.gz";
                String archiveName = filename.replace(" ", "-").replace(":", "").toLowerCase();
                Path archivePath = null;
                try {
                    archivePath = TarUtils.createTarGzip(files, ich.getRootProjectPluginLocation(), archiveName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                subMonitor.split(10);
                File pkgConf = PackageInfo.generatePkgConfFile(archivePath, pluginLoc, si.getPackageName(), si.getPackageVersion(), ".", "Java", si.getPkgConfPackageType(), si.getBuildSystem(), si.getBuildDirectory(), si.getBuildFile(), si.getBuildTarget(), si.getBuildOpts(), si.getConfigDir(), si.getConfigCmd(), si.getConfigOpts());
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Uploading package " + si.getPackageName() + " to SWAMP");
                String prjUUID = si.getSelectedProjectID();
                String pkgVersUUID = SwampSubmitter.this.uploadPackage(pkgConf.getPath(), archivePath.toString(), prjUUID, si.isNewPackage());
                String pkgThingUUID = SwampSubmitter.this.api.getPackageVersion(pkgVersUUID, prjUUID).getPackageThing().getUUIDString();
                si.setPackageThing(SwampSubmitter.this.api.getPackageVersion(pkgVersUUID, prjUUID).getPackageThing());
                SwampSubmitter.this.doNewPackageResultsSetup(pkgThingUUID);
                SwampSubmitter.this.setEclipseProjectToPackageThingMapping(pkgThingUUID, ich.getRootProjectPluginLocation());
                for (ImprovedClasspathHandler i : ich.getDependentProjects()) {
                    SwampSubmitter.this.setEclipseProjectToPackageThingMapping(pkgThingUUID, i.getProjectPluginLocation());
                }
                if (subMonitor.isCanceled()) {
                    IStatus status = Status.CANCEL_STATUS;
                    this.done(status);
                    return status;
                }
                SwampSubmitter.this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Submitting assessments");
                AssessmentDetails details = new AssessmentDetails(prjUUID, si.getPackageName(), si.getPackageVersion(), si.getProjectName());
                for (String toolUUID : si.getSelectedToolIDs()) {
                    for (String platformUUID : si.getSelectedPlatformIDs()) {
                        subMonitor.split(10);
                        details.setResultsFilepath(ResultsUtils.constructFilepath(prjUUID, pkgThingUUID, toolUUID, platformUUID));
                        details.setToolName(SwampSubmitter.this.api.getTool(toolUUID, prjUUID).getName());
                        details.setPlatformName(SwampSubmitter.this.api.getPlatformVersion(platformUUID).getName());
                        SwampSubmitter.this.submitAssessment(pkgVersUUID, toolUUID, prjUUID, platformUUID, details);
                    }
                }
                IStatus status = Status.OK_STATUS;
                this.done(status);
                return status;
            }
        };
        String pluginLocation = si.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
        job.addJobChangeListener((IJobChangeListener)new JobCancellationListener(pluginLocation, FILE_PATTERNS, this.out));
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    private void setEclipseProjectToPackageThingMapping(String pkgThingUUID, String projectPluginLoc) {
        String path = String.valueOf(projectPluginLoc) + File.separator + "eclipse-swamp.txt";
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            OutputStreamWriter filewriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            filewriter.write(pkgThingUUID);
            filewriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doNewPackageResultsSetup(String pkgThingUUID) {
        String dirPath = ResultsUtils.constructFilepath(pkgThingUUID);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private int calculateTotalTicks(boolean autoGen, int numClasspathEntries, int numSubmissions) {
        int total = 0;
        total += 40;
        total += 10;
        total += 80;
        total += numSubmissions * 10;
        if (autoGen) {
            total += 10;
            total += numClasspathEntries * 5;
        }
        return total;
    }

    private void cleanProjects(IProject project) throws CoreException {
        project.build(15, null);
        IProject[] iProjectArray = project.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            this.cleanProjects(p);
            ++n2;
        }
    }

    private String uploadPackage(String pkgConfPath, String archivePath, String prjUUID, boolean newPackage) {
        System.out.println("Uploading package");
        System.out.println("Package-conf directory: " + pkgConfPath);
        System.out.println("Archive directory: " + archivePath);
        System.out.println("Project UUID: " + prjUUID);
        String pkgVersUUID = null;
        try {
            pkgVersUUID = this.api.uploadPackage(pkgConfPath, archivePath, prjUUID, null, newPackage);
        }
        catch (InvalidIdentifierException e) {
            e.printStackTrace();
        }
        if (pkgVersUUID == null) {
            System.err.println("Error in uploading package.");
        }
        return pkgVersUUID;
    }

    private boolean initializeSwampApi() {
        if (this.api != null) {
            return true;
        }
        try {
            System.out.println("Initialized SWAMP API");
            this.api = new SwampApiWrapper();
        }
        catch (Exception e) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: Unable to initialize SWAMP API.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void printInitialInfo(MessageConsoleStream out) {
        Version version = Platform.getBundle((String)"org.eclipse.platform").getVersion();
        String versionStr = "Eclipse";
        versionStr = version != null ? String.valueOf(versionStr) + " " + version.toString() : String.valueOf(versionStr) + " (could not detect version)";
        out.println(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Launched SWAMP plugin - running on " + versionStr + ".");
    }

    public void launchBackgroundAssessment(IProject project) {
        block11: {
            if (!this.initializeSwampApi()) {
                return;
            }
            try {
                if (!this.api.restoreSession() && !this.authenticateUser()) {
                    return;
                }
            }
            catch (Exception exception) {
                if (this.authenticateUser()) break block11;
                return;
            }
        }
        if (project == null) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: No Eclipse project open.");
            return;
        }
        this.configFilepath = String.valueOf(project.getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString()) + File.separator + CONFIG_FILENAME;
        SubmissionInfo si = new SubmissionInfo(this.api);
        if (this.configFilepath == null || !new File(this.configFilepath).exists()) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: No previous assessment found.");
            System.out.println("No previous assessment found at " + this.configFilepath);
            si.initializeProject(project.getName(), project.getLocation().toOSString());
            this.launchConfiguration(si);
        } else if (!FileSerializer.deserializeSubmissionInfo(this.configFilepath, si)) {
            File f = new File(this.configFilepath);
            f.delete();
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Warning: Unable to reload previous assesment. Configuration dialog will popup now.");
            si.initializeProject(project.getName(), project.getLocation().toOSString());
            this.launchConfiguration(si);
        } else if (si.needsBuildFile()) {
            this.submitAutoGenJob(si);
        } else {
            this.submitPreConfiguredJob(si);
        }
    }

    public boolean logIntoSwamp() {
        if (!this.initializeSwampApi()) {
            return false;
        }
        return this.authenticateUser();
    }

    public boolean authenticateUser() {
        AuthenticationDialog ad = new AuthenticationDialog(this.window.getShell(), this.out);
        ad.create();
        if (ad.open() != 0) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: User manually exited login dialog.");
            return false;
        }
        this.api = ad.getSwampApiWrapper();
        Activator.setLoggedIn(true);
        return true;
    }

    private void launchConfiguration(SubmissionInfo si) {
        ArrayDeque<TitleAreaDialog> stack = new ArrayDeque<TitleAreaDialog>();
        si.loadPluginSettings();
        ConfigDialog cd = new ConfigDialog(this.window.getShell(), si);
        ToolDialog td = new ToolDialog(this.window.getShell(), si);
        PlatformDialog pd = new PlatformDialog(this.window.getShell(), si);
        stack.addFirst(pd);
        stack.addFirst(td);
        stack.addFirst(cd);
        while (!stack.isEmpty()) {
            TitleAreaDialog dialog = (TitleAreaDialog)stack.removeFirst();
            int retCode = dialog.open();
            if (retCode == 1) {
                this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + PLUGIN_EXIT_MANUAL);
                return;
            }
            if (retCode != 14) continue;
            stack.addFirst(dialog);
            if (dialog instanceof ToolDialog) {
                stack.addFirst(cd);
                continue;
            }
            stack.addFirst(td);
        }
        si.savePluginSettings();
        this.configFilepath = String.valueOf(si.getProjectWorkingLocation()) + File.separator + CONFIG_FILENAME;
        FileSerializer.serializeSubmissionInfo(this.configFilepath, si);
        if (si.isCProject()) {
            this.submitPreConfiguredJob(si);
        } else if (si.needsBuildFile()) {
            this.submitAutoGenJob(si);
        } else {
            this.submitPreConfiguredJob(si);
        }
    }

    public void launch(IProject project) {
        block6: {
            if (!this.initializeSwampApi()) {
                return;
            }
            try {
                if (!this.api.restoreSession() && !this.authenticateUser()) {
                    return;
                }
            }
            catch (Exception exception) {
                if (this.authenticateUser()) break block6;
                return;
            }
        }
        if (project == null) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: No Eclipse project open.");
            return;
        }
        SubmissionInfo si = new SubmissionInfo(this.api);
        this.configFilepath = String.valueOf(project.getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString()) + File.separator + CONFIG_FILENAME;
        if (this.configFilepath == null || !new File(this.configFilepath).exists() || !FileSerializer.deserializeSubmissionInfo(this.configFilepath, si)) {
            si.initializeProject(project.getName(), project.getLocation().toOSString());
        }
        this.launchConfiguration(si);
    }

    public boolean loggedIntoSwamp() {
        if (!this.initializeSwampApi()) {
            return false;
        }
        try {
            return this.api.restoreSession();
        }
        catch (SessionRestoreException sessionRestoreException) {
            return false;
        }
        catch (SessionExpiredException sessionExpiredException) {
            return false;
        }
    }

    public void logOutOfSwamp() {
        Activator.setLoggedIn(false);
        if (!this.initializeSwampApi()) {
            return;
        }
        this.api.logout();
    }

    private void submitAssessment(String pkgUUID, String toolUUID, String prjUUID, String pltUUID, AssessmentDetails details) {
        String toolName;
        System.out.println("Package UUID: " + pkgUUID);
        System.out.println("Tool UUID: " + toolUUID);
        System.out.println("Project UUID: " + prjUUID);
        System.out.println("Platform UUID: " + pltUUID);
        try {
            toolName = this.api.getTool(toolUUID, prjUUID).getName();
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            toolName = "Invalid tool";
        }
        PackageVersion pkg = this.api.getPackageVersion(pkgUUID, prjUUID);
        assert (pkg != null);
        PackageThing pkgThing = pkg.getPackageThing();
        assert (pkgThing != null);
        String pkgName = pkgThing.getName();
        String platformName = this.api.getPlatformVersion(pltUUID).getName();
        String assessUUID = null;
        try {
            AssessmentRun arun = this.api.runAssessment(pkgUUID, toolUUID, prjUUID, pltUUID);
            assessUUID = arun.getIdentifierString();
        }
        catch (IncompatibleAssessmentTupleException | InvalidIdentifierException e) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: There was an error in uploading assessment for package {" + pkgName + "} with tool {" + toolName + "} on platform {" + platformName + "}");
            System.err.println("Error in running assessment.");
            e.printStackTrace();
            return;
        }
        if (assessUUID == null) {
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: There was an error in uploading assessment for package {" + pkgName + "} with tool {" + toolName + "} on platform {" + platformName + "}");
            System.err.println("Error in running assessment.");
        } else {
            details.setSubmissionTime();
            details.setAssessmentUUID(assessUUID);
            System.out.println("Project UUID: " + prjUUID + " Assessment UUID: " + assessUUID);
            details.setStatus(this.api.getAssessmentRecord(prjUUID, assessUUID).getStatus());
            try {
                SwampSubmitter.appendToUnfinishedFile(details.serialize());
            }
            catch (IOException e) {
                this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Error: There was an error in storing the assessment information for this submission. Your results for this assessment will not show in Eclipse but will show online.");
                e.printStackTrace();
            }
            this.printToConsole(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Successfully submitted assessment with tool {" + toolName + "} on platform {" + platformName + "}");
        }
    }

    private static void appendToUnfinishedFile(String info) throws IOException {
        File file;
        System.out.println("Unfinished assessments located at: " + Activator.getUnfinishedAssessmentsPath());
        File resultsDir = new File(ResultsUtils.getTopLevelResultsDirectory());
        if (!resultsDir.exists()) {
            resultsDir.mkdirs();
        }
        if (!(file = new File(Activator.getUnfinishedAssessmentsPath())).exists()) {
            file.createNewFile();
        }
        OutputStreamWriter filewriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8");
        filewriter.write(info);
        filewriter.close();
    }

    private static class JobCancellationListener
    implements IJobChangeListener {
        private String[] filePatterns;
        private String pluginLocation;
        private MessageConsoleStream out;

        public JobCancellationListener(String location, String[] patterns, MessageConsoleStream stream) {
            this.filePatterns = patterns;
            this.pluginLocation = location;
            this.out = stream;
        }

        public void aboutToRun(IJobChangeEvent arg0) {
        }

        public void awake(IJobChangeEvent arg0) {
        }

        public void done(IJobChangeEvent event) {
            System.out.println("Done!!");
            System.out.println("Event results: " + event.getResult());
            if (event.getResult().getSeverity() == 8) {
                this.out.println(String.valueOf(Utils.getBracketedTimestamp()) + "Status: Submission cancelled by user");
                File f = new File(this.pluginLocation);
                File[] files = f.listFiles();
                if (files != null && files.length > 0) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String fileName = file.getName();
                        String[] stringArray = this.filePatterns;
                        int n3 = this.filePatterns.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String pattern = stringArray[n4];
                            if (fileName.matches(pattern)) {
                                System.out.println("Deleted file name: " + fileName);
                                try {
                                    if (file.isDirectory()) {
                                        FileUtils.deleteDirectory((File)file);
                                        break;
                                    }
                                    FileUtils.forceDelete((File)file);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }

        public void running(IJobChangeEvent arg0) {
        }

        public void scheduled(IJobChangeEvent arg0) {
        }

        public void sleeping(IJobChangeEvent arg0) {
        }
    }
}

