/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import org.continuousassurance.swamp.eclipse.dialogs.ConfigDialog;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdvancedSettingsDialog
extends TitleAreaDialog {
    private Text buildOptText;
    private Text configOptText;
    private Text configScriptText;
    private Button selectFileButton;
    private static final String ADVANCED_SETTINGS_TITLE = "Advanced Settings";
    private static final String BUILD_OPTIONS_HELP = "Add flags to be used when your package is built.";
    private static final String CONFIG_COMMAND_HELP = "Write the command to be used prior to building your package";
    private static final String CONFIG_OPTIONS_HELP = "Add flags to be used when your package is configured.";
    private static final String SELECT_FILE_HELP = "Select your configure script";
    private static final String BUILD_OPTIONS_LABEL = "Build Options: ";
    private static final String CONFIG_SCRIPT_LABEL = "Configuration Script: ";
    private static final String BROWSE_LABEL = "...";
    private static final String CONFIG_OPTIONS_LABEL = "Configuration Options: ";
    private final Shell shell;
    private final ConfigDialog parentDialog;

    public AdvancedSettingsDialog(Shell parentShell, ConfigDialog cd) {
        super(parentShell);
        this.shell = new Shell(parentShell);
        this.parentDialog = cd;
    }

    private void resetWidgets() {
        this.buildOptText.setText("");
        this.configOptText.setText("");
        this.configScriptText.setText("");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        int horizontalSpan = 2;
        this.setTitle(ADVANCED_SETTINGS_TITLE);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(4, false);
        container.setLayout((Layout)layout);
        DialogUtil.initializeLabelWidget(BUILD_OPTIONS_LABEL, 0, container, horizontalSpan);
        this.buildOptText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.buildOptText.setText(this.parentDialog.getBuildOpts());
        this.buildOptText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)BUILD_OPTIONS_HELP));
        DialogUtil.initializeLabelWidget(CONFIG_SCRIPT_LABEL, 0, container, horizontalSpan);
        this.configScriptText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), 1);
        this.configScriptText.setText(this.parentDialog.getConfigScriptPath());
        this.configScriptText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)CONFIG_COMMAND_HELP));
        this.selectFileButton = DialogUtil.initializeButtonWidget(container, BROWSE_LABEL, new GridData(4, 0, false, false), 1);
        this.selectFileButton.addSelectionListener((SelectionListener)new FileSelectionListener());
        this.selectFileButton.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)SELECT_FILE_HELP));
        DialogUtil.initializeLabelWidget(CONFIG_OPTIONS_LABEL, 0, container, horizontalSpan);
        this.configOptText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.configOptText.setText(this.parentDialog.getConfigOpts());
        this.configOptText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)CONFIG_OPTIONS_HELP));
        return area;
    }

    protected void okPressed() {
        this.parentDialog.setBuildOpts(this.buildOptText.getText());
        this.parentDialog.setConfigOpts(this.configOptText.getText());
        this.parentDialog.setConfigScriptPath(this.configScriptText.getText());
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Button button = this.createButton(parent, 3, "Clear", false);
        button.addSelectionListener((SelectionListener)new ClearButtonSelectionListener());
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    private class ClearButtonSelectionListener
    implements SelectionListener {
        private ClearButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AdvancedSettingsDialog.this.resetWidgets();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class FileSelectionListener
    implements SelectionListener {
        private FileSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(AdvancedSettingsDialog.this.shell);
            String rc = dialog.open();
            if (rc != null) {
                AdvancedSettingsDialog.this.configScriptText.setText(rc);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

