/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.continuousassurance.swamp.api.Platform;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.SubmissionInfo;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PlatformDialog
extends TitleAreaDialog {
    private List<Platform> platforms;
    private org.eclipse.swt.widgets.List swtPlatformList;
    private SwampApiWrapper api;
    private SubmissionInfo submissionInfo;
    private Shell shell;
    private static final String PLATFORM_TITLE = "Platform Selection";
    private static final String PLATFORM_HELP = "Select one or more platforms to run your assessment on.";
    private static final String PLATFORMS_LABEL = "Platforms: ";

    public PlatformDialog(Shell parentShell, SubmissionInfo si) {
        super(parentShell);
        this.shell = parentShell;
        this.submissionInfo = si;
        this.api = this.submissionInfo.getApi();
    }

    protected Control createDialogArea(Composite parent) {
        System.out.println("We're redrawing the platform dialog");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        this.setTitle(PLATFORM_TITLE);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        DialogUtil.initializeLabelWidget(PLATFORMS_LABEL, 0, container);
        this.platforms = this.getPlatforms(this.submissionInfo.getPackageType());
        this.swtPlatformList = DialogUtil.initializeListWidget(container, new GridData(4, 0, true, false), this.convertPlatformListToStringArray());
        this.swtPlatformList.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)PLATFORM_HELP));
        if (this.submissionInfo.platformsInitialized()) {
            System.out.println("Platforms Initialized");
            List<String> platformUUIDs = this.submissionInfo.getSelectedPlatformIDs();
            this.setSelectedPlatforms(platformUUIDs);
        } else {
            this.swtPlatformList.selectAll();
        }
        return area;
    }

    private List<Platform> getPlatforms(String pkgType) {
        String GCC_WARN_TOOL_UUID = "7A08B82D-3A3B-45CA-8644-105088741AF6";
        ArrayList<Platform> platformList = null;
        if (pkgType.equals("C/C++")) {
            platformList = this.api.getSupportedPlatforms(GCC_WARN_TOOL_UUID, this.submissionInfo.getSelectedProjectID());
        } else {
            platformList = new ArrayList();
            Platform p = this.api.getDefaultPlatform(pkgType);
            platformList.add(p);
        }
        return platformList;
    }

    private String[] convertPlatformListToStringArray() {
        int numPlatforms = this.platforms.size();
        String[] platformArray = new String[numPlatforms];
        int i = 0;
        while (i < numPlatforms) {
            platformArray[i] = this.platforms.get(i).getName();
            ++i;
        }
        return platformArray;
    }

    private void setSelectedPlatforms(List<String> platformUUIDs) {
        int count = 0;
        int numIDs = platformUUIDs.size();
        int i = 0;
        while (i < this.platforms.size() && count < numIDs) {
            String id = this.platforms.get(i).getUUIDString();
            if (platformUUIDs.contains(id)) {
                this.swtPlatformList.select(i);
                ++count;
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Button clear = this.createButton(parent, 3, "Clear", false);
        clear.addSelectionListener((SelectionListener)new ClearButtonSelectionListener());
        this.createButton(parent, 14, "Back", false);
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    public void buttonPressed(int buttonID) {
        switch (buttonID) {
            case 0: {
                this.okPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
    }

    protected void backPressed() {
        this.submissionInfo.setSelectedPlatformIDs(this.getSelectedIDs());
        super.setReturnCode(14);
        super.close();
    }

    protected void okPressed() {
        if (this.swtPlatformList.getSelectionCount() < 1) {
            this.setMessage("Select at least one platform.");
        }
        this.submissionInfo.setSelectedPlatformIDs(this.getSelectedIDs());
        super.okPressed();
    }

    private List<String> getSelectedIDs() {
        int[] selectedIndices = this.swtPlatformList.getSelectionIndices();
        ArrayList<String> selectedPlatformIDs = new ArrayList<String>(selectedIndices.length);
        int[] nArray = selectedIndices;
        int n = selectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Platform platform = this.platforms.get(i);
            selectedPlatformIDs.add(platform.getUUIDString());
            ++n2;
        }
        return selectedPlatformIDs;
    }

    private class ClearButtonSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            PlatformDialog.this.swtPlatformList.deselectAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

