/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.ui;

import org.continuousassurance.swamp.eclipse.BugDetail;
import org.continuousassurance.swamp.eclipse.Controller;
import org.continuousassurance.swamp.eclipse.Utils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class TableView
extends ViewPart {
    public static final String[] COLUMN_NAMES = new String[]{"File", "Start Line", "End Line", "Group", "Tool", "Platform"};
    private static final int[] COLUMN_WIDTHS = new int[]{400, 50, 50, 400, 200, 200};
    private static final String[] COLUMN_TYPES = new String[]{Utils.STR_TYPE, Utils.INT_TYPE, Utils.INT_TYPE, Utils.STR_TYPE, Utils.STR_TYPE, Utils.STR_TYPE};
    private Table table;
    public static final String ID = "org.continuousassurance.swamp.eclipse.ui.views.tableview";
    private Action showAllAction;

    public Table getTable() {
        return this.table;
    }

    public void createPartControl(Composite parent) {
        System.out.println("Table View actually created");
        this.table = Utils.constructTable(parent);
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            Utils.addTableColumn(this.table, COLUMN_NAMES[i], COLUMN_WIDTHS[i], i, COLUMN_TYPES[i], "marker", "bugdetail");
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)new RowSelectionListener(this.table));
        this.table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = TableView.this.table.getSelection();
                if (items.length > 0) {
                    TableItem item = items[0];
                    IMarker marker = (IMarker)item.getData("marker");
                    Controller.jumpToLocation(marker);
                }
            }
        });
        Controller.refreshWorkspace();
        this.createActions();
        this.createToolbar();
    }

    public void resetTable() {
        if (this.table != null) {
            this.table.removeAll();
        }
    }

    private void createActions() {
        this.showAllAction = new Action("Show All/Show File"){

            public void run() {
                Controller.toggleShowAll();
                Controller.refreshWorkspace();
            }
        };
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.showAllAction);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    private static class RowSelectionListener
    implements SelectionListener {
        private Table table;

        public RowSelectionListener(Table t) {
            this.table = t;
        }

        public void widgetSelected(SelectionEvent event) {
            TableItem[] items = this.table.getSelection();
            if (items.length > 0) {
                TableItem selectedRow = items[0];
                BugDetail details = (BugDetail)selectedRow.getData("bugdetail");
                Controller.updateDetailView(details);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }
}

