/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.continuousassurance.scarf.datastructures.BugInstance;
import org.continuousassurance.scarf.datastructures.Location;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.BugDetail;
import org.continuousassurance.swamp.eclipse.ResultsParser;
import org.continuousassurance.swamp.eclipse.ResultsUtils;
import org.continuousassurance.swamp.eclipse.handlers.HandlerUtilityMethods;
import org.continuousassurance.swamp.eclipse.ui.DetailView;
import org.continuousassurance.swamp.eclipse.ui.SortListener;
import org.continuousassurance.swamp.eclipse.ui.StatusView;
import org.continuousassurance.swamp.eclipse.ui.TableView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class Controller {
    public static final String MARKER_OBJ = "marker";
    public static final String BUG_DETAIL_OBJ = "bugdetail";
    public static boolean showAll = true;

    public static IViewPart getView(IWorkbenchWindow window, String viewID) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return Controller.getView(page, viewID);
    }

    public static IViewPart getView(IWorkbenchPage page, String viewID) {
        IViewReference[] refs;
        IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(viewID)) {
                IViewPart view = ref.getView(false);
                return view;
            }
            ++n2;
        }
        return null;
    }

    public static void toggleShowAll() {
        showAll = !showAll;
    }

    public static IEditorPart getEditor(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return Controller.getEditor(page);
    }

    public static IEditorPart getEditor(IWorkbenchPage page) {
        return page.getActiveEditor();
    }

    public static boolean swampPerspectiveOpen(IWorkbenchPage page) {
        IPerspectiveDescriptor pd = page.getPerspective();
        if (pd == null) {
            return false;
        }
        return pd.getId().equals("org.continuousassurance.swamp.eclipse.ui.perspective");
    }

    public static void refreshWorkspace() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return;
        }
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        Controller.resetPerspectiveParts(window, page);
        IProject project = HandlerUtilityMethods.getActiveProject(window);
        if (project == null) {
            System.out.println("Project null");
            return;
        }
        System.out.println("Refreshing workspace with project " + project.getName());
        String path = String.valueOf(project.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString()) + '/' + "eclipse-swamp.txt";
        File f = new File(path);
        if (f.exists()) {
            String pkgThingUUID = "";
            InputStreamReader filereader = null;
            BufferedReader reader = null;
            try {
                filereader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                reader = new BufferedReader(filereader);
                pkgThingUUID = reader.readLine();
                reader.close();
            }
            catch (Exception exception) {
                System.err.println("Exception occured");
                return;
            }
            File resultsDir = new File(ResultsUtils.constructFilepath(pkgThingUUID));
            File[] files = resultsDir.listFiles();
            if (files != null && files.length > 0) {
                TableColumn col;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File r = fileArray[n2];
                    ArrayList<BugInstance> bugs = new ArrayList<BugInstance>();
                    ResultsParser rp = new ResultsParser(r);
                    if (showAll) {
                        bugs.addAll(rp.getAllBugs());
                    } else {
                        IFile file = HandlerUtilityMethods.getActiveFile(window);
                        String filepath = Controller.eclipseToSCARFFilepath(file);
                        bugs.addAll(rp.getFileBugs(filepath));
                    }
                    Controller.updateEditorAndViews(page, bugs, rp.getToolName(), rp.getPlatformName());
                    ++n2;
                }
                Table table = Controller.getTable(page);
                if (table != null && (col = table.getSortColumn()) != null) {
                    SortListener.sortByCol(col);
                }
            }
        }
    }

    private static String eclipseToSCARFFilepath(IFile file) {
        String filepath = file.getFullPath().toString();
        return filepath.substring(1);
    }

    private static IFile SCARFtoEclipseFile(String filepath) {
        Path path = new Path(filepath);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }

    private static Table getTable(IWorkbenchPage page) {
        if (page == null) {
            return null;
        }
        TableView view = (TableView)Controller.getView(page, "org.continuousassurance.swamp.eclipse.ui.views.tableview");
        if (view == null) {
            return null;
        }
        return view.getTable();
    }

    private static void updateEditorAndViews(IWorkbenchPage page, List<BugInstance> bugs, String toolName, String platformName) {
        Table table = Controller.getTable(page);
        System.out.println("Is table null? " + (table == null));
        ArrayList<TableItem> rows = new ArrayList<TableItem>();
        HashMap<String, IFile> filePathToEclipseFile = new HashMap<String, IFile>();
        for (BugInstance bug : bugs) {
            BugDetail details = new BugDetail(bug, toolName, platformName);
            TableItem item = null;
            if (table != null) {
                item = new TableItem(table, 0);
            }
            for (Location loc : bug.getLocations()) {
                if (loc.isPrimary()) {
                    IFile file = null;
                    IMarker marker = null;
                    String filename = loc.getSourceFile();
                    if (filePathToEclipseFile.containsKey(filename)) {
                        file = (IFile)filePathToEclipseFile.get(filename);
                    } else {
                        file = Controller.SCARFtoEclipseFile(filename);
                        System.out.println("Found the matching file: " + file);
                        filePathToEclipseFile.put(filename, file);
                    }
                    if (file != null) {
                        marker = Controller.createMarkerForResource(file, loc, bug, toolName);
                    }
                    if (table != null) {
                        details.setPrimaryFilename(filename);
                        details.setPrimaryLineNumber(loc);
                        item.setText(0, filename);
                        item.setText(1, BugDetail.formatSingleLineNumber(loc.getStartLine()));
                        item.setText(2, BugDetail.formatSingleLineNumber(loc.getEndLine()));
                        if (bug.getBugGroup() != null) {
                            item.setText(3, bug.getBugGroup());
                        } else {
                            item.setText(3, "");
                        }
                        item.setText(4, toolName);
                        item.setText(5, platformName);
                        if (marker != null) {
                            item.setData(MARKER_OBJ, (Object)marker);
                        }
                    }
                }
                details.addLocation(loc);
            }
            if (table != null) {
                item.setData(BUG_DETAIL_OBJ, (Object)details);
            }
            rows.add(item);
        }
        Controller.resetDetailView(page);
    }

    private static IMarker createMarkerForResource(IFile resource, Location l, BugInstance bug, String toolName) {
        try {
            String markerType = Activator.getMarkerType(toolName, bug.getBugGroup(), bug.getBugSeverity());
            System.out.println("MARKER TYPE: " + markerType);
            IMarker marker = resource.createMarker(markerType);
            marker.setAttribute("message", (Object)(String.valueOf(toolName) + ": " + bug.getBugMessage()));
            marker.setAttribute("severity", 1);
            marker.setAttribute("lineNumber", l.getStartLine());
            return marker;
        }
        catch (CoreException e) {
            System.err.println("Core exception when creating marker");
            e.printStackTrace();
            return null;
        }
    }

    private static void resetPerspectiveParts(IWorkbenchWindow window, IWorkbenchPage page) {
        Controller.resetFileMarkers(window);
        Controller.resetTableView(page);
        Controller.resetDetailView(page);
    }

    private static void resetTableView(IWorkbenchPage page) {
        TableView view = (TableView)Controller.getView(page, "org.continuousassurance.swamp.eclipse.ui.views.tableview");
        if (view != null) {
            view.resetTable();
        }
    }

    private static void resetDetailView(IWorkbenchPage page) {
        DetailView view = (DetailView)Controller.getView(page, "org.continuousassurance.swamp.eclipse.ui.views.detailview");
        if (view != null) {
            view.reset();
        }
    }

    public static void resetFileMarkers(IWorkbenchWindow window) {
        String DASH = "-";
        System.out.println("Attempting to reset file markers");
        IFile file = HandlerUtilityMethods.getActiveFile(window);
        if (file != null) {
            System.out.println("Removing file markers for file " + file.getName());
            try {
                String[] stringArray = Activator.getValidColors();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String color = stringArray[n2];
                    String[] stringArray2 = Activator.getValidShapes();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String shape = stringArray2[n4];
                        String markerType = "eclipseplugin." + color + DASH + shape + "-marker";
                        file.deleteMarkers(markerType, true, 1);
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("File is null");
        }
    }

    public static void updateDetailView(BugDetail bug) {
        DetailView view;
        IWorkbenchWindow window;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (window = wb.getActiveWorkbenchWindow()) != null && (view = (DetailView)Controller.getView(window, "org.continuousassurance.swamp.eclipse.ui.views.detailview")) != null) {
            view.update(bug);
        }
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        return wb.getActiveWorkbenchWindow();
    }

    public static void jumpToLocation(IMarker marker) {
        if (marker == null || marker.getAttribute("lineNumber", 0) == 0) {
            return;
        }
        IWorkbenchWindow window = Controller.getActiveWorkbenchWindow();
        if (window != null) {
            IFile file = (IFile)marker.getResource();
            IEditorPart editor = null;
            try {
                editor = IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (editor != null) {
                System.out.println("Going to marker at: " + marker.getAttribute("lineNumber", 0));
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
        }
    }

    public static void updateStatusView(List<String> statuses) {
        StatusView view;
        IWorkbenchWindow window = Controller.getActiveWorkbenchWindow();
        if (window != null && (view = (StatusView)Controller.getView(window, "org.continuousassurance.swamp.eclipse.ui.views.statusview")) != null) {
            view.addRowsToStatusTable(statuses);
        }
    }
}

