/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.continuousassurance.scarf.datastructures.BugInstance;
import org.continuousassurance.scarf.datastructures.BugSummary;
import org.continuousassurance.scarf.datastructures.InitialInfo;
import org.continuousassurance.scarf.datastructures.Location;
import org.continuousassurance.scarf.datastructures.Metric;
import org.continuousassurance.scarf.datastructures.MetricSummary;
import org.continuousassurance.scarf.parser.ScarfInterface;
import org.continuousassurance.scarf.parser.ScarfXmlReader;
import org.continuousassurance.swamp.eclipse.ResultsUtils;

public class ResultsParser
implements ScarfInterface {
    private InitialInfo info;
    private List<BugInstance> bugs;
    private List<Metric> metrics;
    private List<MetricSummary> metricSummaries;
    private List<BugSummary> bugSummaries;
    private String tool;
    private String platform;
    private Map<String, List<BugInstance>> fileBugs;

    public ResultsParser(File f) {
        ScarfXmlReader reader = new ScarfXmlReader((ScarfInterface)this);
        this.bugs = new ArrayList<BugInstance>();
        this.metrics = new ArrayList<Metric>();
        this.metricSummaries = new ArrayList<MetricSummary>();
        this.bugSummaries = new ArrayList<BugSummary>();
        this.fileBugs = new HashMap<String, List<BugInstance>>();
        reader.parseFromFile(f);
    }

    public void initialCallback(InitialInfo initial) {
        this.info = initial;
        this.tool = String.valueOf(this.info.getToolName()) + " " + this.info.getToolVersion();
        this.platform = this.info.getPlatformName();
    }

    public void bugCallback(BugInstance bug) {
        for (Location l : bug.getLocations()) {
            if (!l.isPrimary()) continue;
            String filename = l.getSourceFile();
            filename = ResultsParser.normalizeFilepath(filename);
            l.setSourceFile(filename);
            this.bugs = this.fileBugs.containsKey(filename) ? this.fileBugs.get(filename) : new ArrayList<BugInstance>();
            this.bugs.add(bug);
            this.fileBugs.put(filename, this.bugs);
            break;
        }
    }

    public List<BugInstance> getAllBugs() {
        ArrayList<BugInstance> bugs = new ArrayList<BugInstance>();
        for (String filename : this.fileBugs.keySet()) {
            bugs.addAll((Collection<BugInstance>)this.fileBugs.get(filename));
        }
        return bugs;
    }

    private static String normalizeFilepath(String fp) {
        String[] parts;
        String PKG_STR = "pkg1";
        String DOT = ".";
        String TWO_DOT = "..";
        if (fp == null) {
            return "";
        }
        int idx = fp.indexOf(PKG_STR);
        if (idx > -1) {
            fp = fp.substring(idx + PKG_STR.length() + 1);
        }
        ArrayDeque<String> filepath = new ArrayDeque<String>();
        String[] stringArray = parts = fp.split(ResultsUtils.SEPARATOR);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!part.equals(DOT)) {
                if (part.equals(TWO_DOT)) {
                    filepath.removeLast();
                } else {
                    filepath.addLast(part);
                }
            }
            ++n2;
        }
        StringBuffer sb = new StringBuffer();
        for (String s : filepath) {
            sb.append(s);
            sb.append(ResultsUtils.SEPARATOR);
        }
        String normalizedPath = sb.toString();
        return normalizedPath.substring(0, normalizedPath.length() - 1);
    }

    public void metricCallback(Metric metric) {
        this.metrics.add(metric);
    }

    public void metricSummaryCallback(MetricSummary summary) {
        this.metricSummaries.add(summary);
    }

    public void bugSummaryCallback(BugSummary summary) {
        this.bugSummaries.add(summary);
    }

    public List<BugInstance> getFileBugs(String filename) {
        if (this.fileBugs.containsKey(filename)) {
            return this.fileBugs.get(filename);
        }
        return new ArrayList<BugInstance>();
    }

    public String getToolName() {
        return this.tool;
    }

    public String getPlatformName() {
        return this.platform;
    }

    public void finalCallback() {
        System.out.println("Final callback");
    }
}

