/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.util.List;
import org.continuousassurance.swamp.api.PackageThing;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.Utils;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SubmissionInfo {
    private boolean configInitialized;
    private String selectedProjectID;
    private List<String> selectedToolIDs;
    private List<String> selectedPlatformIDs;
    private boolean newPackage;
    private boolean createBuildFile;
    private boolean packageSystemLibs;
    private String packageType;
    private IProject[] eclipseProjects;
    private String packageName;
    private PackageThing packageThing;
    private String packageVersion;
    private String buildSystem;
    private String buildDirectory;
    private String buildFile;
    private String buildTarget;
    private IProject project;
    private String buildOpts;
    private String configOpts;
    private String configCmd;
    private String configDir;
    private List<? extends PackageThing> packages;
    private String selectedPackageThingID;
    private SwampApiWrapper api;
    public static final String JAVA_8_SRC = "Java 8 Source Code";
    public static final String JAVA_7_SRC = "Java 7 Source Code";
    public static final String JAVA_8_BYTE = "Java 8 Bytecode";
    public static final String JAVA_7_BYTE = "Java 7 Bytecode";
    public static final String C_CPP = "C/C++";
    public static final String NO_BUILD_STRING = "no-build";
    public static final String AUTO_GENERATE_BUILD_STRING = "Auto-generate build file";
    public static final String ECLIPSE_GENERATED_STRING = "Eclipse-generated makefile";
    private static final String[] javaBuildOptions = new String[]{"Auto-generate build file", "android+ant", "android+ant+ivy", "android+gradle", "android+maven", "ant", "ant+ivy", "gradle", "java-bytecode", "make", "maven", "no-build", "other"};
    private static final String[] cppBuildOptions = new String[]{"Eclipse-generated makefile", "cmake+make", "configure+make", "make", "no-build", "other"};
    private static final String PROJECT_KEY = "PROJECT";
    private static final String DELIMITER = ",";
    private static final String[] javaPkgTypeOptions = new String[]{"Java 8 Source Code", "Java 7 Source Code", "Java 8 Bytecode", "Java 7 Bytecode"};
    private static final String[] cppPkgTypeOptions = new String[]{"C/C++"};
    private static final String PKG_CONF_JAVA8 = "java-8";
    private static final String PKG_CONF_JAVA7 = "java-7";
    private static final String PKG_CONF_CCPP = "C/C++";
    private static final String TOOLS_PREFERENCE_SUFFIX = "-TOOLS";
    private static final String PLATFORMS_PREFERENCE_SUFFIX = "-PLATFORMS";
    private static final String JAVA_LANG = "JAVA";
    private static final String CCPP_LANG = "C/C++";

    public SubmissionInfo(SwampApiWrapper api) {
        this.api = api;
        this.packageVersion = Utils.getCurrentTimestamp();
        this.selectedProjectID = null;
        this.selectedToolIDs = null;
        this.selectedPlatformIDs = null;
        this.buildOpts = "";
        this.configOpts = "";
        this.configCmd = "";
        this.configDir = "";
    }

    public boolean isConfigInitialized() {
        return this.configInitialized;
    }

    public void setConfigInitialized(boolean b) {
        this.configInitialized = b;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getPkgConfPackageType() {
        if (this.packageType.equals(JAVA_8_SRC) || this.packageType.equals(JAVA_8_BYTE)) {
            return PKG_CONF_JAVA8;
        }
        if (this.packageType.equals(JAVA_7_SRC) || this.packageType.equals(JAVA_7_BYTE)) {
            return PKG_CONF_JAVA7;
        }
        return "C/C++";
    }

    public String getPackageLanguage() {
        String CPP_LANG = "C++";
        String C_LANG = "C";
        String JAVA = "Java";
        if (CoreModel.hasCCNature((IProject)this.project)) {
            return CPP_LANG;
        }
        if (CoreModel.hasCNature((IProject)this.project)) {
            return C_LANG;
        }
        return JAVA;
    }

    public void setPackageType(String pkgType, boolean fromFile) {
        this.packageType = pkgType;
        if (fromFile) {
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.continuousassurance.swamp.eclipse");
        this.selectedToolIDs = this.getPreferences((Preferences)prefs, this.getToolKey());
        this.selectedPlatformIDs = this.getPreferences((Preferences)prefs, this.getPlatformKey());
    }

    private List<String> getPreferences(Preferences prefs, String key) {
        String idList = prefs.get(key, null);
        if (idList == null) {
            return null;
        }
        return Utils.convertDelimitedStringToList(idList, DELIMITER);
    }

    public SwampApiWrapper getApi() {
        return this.api;
    }

    public boolean toolsInitialized() {
        return this.selectedToolIDs != null;
    }

    public boolean platformsInitialized() {
        return this.selectedPlatformIDs != null;
    }

    public static String[] getBuildSystemList(String lang) {
        switch (lang.toUpperCase()) {
            case "JAVA": {
                return javaBuildOptions;
            }
            case "C/C++": {
                return cppBuildOptions;
            }
        }
        return new String[0];
    }

    public static String[] getPackageTypeList(String lang) {
        switch (lang.toUpperCase()) {
            case "JAVA": {
                return javaPkgTypeOptions;
            }
            case "C/C++": {
                return cppPkgTypeOptions;
            }
        }
        return new String[0];
    }

    public void setSelectedPlatformIDs(List<String> platformIDs) {
        this.selectedPlatformIDs = platformIDs;
    }

    public List<String> getSelectedPlatformIDs() {
        return this.selectedPlatformIDs;
    }

    public void setSelectedToolIDs(List<String> toolIDs) {
        this.selectedToolIDs = toolIDs;
    }

    public List<String> getSelectedToolIDs() {
        return this.selectedToolIDs;
    }

    public void setSelectedProjectID(String projectID) {
        this.selectedProjectID = projectID;
    }

    public String getSelectedProjectID() {
        return this.selectedProjectID;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isNewPackage() {
        return this.newPackage;
    }

    public boolean isCProject() {
        return CoreModel.hasCCNature((IProject)this.project) || CoreModel.hasCNature((IProject)this.project);
    }

    public void setNewPackage(boolean isNew) {
        this.newPackage = isNew;
    }

    public String getSelectedPackageID() {
        return this.selectedPackageThingID;
    }

    public boolean setSelectedPackageID(String pkgUUID) {
        this.selectedPackageThingID = pkgUUID;
        if (this.packages == null) {
            this.packages = this.api.getPackagesList(this.selectedProjectID);
        }
        int i = 0;
        while (i < this.packages.size()) {
            PackageThing pt = this.packages.get(i);
            if (pt.getIdentifierString().equals(pkgUUID)) {
                this.packageThing = pt;
                this.packageName = pt.getName();
                return true;
            }
            ++i;
        }
        this.packageThing = null;
        return false;
    }

    public boolean setPackageIDFromName(String pkgName) {
        if (this.packages == null) {
            this.packages = this.api.getPackagesList(this.selectedProjectID);
        }
        int i = 0;
        while (i < this.packages.size()) {
            PackageThing pt = this.packages.get(i);
            System.out.println(pt.getName());
            if (pt.getName().equals(pkgName)) {
                this.packageThing = pt;
                this.selectedPackageThingID = pt.getUUIDString();
                this.packageName = pt.getName();
                return true;
            }
            ++i;
        }
        this.packageThing = null;
        return false;
    }

    public boolean initializeProject(String projectName, String prjPath) {
        this.eclipseProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < this.eclipseProjects.length) {
            IProject project = this.eclipseProjects[i];
            if (project.getName().equals(projectName) && project.getLocation().toOSString().equals(prjPath)) {
                this.project = project;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isProjectInitialized() {
        return this.project != null;
    }

    public void setProject(IProject p) {
        this.project = p;
    }

    public boolean packageSystemLibraries() {
        return this.packageSystemLibs;
    }

    public void setBuildInfo(String buildSys, boolean needsBuildFile, String buildDir, String buildFile, String target, String buildOptions, boolean packageRTLibs) {
        this.createBuildFile = needsBuildFile;
        if (needsBuildFile) {
            this.buildSystem = "ant";
            this.buildTarget = "build";
            this.buildDirectory = ".";
            this.buildFile = String.valueOf(this.getProjectName()) + ".xml";
            this.buildOpts = "";
            this.packageSystemLibs = packageRTLibs;
        } else if (buildSys.equals(NO_BUILD_STRING)) {
            this.buildSystem = NO_BUILD_STRING;
            this.buildTarget = "";
            this.buildDirectory = "";
            this.buildFile = "";
            this.buildOpts = "";
        } else {
            this.buildSystem = buildSys.equals(ECLIPSE_GENERATED_STRING) ? "make" : buildSys;
            this.buildDirectory = buildDir;
            this.buildFile = buildFile;
            this.buildTarget = target;
            this.buildOpts = buildOptions;
        }
    }

    public void setConfigInfo(String configDir, String configCmd, String configOptions) {
        this.configDir = configDir;
        this.configCmd = configCmd;
        this.configOpts = configOptions;
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public String getProjectPath() {
        return this.project.getLocation().toOSString();
    }

    public String getProjectWorkingLocation() {
        return this.project.getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
    }

    public boolean needsBuildFile() {
        return this.createBuildFile;
    }

    public void setNeedsBuildFile(boolean b) {
        this.createBuildFile = b;
    }

    public String getBuildTarget() {
        return this.buildTarget;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getBuildSystem() {
        return this.buildSystem;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String pkgVers) {
        this.packageVersion = pkgVers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void savePluginSettings() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.continuousassurance.swamp.eclipse");
        prefs.put(PROJECT_KEY, this.selectedProjectID);
        prefs.put(this.getToolKey(), Utils.convertListToDelimitedString(this.selectedToolIDs, DELIMITER));
        prefs.put(this.getPlatformKey(), Utils.convertListToDelimitedString(this.selectedPlatformIDs, DELIMITER));
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void loadPluginSettings() {
        if (this.selectedProjectID != null) {
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.continuousassurance.swamp.eclipse");
        this.selectedProjectID = prefs.get(PROJECT_KEY, null);
    }

    private String getToolKey() {
        return String.valueOf(this.packageType) + TOOLS_PREFERENCE_SUFFIX;
    }

    private String getPlatformKey() {
        return String.valueOf(this.packageType) + PLATFORMS_PREFERENCE_SUFFIX;
    }

    public void setBuildOpts(String opts) {
        this.buildOpts = opts;
    }

    public void setConfigOpts(String opts) {
        this.configOpts = opts;
    }

    public void setConfigCmd(String cmd) {
        this.configCmd = cmd;
    }

    public void setConfigDir(String dir) {
        this.configDir = dir;
    }

    public String getBuildOpts() {
        return this.buildOpts;
    }

    public String getConfigOpts() {
        return this.configOpts;
    }

    public String getConfigCmd() {
        return this.configCmd;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public String getPackageThingUUID() {
        if (this.packageThing == null) {
            return "";
        }
        return this.packageThing.getUUIDString();
    }

    public void setPackageThing(PackageThing p) {
        this.packageThing = p;
    }
}

