/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.continuousassurance.swamp.eclipse.FileFilterHelper;

public class TarUtils {
    public static int getFilePermission(Set<PosixFilePermission> filePermissions) {
        int mode = 0;
        for (PosixFilePermission perm : filePermissions) {
            switch (perm) {
                case OWNER_READ: {
                    mode |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    mode |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    mode |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    mode |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    mode |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    mode |= 8;
                    break;
                }
                case OTHERS_READ: {
                    mode |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    mode |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    mode |= 1;
                    break;
                }
            }
        }
        return mode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path createTarGzip(Set<String> fileSet, String zipFilePath, String zipFileName) throws IOException {
        String outputFile = String.valueOf(zipFilePath) + '/' + zipFileName;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            try {
                block29: {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    try {
                        block28: {
                            GzipCompressorOutputStream gzipOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);
                            try {
                                try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)gzipOutputStream);){
                                    tarArchiveOutputStream.setBigNumberMode(2);
                                    tarArchiveOutputStream.setLongFileMode(2);
                                    Iterator<String> iterator = fileSet.iterator();
                                    block11: while (true) {
                                        if (!iterator.hasNext()) {
                                            tarArchiveOutputStream.close();
                                            break;
                                        }
                                        String file_name = iterator.next();
                                        File file = new File(file_name);
                                        if (file.isDirectory()) {
                                            ArrayList files = new ArrayList(FileUtils.listFilesAndDirs((File)file, (IOFileFilter)FileFilterHelper.createDefaultFilter(), (IOFileFilter)FileFilterHelper.createDefaultFilter()));
                                            int i = 0;
                                            while (true) {
                                                if (i >= files.size()) continue block11;
                                                File currentFile = (File)files.get(i);
                                                Path relativeFilePath = file.toPath().getParent().relativize(currentFile.toPath().toAbsolutePath());
                                                TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, relativeFilePath.toString());
                                                tarEntry.setSize(currentFile.length());
                                                tarEntry.setMode(TarUtils.getFilePermission(Files.getPosixFilePermissions(currentFile.toPath(), new LinkOption[0])));
                                                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
                                                if (currentFile.isFile()) {
                                                    tarArchiveOutputStream.write(IOUtils.toByteArray((InputStream)new FileInputStream(currentFile)));
                                                }
                                                tarArchiveOutputStream.closeArchiveEntry();
                                                ++i;
                                            }
                                        }
                                        File currentFile = file;
                                        Path relativeFilePath = file.toPath().getParent().relativize(currentFile.toPath().toAbsolutePath());
                                        TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, relativeFilePath.toString());
                                        tarEntry.setSize(currentFile.length());
                                        tarEntry.setMode(TarUtils.getFilePermission(Files.getPosixFilePermissions(currentFile.toPath(), new LinkOption[0])));
                                        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
                                        tarArchiveOutputStream.write(IOUtils.toByteArray((InputStream)new FileInputStream(currentFile)));
                                        tarArchiveOutputStream.closeArchiveEntry();
                                    }
                                }
                                if (gzipOutputStream == null) break block28;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (gzipOutputStream == null) throw throwable;
                                gzipOutputStream.close();
                                throw throwable;
                            }
                            gzipOutputStream.close();
                        }
                        if (bufferedOutputStream == null) break block29;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (bufferedOutputStream == null) throw throwable;
                        bufferedOutputStream.close();
                        throw throwable;
                    }
                    bufferedOutputStream.close();
                }
                if (fileOutputStream == null) return FileUtils.getFile((String[])new String[]{outputFile}).toPath();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return FileUtils.getFile((String[])new String[]{outputFile}).toPath();
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

