/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.continuousassurance.swamp.api.PackageThing;
import org.continuousassurance.swamp.api.Project;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.SubmissionInfo;
import org.continuousassurance.swamp.eclipse.Utils;
import org.continuousassurance.swamp.eclipse.dialogs.AdvancedSettingsDialog;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigDialog
extends TitleAreaDialog {
    private Text buildTargetText;
    private Text prjFilePathText;
    private Text pkgVersionText;
    private Text pkgNameText;
    private Combo swampPrjCombo;
    private Combo eclipsePrjCombo;
    private Combo pkgCombo;
    private Combo pkgTypeCombo;
    private Combo buildSysCombo;
    private Button packageRTButton;
    private Button selectFileButton;
    private Text buildPathText;
    private Shell shell;
    private AdvancedSettingsDialog advancedSettingsDialog;
    private List<Project> swampProjects;
    private IProject[] eclipseProjects;
    private List<PackageThing> swampPackages;
    private String buildOpts;
    private String configOpts;
    private String configScriptPath;
    private String prjUUID;
    private SubmissionInfo submissionInfo;
    private SwampApiWrapper api;
    private static final int CREATE_NEW_PACKAGE_IDX = 0;
    private static final String CONFIG_TITLE = "Build Configuration";
    private static final String SWAMP_PROJECT_HELP = "Select the SWAMP project that contains the package you want to assess. New projects can only be created using the SWAMP web interface.";
    private static final String SWAMP_PACKAGE_HELP = "Select the SWAMP package you want to assess or select \"Create a new package\".";
    private static final String NEW_PACKAGE_HELP = "Enter the name of your new package.";
    private static final String PACKAGE_VERSION_HELP = "Enter the version of your package that you are submitting now.";
    private static final String PACKAGE_TYPE_HELP = "Select the type of the package that you are uploading.";
    private static final String ECLIPSE_PROJECT_HELP = "Select the Eclipse project in your workspace to upload to the SWAMP.";
    private static final String BUILD_SYSTEM_HELP = "Select the build system of your project or select \"Auto-generate build file\".";
    private static final String BUILD_TARGET_HELP = "Select the build target in the build file.";
    private static final String SELECT_FILE_HELP = "Select the build file for this project.";
    private static final String PACKAGE_SYSTEM_LIBRARIES_HELP = "Select this option to upload system libraries (e.g. JDK) to the SWAMP. By default, they will not be uploaded.";
    private static final String ADVANCED_SETTINGS = "Advanced Settings...";
    private static final String CREATE_NEW_PACKAGE = "Create new package";
    private static final String SWAMP_PROJECT_LABEL = "SWAMP Project: ";
    private static final String SWAMP_PACKAGE_LABEL = "SWAMP Package: ";
    private static final String NEW_PACKAGE_NAME_LABEL = "New Package Name: ";
    private static final String SWAMP_PACKAGE_VERSION_LABEL = "Package Version: ";
    private static final String ECLIPSE_PROJECT_LABEL = "Eclipse Project: ";
    private static final String FILEPATH_LABEL = "Filepath: ";
    private static final String PACKAGE_TYPE_LABEL = "Package Type: ";
    private static final String BUILD_SYSTEM_LABEL = "Build System: ";
    private static final String EMPTY_LABEL = "";
    private static final String PACKAGE_SYSTEM_LIBRARIES_LABEL = "Package System Libraries?";
    private static final String BUILD_FILE_LABEL = "Build File: ";
    private static final String MORE_OPTIONS_LABEL = "...";
    private static final String BUILD_TARGET_LABEL = "Build Target: ";
    private static final String BUILD_SYSTEM_ANT = "ant";
    private static final String BUILD_SYSTEM_MAVEN = "maven";
    private static final String BUILD_SYSTEM_MAKE = "make";
    private static final String MAKEFILE = "makefile";
    private static final String JAVA_LANG = "Java";
    private static final String JAVA_7_SRC_PKG_TYPE = "Java 7 Source Code";
    private static final String JAVA_8_SRC_PKG_TYPE = "Java 8 Source Code";
    private static final String ALL_OPTION = "All";
    private static final String CCPP_LANG = "C/C++";
    private static final String JAVA_COMPLIANCE_VERSION_17 = "1.7";
    private static final String JAVA_COMPLIANCE_VERSION_18 = "1.8";
    private static final String ECLIPSE_JAVA_COMPLIANCE_OPTION = "org.eclipse.jdt.core.compiler.compliance";
    private static final String SELECT_SWAMP_PROJECT = "Please select a SWAMP project.";
    private static final String SELECT_SWAMP_PACKAGE = "Please select a package.";
    private static final String ADD_PACKAGE_NAME = "Please add a name for your new package.";
    private static final String ADD_PACKAGE_VERSION = "Please add a descriptor for your package version.";
    private static final String SELECT_PACKAGE_TYPE = "Please select a package type.";
    private static final String SELECT_ECLIPSE_PROJECT = "Please select an Eclipse project.";
    private static final String SELECT_BUILD_SYSTEM = "Please select a build system.";
    private static final String SELECT_BUILD_FILE = "Please select a valid build file.";
    private static final String SELECT_BUILD_TARGET = "Please enter a valid build target.";
    private static final String CONFIG_OPTS_WO_CONFIG_SCRIPT = "Config options set but no configuration script specified.";
    private static final String PROBLEM_GETTING_BUILD_INFO = "Error: Problem getting build information";
    private static final String UNABLE_TO_FIND_MAKEFILE = "Error: Unable to find makefile for project";

    public ConfigDialog(Shell parentShell, SubmissionInfo si) {
        super(parentShell);
        this.submissionInfo = si;
        this.api = this.submissionInfo.getApi();
        this.shell = parentShell;
        this.buildOpts = EMPTY_LABEL;
        this.configOpts = EMPTY_LABEL;
        this.configScriptPath = EMPTY_LABEL;
    }

    private void resetWidgets() {
        this.buildPathText.setText(EMPTY_LABEL);
        this.buildPathText.setEditable(false);
        this.buildTargetText.setText(EMPTY_LABEL);
        this.buildTargetText.setEnabled(true);
        this.prjFilePathText.setText(EMPTY_LABEL);
        this.pkgVersionText.setText(EMPTY_LABEL);
        this.pkgVersionText.setEnabled(false);
        this.pkgNameText.setText(EMPTY_LABEL);
        this.pkgNameText.setEnabled(false);
        this.swampPrjCombo.deselectAll();
        this.eclipsePrjCombo.deselectAll();
        this.pkgCombo.setItems(new String[]{EMPTY_LABEL});
        this.pkgCombo.setItems(new String[]{EMPTY_LABEL});
        this.pkgTypeCombo.setItems(new String[]{EMPTY_LABEL});
        this.pkgTypeCombo.setEnabled(false);
        this.buildSysCombo.setItems(new String[]{EMPTY_LABEL});
        this.buildSysCombo.setEnabled(false);
        this.packageRTButton.setSelection(false);
        this.packageRTButton.setEnabled(false);
        this.setDefaults(false);
    }

    private void setDefaults(boolean eclipseProjectInitialized) {
        this.setSwampProjectDefault();
        if (!eclipseProjectInitialized) {
            this.setEclipseProjectDefault();
        }
        this.setPackageDefault();
        this.setBuildSysDefault();
        this.setPackageTypeDefault();
    }

    private void setEclipseProjectDefault() {
        if (this.eclipsePrjCombo.getItemCount() == 1) {
            this.eclipsePrjCombo.select(0);
            this.handleEclipseProjectSelection(0);
        }
    }

    private void setSwampProjectDefault() {
        if (this.swampPrjCombo.getItemCount() == 1) {
            this.swampPrjCombo.select(0);
            this.handleSwampProjectSelection(0);
        }
    }

    private void setPackageDefault() {
        if (this.prjUUID == null) {
            return;
        }
        if (this.pkgCombo.getItemCount() == 1) {
            this.pkgCombo.select(0);
            this.handlePackageSelection(0);
        }
    }

    private void setBuildSysDefault() {
        if (this.buildSysCombo.getItemCount() == 1) {
            this.buildSysCombo.select(0);
            this.handleBuildSelection(0);
        }
    }

    private void setPackageTypeDefault() {
        if (this.pkgTypeCombo.getItemCount() == 1) {
            this.pkgTypeCombo.select(0);
        }
    }

    private String[] getSelectionElements(Type type) {
        if (type == Type.ECLIPSE_PROJECT) {
            return this.getEclipseProjectList();
        }
        if (type == Type.SWAMP_PROJECT) {
            return this.getSwampProjectList();
        }
        return this.getSwampPackageList();
    }

    private String[] getEclipseProjectList() {
        if (this.eclipseProjects == null) {
            this.eclipseProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        int length = this.eclipseProjects.length;
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            IProject prj = this.eclipseProjects[i];
            String name = prj.getName();
            System.out.println(name);
            try {
                prj.open(null);
            }
            catch (CoreException coreException) {
                System.err.println("Unable to open project " + name);
            }
            array[i] = name;
            ++i;
        }
        return array;
    }

    private String[] getSwampProjectList() {
        this.swampProjects = this.api.getProjectsList();
        int size = this.swampProjects.size();
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            array[i] = this.swampProjects.get(i).getFullName();
            ++i;
        }
        return array;
    }

    private String[] getSwampPackageList() {
        if (this.prjUUID == null) {
            String[] array = new String[]{EMPTY_LABEL};
            return array;
        }
        this.swampPackages = this.api.getPackagesList(this.prjUUID);
        int numPackages = this.swampPackages.size() + 1;
        String[] pkgNames = new String[numPackages];
        pkgNames[0] = CREATE_NEW_PACKAGE;
        int i = 1;
        while (i < numPackages) {
            pkgNames[i] = this.swampPackages.get(i - 1).getName();
            ++i;
        }
        return pkgNames;
    }

    protected Control createDialogArea(Composite parent) {
        System.out.println("Redrawing Config Dialog");
        Composite area = (Composite)super.createDialogArea(parent);
        int horizontalSpan = 2;
        Composite container = new Composite(area, 0);
        this.setTitle(CONFIG_TITLE);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(4, false);
        container.setLayout((Layout)layout);
        DialogUtil.initializeLabelWidget(SWAMP_PROJECT_LABEL, 0, container, horizontalSpan);
        String[] swampPrjOptions = this.getSelectionElements(Type.SWAMP_PROJECT);
        this.swampPrjCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), swampPrjOptions, horizontalSpan);
        this.swampPrjCombo.addSelectionListener((SelectionListener)new ComboSelectionListener(this.swampPrjCombo, Type.SWAMP_PROJECT));
        this.swampPrjCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)SWAMP_PROJECT_HELP));
        DialogUtil.initializeLabelWidget(SWAMP_PACKAGE_LABEL, 0, container, horizontalSpan);
        String[] pkgOptions = this.getSelectionElements(Type.PACKAGE);
        this.pkgCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), pkgOptions, horizontalSpan);
        this.pkgCombo.addSelectionListener((SelectionListener)new ComboSelectionListener(this.pkgCombo, Type.PACKAGE));
        this.pkgCombo.setEnabled(false);
        this.pkgCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)SWAMP_PACKAGE_HELP));
        DialogUtil.initializeLabelWidget(NEW_PACKAGE_NAME_LABEL, 0, container, horizontalSpan);
        this.pkgNameText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.pkgNameText.setEnabled(false);
        this.pkgNameText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)NEW_PACKAGE_HELP));
        DialogUtil.initializeLabelWidget(SWAMP_PACKAGE_VERSION_LABEL, 0, container, horizontalSpan);
        this.pkgVersionText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.pkgVersionText.setText(this.submissionInfo.getPackageVersion());
        this.pkgVersionText.setEnabled(false);
        this.pkgVersionText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)PACKAGE_VERSION_HELP));
        DialogUtil.initializeLabelWidget(ECLIPSE_PROJECT_LABEL, 0, container, horizontalSpan);
        String[] eclipsePrjOptions = this.getSelectionElements(Type.ECLIPSE_PROJECT);
        this.eclipsePrjCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), eclipsePrjOptions, horizontalSpan);
        this.eclipsePrjCombo.addSelectionListener((SelectionListener)new ComboSelectionListener(this.eclipsePrjCombo, Type.ECLIPSE_PROJECT));
        this.eclipsePrjCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)ECLIPSE_PROJECT_HELP));
        DialogUtil.initializeLabelWidget(FILEPATH_LABEL, 0, container, horizontalSpan);
        this.prjFilePathText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.prjFilePathText.setEditable(false);
        DialogUtil.initializeLabelWidget(PACKAGE_TYPE_LABEL, 0, container, horizontalSpan);
        this.pkgTypeCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), new String[0], horizontalSpan);
        this.pkgTypeCombo.setEnabled(false);
        this.pkgTypeCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)PACKAGE_TYPE_HELP));
        DialogUtil.initializeLabelWidget(BUILD_SYSTEM_LABEL, 0, container, horizontalSpan);
        String[] buildSysOptions = this.getSelectionElements(Type.BUILD);
        this.buildSysCombo = DialogUtil.initializeComboWidget(container, new GridData(4, 0, true, false), buildSysOptions, horizontalSpan);
        this.buildSysCombo.addSelectionListener((SelectionListener)new ComboSelectionListener(this.buildSysCombo, Type.BUILD));
        this.buildSysCombo.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)BUILD_SYSTEM_HELP));
        DialogUtil.initializeLabelWidget(EMPTY_LABEL, 0, container, horizontalSpan);
        this.packageRTButton = DialogUtil.initializeButtonWidget(container, PACKAGE_SYSTEM_LIBRARIES_LABEL, new GridData(4, 0, true, false), 32, horizontalSpan);
        this.packageRTButton.setEnabled(false);
        this.packageRTButton.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)PACKAGE_SYSTEM_LIBRARIES_HELP));
        DialogUtil.initializeLabelWidget(BUILD_FILE_LABEL, 0, container, horizontalSpan);
        this.buildPathText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), 1);
        this.buildPathText.setEditable(false);
        this.selectFileButton = DialogUtil.initializeButtonWidget(container, MORE_OPTIONS_LABEL, new GridData(4, 0, false, false), 8, 1);
        this.selectFileButton.addSelectionListener((SelectionListener)new FileSelectionListener());
        this.selectFileButton.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)SELECT_FILE_HELP));
        DialogUtil.initializeLabelWidget(BUILD_TARGET_LABEL, 0, container, horizontalSpan);
        this.buildTargetText = DialogUtil.initializeTextWidget(2052, container, new GridData(4, 0, true, false), horizontalSpan);
        this.buildTargetText.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)BUILD_TARGET_HELP));
        if (this.submissionInfo.isConfigInitialized()) {
            this.setupSwampProject();
            this.setupSwampPackage();
            this.setupEclipseProject();
            this.setupPackageType();
            this.setupBuild();
        } else if (this.submissionInfo.isProjectInitialized()) {
            this.setupEclipseProject();
            this.setDefaults(true);
        } else {
            this.setDefaults(false);
        }
        return area;
    }

    private void setupPackageType() {
        String pkgType = this.submissionInfo.getPackageType();
        int i = 0;
        while (i < this.pkgTypeCombo.getItemCount()) {
            if (this.pkgTypeCombo.getItem(i).equals(pkgType)) {
                this.pkgTypeCombo.select(i);
                return;
            }
            ++i;
        }
    }

    private void setPredictedJavaBuildSys(IProject project) {
        File file;
        String[] files;
        String GRADLE_NATURE = "org.eclipse.buildship.core.gradleprojectnature";
        String MAVEN_NATURE = "org.eclipse.m2e.core.maven2Nature";
        String ANT_BUILD = "build.xml";
        String MAVEN_BUILD = "pom.xml";
        String MAKE_UPPERCASE = "Makefile";
        String MAKE_LOWERCASE = MAKEFILE;
        String path = project.getLocation().toOSString();
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException coreException) {
            return;
        }
        if (description != null) {
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                String nature = natures[i];
                System.out.println("Nature " + i + ": " + nature);
                if (nature.equals(GRADLE_NATURE)) {
                    this.setBuildSystem(BUILD_SYSTEM_ANT);
                    this.setBuildPath(path, ANT_BUILD);
                    return;
                }
                if (nature.equals(MAVEN_NATURE)) {
                    this.setBuildSystem(BUILD_SYSTEM_MAVEN);
                    this.setBuildPath(path, MAVEN_BUILD);
                    return;
                }
                ++i;
            }
        }
        if ((files = (file = new File(path)).list()) != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                String filename = files[i];
                System.out.println("Filename: " + filename);
                String filepath = String.valueOf(path) + '/' + filename;
                File f = new File(filepath);
                if (!f.isDirectory()) {
                    if (filename.equals(ANT_BUILD)) {
                        this.setBuildSystem(BUILD_SYSTEM_ANT);
                        this.buildPathText.setText(filepath);
                        return;
                    }
                    if (filename.equals(MAVEN_BUILD)) {
                        this.setBuildSystem(BUILD_SYSTEM_MAVEN);
                        this.buildPathText.setText(filepath);
                        return;
                    }
                    if (filename.equals(MAKE_UPPERCASE) || filename.equals(MAKE_LOWERCASE)) {
                        this.setBuildSystem(BUILD_SYSTEM_MAKE);
                        this.buildPathText.setText(filepath);
                        return;
                    }
                }
                ++i;
            }
        }
        this.packageRTButton.setEnabled(true);
        this.setBuildSystem("Auto-generate build file");
    }

    private void setBuildPath(String dirPath, String filename) {
        File file = new File(dirPath);
        String[] fileList = file.list();
        if (fileList != null && fileList.length > 0) {
            String[] stringArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (f.equals(filename)) {
                    this.buildPathText.setText(String.valueOf(dirPath) + '/' + filename);
                    return;
                }
                ++n2;
            }
            this.buildPathText.setText(EMPTY_LABEL);
        }
    }

    private void setBuildSystem(String buildSys) {
        int i = 0;
        while (i < this.buildSysCombo.getItemCount()) {
            if (this.buildSysCombo.getItem(i).equals(buildSys)) {
                this.buildSysCombo.select(i);
                this.handleBuildSelection(i);
            }
            ++i;
        }
    }

    private void setupEclipseProject() {
        IProject project = this.submissionInfo.getProject();
        int i = 0;
        while (i < this.eclipseProjects.length) {
            if (project.equals((Object)this.eclipseProjects[i])) {
                this.eclipsePrjCombo.select(i);
                this.handleEclipseProjectSelection(i);
                return;
            }
            ++i;
        }
        this.handleEclipseProjectSelection(-1);
    }

    private void handleEclipseProjectSelection(int index) {
        if (index < 0) {
            this.prjFilePathText.setText(EMPTY_LABEL);
            this.pkgTypeCombo.setItems(new String[]{EMPTY_LABEL});
            this.buildSysCombo.setItems(new String[]{EMPTY_LABEL});
            this.packageRTButton.setSelection(false);
            this.packageRTButton.setEnabled(false);
        } else {
            this.pkgTypeCombo.setEnabled(true);
            this.buildSysCombo.setEnabled(true);
            IProject project = this.eclipseProjects[index];
            String lang = this.getProjectLanguage(project);
            if (lang.equals(JAVA_LANG)) {
                IJavaProject jp = JavaCore.create((IProject)project);
                String complianceVersion = jp.getOption(ECLIPSE_JAVA_COMPLIANCE_OPTION, true);
                if (complianceVersion != null) {
                    if (complianceVersion.equals(JAVA_COMPLIANCE_VERSION_17)) {
                        System.out.println("Java 7 package");
                        this.setPkgTypeOptions(JAVA_LANG);
                        this.setPackageType(JAVA_7_SRC_PKG_TYPE);
                        this.setBuildSysOptions(JAVA_LANG);
                    } else if (complianceVersion.equals(JAVA_COMPLIANCE_VERSION_18)) {
                        System.out.println("Java 8 package");
                        this.setPkgTypeOptions(JAVA_LANG);
                        this.setPackageType(JAVA_8_SRC_PKG_TYPE);
                        this.setBuildSysOptions(JAVA_LANG);
                    } else {
                        System.out.println("Other version Java package");
                        this.setPkgTypeOptions(JAVA_LANG);
                        this.setBuildSysOptions(JAVA_LANG);
                    }
                }
                this.setPredictedJavaBuildSys(project);
            } else if (lang.equals(CCPP_LANG)) {
                this.packageRTButton.setEnabled(false);
                this.setPkgTypeOptions(CCPP_LANG);
                this.setPackageType(CCPP_LANG);
                this.setBuildSysOptions(CCPP_LANG);
                this.setBuildSystem("Eclipse-generated makefile");
            } else {
                this.packageRTButton.setEnabled(true);
                this.setPkgTypeOptions(ALL_OPTION);
                this.setBuildSysOptions(ALL_OPTION);
            }
            this.prjFilePathText.setText(project.getLocation().toOSString());
        }
    }

    private void setBuildSysOptions(String lang) {
        Object[] buildOptions;
        if (lang.equals(ALL_OPTION)) {
            String[] javaBuildOptions = SubmissionInfo.getBuildSystemList(JAVA_LANG);
            String[] cBuildOptions = SubmissionInfo.getBuildSystemList(CCPP_LANG);
            buildOptions = ConfigDialog.union(javaBuildOptions, cBuildOptions);
            Arrays.sort(buildOptions);
        } else {
            buildOptions = SubmissionInfo.getBuildSystemList(lang);
        }
        this.buildSysCombo.setItems((String[])buildOptions);
    }

    private void setPkgTypeOptions(String lang) {
        Object[] pkgTypes;
        if (lang.equals(ALL_OPTION)) {
            String[] javaPkgTypes = SubmissionInfo.getPackageTypeList(JAVA_LANG);
            String[] cPkgTypes = SubmissionInfo.getPackageTypeList(CCPP_LANG);
            pkgTypes = ConfigDialog.union(javaPkgTypes, cPkgTypes);
            Arrays.sort(pkgTypes);
        } else {
            pkgTypes = SubmissionInfo.getPackageTypeList(lang);
        }
        this.pkgTypeCombo.setItems((String[])pkgTypes);
    }

    private static String[] union(String[] a, String[] b) {
        String s;
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            set.add(s);
            ++n2;
        }
        stringArray = b;
        n = b.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            set.add(s);
            ++n2;
        }
        return set.toArray(new String[0]);
    }

    private String getProjectLanguage(IProject project) {
        if (CoreModel.hasCCNature((IProject)project) || CoreModel.hasCNature((IProject)project)) {
            return CCPP_LANG;
        }
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JAVA_LANG;
            }
        }
        catch (CoreException coreException) {}
        return EMPTY_LABEL;
    }

    private void setPackageType(String versionString) {
        int i = 0;
        while (i < this.pkgTypeCombo.getItemCount()) {
            if (this.pkgTypeCombo.getItem(i).equals(versionString)) {
                this.pkgTypeCombo.select(i);
                return;
            }
            ++i;
        }
    }

    private void setupSwampProject() {
        this.prjUUID = this.submissionInfo.getSelectedProjectID();
        int i = 0;
        while (i < this.swampProjects.size()) {
            if (this.swampProjects.get(i).getUUIDString().equals(this.prjUUID)) {
                this.swampPrjCombo.select(i);
                this.handleSwampProjectSelection(i);
                return;
            }
            ++i;
        }
        this.prjUUID = null;
        this.handleSwampProjectSelection(-1);
    }

    private void handleSwampProjectSelection(int index) {
        if (index < 0) {
            this.prjUUID = null;
            this.swampPrjCombo.deselectAll();
            this.pkgCombo.deselectAll();
            this.pkgCombo.setEnabled(false);
            this.pkgVersionText.setEnabled(false);
            this.pkgCombo.setItems(new String[]{EMPTY_LABEL});
        } else {
            this.prjUUID = this.swampProjects.get(index).getUUIDString();
            this.pkgCombo.setEnabled(true);
            this.pkgVersionText.setEnabled(true);
            this.pkgCombo.setItems(this.getSelectionElements(Type.PACKAGE));
            this.setPackageDefault();
        }
    }

    private void setupSwampPackage() {
        if (this.submissionInfo.isNewPackage()) {
            this.pkgCombo.select(0);
            this.handlePackageSelection(0);
            this.pkgNameText.setText(this.submissionInfo.getPackageName());
        } else {
            String pkgThingUUID = this.submissionInfo.getSelectedPackageID();
            int i = 0;
            while (i < this.swampPackages.size()) {
                if (this.swampPackages.get(i).getUUIDString().equals(pkgThingUUID)) {
                    this.pkgCombo.select(i + 1);
                    this.handlePackageSelection(i + 1);
                    return;
                }
                ++i;
            }
            this.handlePackageSelection(-1);
        }
    }

    private void handlePackageSelection(int index) {
        this.pkgNameText.setText(EMPTY_LABEL);
        if (index == 0) {
            this.pkgNameText.setEnabled(true);
        } else {
            this.pkgNameText.setEnabled(false);
        }
    }

    private void setupBuild() {
        String buildSys = null;
        if (this.submissionInfo.needsBuildFile()) {
            buildSys = "Auto-generate build file";
            this.packageRTButton.setSelection(this.submissionInfo.packageSystemLibraries());
        } else {
            buildSys = this.submissionInfo.getBuildSystem();
            String prjLocation = this.eclipseProjects[this.eclipsePrjCombo.getSelectionIndex()].getLocation().toOSString();
            String buildDir = this.submissionInfo.getBuildDirectory();
            int idx = buildDir.indexOf(Character.toString('/'));
            buildDir = idx > -1 ? buildDir.substring(idx + 1) : EMPTY_LABEL;
            String buildFile = this.submissionInfo.getBuildFile();
            String path = String.valueOf(prjLocation) + '/';
            path = buildDir.equals(EMPTY_LABEL) || buildDir.equals(".") ? String.valueOf(path) + buildFile : String.valueOf(path) + buildDir + '/' + buildFile;
            this.buildPathText.setText(path);
            this.buildTargetText.setText(this.submissionInfo.getBuildTarget());
            this.buildOpts = this.submissionInfo.getBuildOpts();
            this.configScriptPath = this.submissionInfo.getConfigCmd();
            this.configOpts = this.submissionInfo.getConfigOpts();
        }
        int i = 0;
        while (i < this.buildSysCombo.getItemCount()) {
            if (buildSys.equals(this.buildSysCombo.getItem(i))) {
                this.buildSysCombo.select(i);
                this.handleBuildSelection(i);
                return;
            }
            ++i;
        }
        this.handleBuildSelection(-1);
    }

    private void handleBuildSelection(int index) {
        String buildSys = this.buildSysCombo.getItem(index);
        if (buildSys.equals("Auto-generate build file") || buildSys.equals("no-build") || buildSys.equals("Eclipse-generated makefile")) {
            this.selectFileButton.setEnabled(false);
            this.buildTargetText.setText(EMPTY_LABEL);
            this.buildTargetText.setEnabled(false);
            this.buildPathText.setText(EMPTY_LABEL);
            this.buildPathText.setEnabled(false);
            if (buildSys.equals("Auto-generate build file")) {
                this.packageRTButton.setEnabled(true);
            }
        } else {
            this.selectFileButton.setEnabled(true);
            this.buildTargetText.setEnabled(true);
            this.buildPathText.setEnabled(true);
            this.packageRTButton.setSelection(false);
            this.packageRTButton.setEnabled(false);
        }
    }

    String getBuildOpts() {
        return this.buildOpts;
    }

    String getConfigScriptPath() {
        return this.configScriptPath;
    }

    String getConfigOpts() {
        return this.configOpts;
    }

    void setBuildOpts(String opts) {
        this.buildOpts = opts;
    }

    void setConfigScriptPath(String path) {
        this.configScriptPath = path;
    }

    void setConfigOpts(String opts) {
        this.configOpts = opts;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Button advancedButton = this.createButton(parent, 3, ADVANCED_SETTINGS, false);
        advancedButton.addSelectionListener((SelectionListener)new AdvancedButtonSelectionListener(this));
        Button clearButton = this.createButton(parent, 3, "Clear", false);
        clearButton.addSelectionListener((SelectionListener)new ClearButtonSelectionListener());
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    private boolean isValid() {
        int pkgIndex;
        int swampPrjIndex = this.swampPrjCombo.getSelectionIndex();
        if (swampPrjIndex < 0) {
            this.setMessage(SELECT_SWAMP_PROJECT);
        }
        if ((pkgIndex = this.pkgCombo.getSelectionIndex()) < 0) {
            this.setMessage(SELECT_SWAMP_PACKAGE);
            return false;
        }
        if (pkgIndex == 0 && this.pkgNameText.getText().equals(EMPTY_LABEL)) {
            this.setMessage(ADD_PACKAGE_NAME);
            return false;
        }
        if (this.pkgVersionText.getText().equals(EMPTY_LABEL)) {
            this.setMessage(ADD_PACKAGE_VERSION);
            return false;
        }
        int pkgTypeIndex = this.pkgTypeCombo.getSelectionIndex();
        if (pkgTypeIndex < 0) {
            this.setMessage(SELECT_PACKAGE_TYPE);
            return false;
        }
        int eclipsePrjIndex = this.eclipsePrjCombo.getSelectionIndex();
        if (eclipsePrjIndex < 0) {
            this.setMessage(SELECT_ECLIPSE_PROJECT);
            return false;
        }
        int buildIndex = this.buildSysCombo.getSelectionIndex();
        if (buildIndex < 0) {
            this.setMessage(SELECT_BUILD_SYSTEM);
            return false;
        }
        String buildSysString = this.buildSysCombo.getItem(buildIndex);
        if (buildSysString.equals("no-build") || buildSysString.equals("Auto-generate build file") || buildSysString.equals("Eclipse-generated makefile")) {
            return true;
        }
        if (this.buildPathText.getText().equals(EMPTY_LABEL)) {
            this.setMessage(SELECT_BUILD_FILE);
        }
        if (this.buildTargetText.getText().equals(EMPTY_LABEL)) {
            this.setMessage(SELECT_BUILD_TARGET);
            return false;
        }
        if (!this.configOpts.equals(EMPTY_LABEL) && this.configScriptPath.equals(EMPTY_LABEL)) {
            this.setMessage(CONFIG_OPTS_WO_CONFIG_SCRIPT);
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (this.isValid()) {
            this.submissionInfo.setSelectedProjectID(this.prjUUID);
            int index = this.pkgCombo.getSelectionIndex();
            if (index == 0) {
                this.submissionInfo.setPackageName(this.pkgNameText.getText());
                this.submissionInfo.setNewPackage(true);
            } else {
                String pkgThingUUID = this.swampPackages.get(index - 1).getUUIDString();
                this.submissionInfo.setSelectedPackageID(pkgThingUUID);
                this.submissionInfo.setNewPackage(false);
            }
            this.submissionInfo.setPackageVersion(this.pkgVersionText.getText());
            index = this.pkgTypeCombo.getSelectionIndex();
            this.submissionInfo.setPackageType(this.pkgTypeCombo.getItem(index), false);
            index = this.eclipsePrjCombo.getSelectionIndex();
            IProject project = this.eclipseProjects[index];
            this.submissionInfo.setProject(project);
            index = this.buildSysCombo.getSelectionIndex();
            String buildSysStr = this.buildSysCombo.getItem(index);
            String relBuildDir = EMPTY_LABEL;
            String buildFileName = EMPTY_LABEL;
            boolean createBuildFile = false;
            if (buildSysStr.equals("Eclipse-generated makefile")) {
                ManagedBuildManager.getBuildInfo((IResource)project);
                IPath path = MakeBuilderUtil.getBuildDirectory((IProject)project, (String)MakeBuilder.BUILDER_ID);
                IMakeBuilderInfo makeBuildInfo = null;
                try {
                    makeBuildInfo = MakeCorePlugin.createBuildInfo((IProject)project, (String)MakeBuilder.BUILDER_ID);
                }
                catch (CoreException e) {
                    System.out.println(String.valueOf(Utils.getBracketedTimestamp()) + PROBLEM_GETTING_BUILD_INFO);
                    e.printStackTrace();
                    return;
                }
                IFile file = project.getFile(MAKEFILE);
                if (file == null) {
                    System.out.println(String.valueOf(Utils.getBracketedTimestamp()) + UNABLE_TO_FIND_MAKEFILE);
                    return;
                }
                String cleanTarget = makeBuildInfo.getCleanBuildTarget();
                String buildTarget = makeBuildInfo.getAutoBuildTarget();
                if (buildTarget == null && (buildTarget = makeBuildInfo.getFullBuildTarget()) == null) {
                    buildTarget = makeBuildInfo.getIncrementalBuildTarget();
                }
                relBuildDir = this.getRelDir(project.getLocation().toOSString(), path.toOSString(), false);
                System.out.println("Build system: " + buildSysStr);
                System.out.println("Create build file: false");
                System.out.println("Relative build directory: " + relBuildDir);
                System.out.println("Build file name: makefile");
                System.out.println("Build targets: " + cleanTarget + " " + buildTarget);
                System.out.println("Package Run-time libs: false");
                this.submissionInfo.setBuildInfo(buildSysStr, false, relBuildDir, MAKEFILE, String.valueOf(cleanTarget) + " " + buildTarget, EMPTY_LABEL, false);
                this.submissionInfo.setConfigInfo(EMPTY_LABEL, EMPTY_LABEL, EMPTY_LABEL);
            } else {
                if (buildSysStr.equals("Auto-generate build file")) {
                    createBuildFile = true;
                    this.submissionInfo.setConfigInfo(EMPTY_LABEL, EMPTY_LABEL, EMPTY_LABEL);
                } else {
                    createBuildFile = false;
                    String prjDir = project.getLocation().toOSString();
                    String buildPath = this.buildPathText.getText();
                    relBuildDir = this.getRelDir(prjDir, buildPath, true);
                    buildFileName = buildPath.substring(buildPath.lastIndexOf(47) + 1);
                    System.out.println("Relative Directory: " + relBuildDir);
                    System.out.println("Build file: " + buildFileName);
                    String cDir = EMPTY_LABEL;
                    String cCmd = EMPTY_LABEL;
                    if (!this.configScriptPath.equals(EMPTY_LABEL)) {
                        cDir = this.getRelDir(prjDir, this.configScriptPath, true);
                        cCmd = "./" + this.configScriptPath.substring(this.configScriptPath.lastIndexOf(47) + 1);
                    }
                    this.submissionInfo.setConfigInfo(cDir, cCmd, this.configOpts);
                }
                this.submissionInfo.setBuildInfo(buildSysStr, createBuildFile, relBuildDir, buildFileName, this.buildTargetText.getText(), this.buildOpts, this.packageRTButton.getSelection());
            }
            this.submissionInfo.setConfigInitialized(true);
            super.okPressed();
        }
    }

    private String getRelDir(String projectDir, String path, boolean isFilePath) {
        int fileIndex;
        int prjIndex = projectDir.lastIndexOf(47);
        String relDir = path.substring(prjIndex + 1, fileIndex = isFilePath ? path.lastIndexOf(47) : path.length());
        if (relDir.equals(EMPTY_LABEL)) {
            return ".";
        }
        return relDir;
    }

    private class AdvancedButtonSelectionListener
    implements SelectionListener {
        private ConfigDialog cd;

        public AdvancedButtonSelectionListener(ConfigDialog cd) {
            this.cd = cd;
        }

        public void widgetSelected(SelectionEvent e) {
            ConfigDialog.this.advancedSettingsDialog = new AdvancedSettingsDialog(ConfigDialog.this.shell, this.cd);
            ConfigDialog.this.advancedSettingsDialog.create();
            ConfigDialog.this.advancedSettingsDialog.open();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ClearButtonSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            ConfigDialog.this.resetWidgets();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ComboSelectionListener
    implements SelectionListener {
        Combo combo;
        Type type;

        public ComboSelectionListener(Combo c, Type t) {
            this.combo = c;
            this.type = t;
        }

        public void widgetSelected(SelectionEvent e) {
            int selection = this.combo.getSelectionIndex();
            System.out.println("Index " + selection + " selected");
            if (this.type == Type.BUILD) {
                ConfigDialog.this.handleBuildSelection(selection);
            } else if (this.type == Type.SWAMP_PROJECT) {
                ConfigDialog.this.handleSwampProjectSelection(selection);
            } else if (this.type == Type.ECLIPSE_PROJECT) {
                ConfigDialog.this.handleEclipseProjectSelection(selection);
            } else if (this.type == Type.PACKAGE) {
                ConfigDialog.this.handlePackageSelection(selection);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class FileSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(ConfigDialog.this.shell);
            String path = ConfigDialog.this.prjFilePathText.getText();
            if (path.equals(ConfigDialog.EMPTY_LABEL)) {
                path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            }
            dialog.setFilterPath(path);
            String rc = dialog.open();
            if (rc != null) {
                ConfigDialog.this.buildPathText.setText(rc);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static enum Type {
        PACKAGE_TYPE,
        ECLIPSE_PROJECT,
        BUILD,
        PACKAGE,
        SWAMP_PROJECT;

    }
}

