/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.handlers;

import org.continuousassurance.swamp.eclipse.SwampSubmitter;
import org.continuousassurance.swamp.eclipse.Utils;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;

public class RightClickHandler
extends AbstractHandler {
    private static final String PROJECT_NOT_OPEN_CONSOLE_ERROR = "Error: Project is not open";
    private static final String ERROR_MESSAGE_DIALOG_TITLE = "Error";
    private static final String PROJECT_NOT_OPEN_MESSAGE_DIALOG_ERROR = "The selected project is not open. Please open it and then re-attempt your submission.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelectionService service = window.getSelectionService();
        IStructuredSelection structured = (IStructuredSelection)service.getSelection();
        System.out.println("Selection: " + structured);
        System.out.println("Type of selection: " + structured.getFirstElement().getClass());
        Object proj = structured.getFirstElement();
        IJavaProject javaProject = null;
        ICProject cProject = null;
        if (proj instanceof IJavaProject) {
            javaProject = (IJavaProject)proj;
            if (!javaProject.isOpen()) {
                this.writeClosedProjectMessage(window);
                this.popupErrorDialog(window.getShell());
                return null;
            }
            this.submitAssessment(javaProject.getProject(), window);
        } else if (proj instanceof ICProject) {
            cProject = (ICProject)proj;
            if (!cProject.isOpen()) {
                this.writeClosedProjectMessage(window);
                this.popupErrorDialog(window.getShell());
                return null;
            }
            this.submitAssessment(cProject.getProject(), window);
        } else if (proj instanceof IProject) {
            this.submitAssessment((IProject)proj, window);
        }
        return null;
    }

    private void writeClosedProjectMessage(IWorkbenchWindow window) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMgr = plugin.getConsoleManager();
        MessageConsole console = new MessageConsole("SWAMP Plugin", null);
        conMgr.addConsoles(new IConsole[]{console});
        IWorkbenchPage page = window.getActivePage();
        try {
            IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
            view.display((IConsole)console);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        MessageConsoleStream stream = console.newMessageStream();
        stream.println(String.valueOf(Utils.getBracketedTimestamp()) + PROJECT_NOT_OPEN_CONSOLE_ERROR);
    }

    private void popupErrorDialog(Shell shell) {
        if (shell == null) {
            return;
        }
        MessageDialog.openError((Shell)shell, (String)ERROR_MESSAGE_DIALOG_TITLE, (String)PROJECT_NOT_OPEN_MESSAGE_DIALOG_ERROR);
    }

    private void submitAssessment(IProject prj, IWorkbenchWindow window) {
        SwampSubmitter ss = new SwampSubmitter(window);
        ss.launchBackgroundAssessment(prj);
    }
}

