/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.ui;

import java.util.List;
import org.continuousassurance.scarf.datastructures.BugInstance;
import org.continuousassurance.swamp.eclipse.BugDetail;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class DetailView
extends ViewPart {
    private static final String MESSAGE_LABEL = "Message: ";
    private static final String RESOLUTION_SUGGESTION_LABEL = "Resolution: ";
    private static final String LINE_NUMBER_LABEL = "Line number: ";
    private static final String FILENAME_LABEL = "File name: ";
    private static final String GROUP_LABEL = "Weakness group: ";
    private static final String CODE_LABEL = "Weakness code: ";
    private static final String TOOL_LABEL = "Tool: ";
    private static final String PLATFORM_LABEL = "Platform: ";
    private static final String FLOW_LABEL = "Flow: ";
    private Composite composite;
    private Browser browser;
    public static final String ID = "org.continuousassurance.swamp.eclipse.ui.views.detailview";
    private static final String VIEW_NAME = "Weakness Details";
    private static final String VIEW_DEFAULT_MESSAGE = "Select a weakness from the list of weaknesses";

    public void createPartControl(Composite parent) {
        this.composite = parent;
        this.browser = new Browser(this.composite, 0);
        this.setDefaultHtml();
    }

    public void setFocus() {
        this.composite.setFocus();
    }

    private void setDefaultHtml() {
        String html = this.getHeaderAndTitle();
        html = String.valueOf(html) + this.getDefaultBody();
        System.out.println(html);
        this.browser.setText(html, true);
    }

    private void setHtml(BugDetail bugInfo) {
        String html = this.getHeaderAndTitle();
        html = String.valueOf(html) + this.getBody(bugInfo);
        System.out.println(html);
        this.browser.setText(html, true);
    }

    private String getHeaderAndTitle() {
        return "<html><header><title>Weakness Details</title></header>";
    }

    private String getDefaultBody() {
        return "<body>Select a weakness from the list of weaknesses</body></html>";
    }

    private String getBody(BugDetail bugInfo) {
        StringBuffer sb = new StringBuffer("<body>");
        BugInstance bug = bugInfo.getBugInstance();
        sb.append(this.constructParagraph(DetailView.fmtBold(MESSAGE_LABEL), bug.getBugMessage()));
        String resolution = bug.getResolutionSuggestion();
        if (!"".equals(resolution)) {
            sb.append(this.constructParagraph(DetailView.fmtBold(RESOLUTION_SUGGESTION_LABEL), resolution));
        }
        sb.append(this.constructParagraph(DetailView.fmtBold(LINE_NUMBER_LABEL), bugInfo.getPrimaryLineNumber()));
        sb.append(this.constructParagraph(DetailView.fmtBold(FILENAME_LABEL), bugInfo.getPrimaryFilename()));
        if (bug.getBugGroup() != null) {
            sb.append(this.constructParagraph(DetailView.fmtBold(GROUP_LABEL), bug.getBugGroup()));
        } else {
            sb.append(this.constructParagraph(DetailView.fmtBold(GROUP_LABEL), ""));
        }
        sb.append(this.constructParagraph(DetailView.fmtBold(CODE_LABEL), bug.getBugCode()));
        sb.append(this.constructParagraph(DetailView.fmtBold(TOOL_LABEL), bugInfo.getTool()));
        sb.append(this.constructParagraph(DetailView.fmtBold(PLATFORM_LABEL), bugInfo.getPlatform()));
        sb.append(this.constructFlowParagraphs(DetailView.fmtBold(FLOW_LABEL), bugInfo.getFlow()));
        sb.append("</body></html>");
        return sb.toString();
    }

    private StringBuffer constructParagraph(String label, String value) {
        StringBuffer sb = new StringBuffer("<p>");
        sb.append(label);
        sb.append(value);
        sb.append("</p>");
        return sb;
    }

    private StringBuffer constructFlowParagraphs(String label, List<String> flow) {
        StringBuffer sb = new StringBuffer("");
        if (flow.isEmpty()) {
            return sb;
        }
        sb.append(label);
        for (String location : flow) {
            sb.append("<p>");
            sb.append(location);
            sb.append("</p>");
        }
        return sb;
    }

    public void reset() {
        this.setDefaultHtml();
    }

    public void update(BugDetail details) {
        if (details == null) {
            this.setDefaultHtml();
        } else {
            this.setHtml(details);
        }
    }

    private static String fmtBold(String text) {
        return "<b>" + text + "</b>";
    }
}

