/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.ui;

import java.io.File;
import java.util.List;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.ResultsRetriever;
import org.continuousassurance.swamp.eclipse.StatusChecker;
import org.continuousassurance.swamp.eclipse.SwampSubmitter;
import org.continuousassurance.swamp.eclipse.Utils;
import org.continuousassurance.swamp.eclipse.exceptions.ResultsRetrievalException;
import org.continuousassurance.swamp.eclipse.ui.SortListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StatusView
extends ViewPart {
    public static final String[] COLUMN_NAMES = new String[]{"SWAMP Package", "Version", "Tool", "Submission Time", "Status", "Count", "Eclipse Project", "Platform"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 240, 240, 200, 260, 50, 240, 240};
    private static final String[] COLUMN_TYPES = new String[]{Utils.STR_TYPE, Utils.STR_TYPE, Utils.STR_TYPE, Utils.STR_TYPE, Utils.STR_TYPE, Utils.INT_TYPE, Utils.STR_TYPE, Utils.STR_TYPE};
    private static final String REFRESH_ACTION_LABEL = "Refresh";
    private static final String ASSESS_UUID = "assess_uuid";
    private static final String RESULTS_FILEPATH = "results_filepath";
    public static final String ID = "org.continuousassurance.swamp.eclipse.ui.views.statusview";
    private Action refreshItemAction;
    private Table table;
    private static final String REMOVE_ASSESSMENT = "Remove Assessment";

    public void createPartControl(Composite parent) {
        this.table = Utils.constructTable(parent);
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            Utils.addTableColumn(this.table, COLUMN_NAMES[i], COLUMN_WIDTHS[i], i, COLUMN_TYPES[i], ASSESS_UUID, RESULTS_FILEPATH);
            ++i;
        }
        Menu menu = new Menu((Control)this.table);
        this.table.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(REMOVE_ASSESSMENT);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int[] nArray = StatusView.this.table.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filepath;
                    int i = nArray[n2];
                    TableItem row = StatusView.this.table.getItem(i);
                    String assessUUID = (String)row.getData(StatusView.ASSESS_UUID);
                    if (assessUUID != null) {
                        ResultsRetriever.addAssessmentToDelete(assessUUID);
                    }
                    if ((filepath = (String)row.getData(StatusView.RESULTS_FILEPATH)) != null) {
                        System.out.println("Non-null filepath at: " + filepath);
                        File f = new File(filepath);
                        if (f.exists()) {
                            System.out.println("File exists at: " + filepath);
                            f.delete();
                        }
                    }
                    StatusView.this.table.remove(i);
                    ++n2;
                }
            }
        });
        this.createActions();
        this.createToolbar();
    }

    private void createActions() {
        this.refreshItemAction = new Action(REFRESH_ACTION_LABEL){

            public void run() {
                SwampSubmitter ss;
                IWorkbenchWindow window;
                IWorkbench wb;
                StatusChecker sc = Activator.getStatusChecker();
                if (sc != null && sc.isRunning()) {
                    System.out.println("Status checker already running");
                    return;
                }
                if (!Activator.getLoggedIn() && (wb = PlatformUI.getWorkbench()) != null && (window = wb.getActiveWorkbenchWindow()) != null && (ss = new SwampSubmitter(PlatformUI.getWorkbench().getActiveWorkbenchWindow())).authenticateUser()) {
                    try {
                        ResultsRetriever.retrieveResults();
                    }
                    catch (ResultsRetrievalException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.refreshItemAction);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void addRowsToStatusTable(List<String> statuses) {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        for (String s : statuses) {
            TableItem item = new TableItem(this.table, 0);
            String[] parts = s.split(",");
            int i = 3;
            while (i < parts.length) {
                item.setText(i - 3, parts[i]);
                ++i;
            }
            item.setData(ASSESS_UUID, (Object)parts[2]);
            item.setData(RESULTS_FILEPATH, (Object)parts[0]);
        }
        TableColumn col = this.table.getSortColumn();
        if (col != null) {
            SortListener.sortByCol(col);
        }
    }
}

