/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.ui;

import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.Controller;
import org.continuousassurance.swamp.eclipse.ResultsRetriever;
import org.continuousassurance.swamp.eclipse.StatusChecker;
import org.continuousassurance.swamp.eclipse.exceptions.ResultsRetrievalException;
import org.continuousassurance.swamp.eclipse.handlers.HandlerUtilityMethods;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SwampPerspective
implements IPerspectiveFactory {
    public static final String MARKER_OBJ = "marker";
    public static final String BUG_DETAIL_OBJ = "bugdetail";
    public static final String ID = "org.continuousassurance.swamp.eclipse.ui.perspective";

    public void createInitialLayout(IPageLayout layout) {
        System.out.println("Create initial layout invoked!");
        this.defineLayout(layout);
        Controller.refreshWorkspace();
    }

    public void defineLayout(IPageLayout layout) {
        System.out.println("Define initial layout invoked!");
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.25f, editorArea);
        topLeft.addView("org.eclipse.ui.navigator.ProjectExplorer");
        IFolderLayout bottom = layout.createFolder("bottom", 4, 0.7f, editorArea);
        bottom.addView("org.continuousassurance.swamp.eclipse.ui.views.tableview");
        bottom.addView("org.continuousassurance.swamp.eclipse.ui.views.statusview");
        IFolderLayout right = layout.createFolder("right", 2, 0.6f, editorArea);
        right.addView("org.continuousassurance.swamp.eclipse.ui.views.detailview");
        IWorkbench wb = PlatformUI.getWorkbench();
        System.out.println("Attempting to update layout!");
        if (wb != null) {
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            SwampPerspective.initializeFileChangeListener(window);
        }
    }

    public static void initializeFileChangeListener(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        IPartService service = window.getPartService();
        service.addPartListener((IPartListener2)new FileChangeListener());
    }

    public static class FileChangeListener
    implements IPartListener2 {
        private IFile currentlyOpenedFile = null;
        private IProject currentlyOpenedProject = null;
        private boolean statusViewInitialized = false;

        private void refreshWS(IWorkbenchWindow window) {
            if (window != null) {
                IProject project = HandlerUtilityMethods.getActiveProject(window);
                IFile file = HandlerUtilityMethods.getActiveFile(window);
                if (project != null && file != null) {
                    if (Controller.showAll) {
                        if (!project.equals((Object)this.currentlyOpenedProject)) {
                            this.currentlyOpenedFile = file;
                            this.currentlyOpenedProject = project;
                            Controller.refreshWorkspace();
                        }
                    } else if (!file.equals((Object)this.currentlyOpenedFile)) {
                        this.currentlyOpenedFile = file;
                        Controller.refreshWorkspace();
                    }
                }
            }
        }

        public void partActivated(IWorkbenchPartReference part) {
            System.out.println("WorkbenchPartRef: " + part.getId());
            if (!this.statusViewInitialized && part.getId().equals("org.continuousassurance.swamp.eclipse.ui.views.statusview")) {
                this.statusViewInitialized = true;
                StatusChecker sc = Activator.getStatusChecker();
                if (sc == null || !sc.isRunning()) {
                    try {
                        ResultsRetriever.retrieveResults();
                    }
                    catch (ResultsRetrievalException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                IWorkbenchWindow window = FileChangeListener.getActiveWindow();
                if (window != null && (Controller.getView(window, "org.continuousassurance.swamp.eclipse.ui.views.tableview") != null || Controller.swampPerspectiveOpen(window.getActivePage()))) {
                    System.out.println("Swamp Weaknesses View (aka TableView) open");
                    this.refreshWS(window);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference arg0) {
        }

        public void partClosed(IWorkbenchPartReference arg0) {
        }

        public void partDeactivated(IWorkbenchPartReference arg0) {
        }

        public void partHidden(IWorkbenchPartReference arg0) {
        }

        public void partInputChanged(IWorkbenchPartReference part) {
        }

        public void partOpened(IWorkbenchPartReference part) {
            IWorkbenchWindow window = FileChangeListener.getActiveWindow();
            if (window != null && (Controller.getView(window, "org.continuousassurance.swamp.eclipse.ui.views.tableview") != null || Controller.swampPerspectiveOpen(window.getActivePage()))) {
                this.refreshWS(window);
            }
        }

        private static IWorkbenchWindow getActiveWindow() {
            IWorkbench wb = PlatformUI.getWorkbench();
            if (wb != null) {
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                return window;
            }
            return null;
        }

        public void partVisible(IWorkbenchPartReference arg0) {
        }
    }
}

