/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import org.continuousassurance.swamp.eclipse.Utils;

public class AssessmentDetails {
    private String resultsFilepath;
    private String prjUUID;
    private String assessUUID;
    private String packageName;
    private String packageVersion;
    private String eclipseProject;
    private String submissionTime;
    private String status;
    private String tool;
    private String platform;
    private String bugCount;
    public static final String DELIMITER = ",";
    public static final int NUM_HIDDEN_FIELDS = 3;
    public static final int ASSESS_UUID_PART = 2;
    public static final int RESULTS_FILEPATH_PART = 0;

    public AssessmentDetails(String prjUUID, String packageName, String packageVersion, String eclipseProject) {
        this.prjUUID = prjUUID;
        this.packageName = packageName;
        this.packageVersion = packageVersion;
        this.eclipseProject = eclipseProject;
        this.resultsFilepath = "";
        this.assessUUID = "";
        this.submissionTime = "";
        this.status = "";
        this.tool = "";
        this.platform = "";
        this.bugCount = "";
    }

    public AssessmentDetails(String serializedDetails) {
        String[] parts = serializedDetails.split(DELIMITER);
        this.resultsFilepath = parts[0];
        this.prjUUID = parts[1];
        this.assessUUID = parts[2];
        this.packageName = parts[3];
        this.packageVersion = parts[4];
        this.tool = parts[5];
        this.submissionTime = parts[6];
        this.status = parts[7];
        this.bugCount = parts[8];
        this.eclipseProject = parts[9];
        this.platform = parts[10];
    }

    public void setAssessmentUUID(String assessUUID) {
        this.assessUUID = assessUUID;
    }

    public void setSubmissionTime() {
        this.submissionTime = Utils.getCurrentTimestamp();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setResultsFilepath(String filepath) {
        this.resultsFilepath = filepath;
    }

    public String serialize() {
        String str = String.valueOf(this.resultsFilepath) + DELIMITER + this.prjUUID + DELIMITER + this.assessUUID + DELIMITER + this.packageName + DELIMITER + this.packageVersion + DELIMITER + this.tool + DELIMITER + this.submissionTime + DELIMITER + this.status + DELIMITER + this.bugCount + DELIMITER + this.eclipseProject + DELIMITER + this.platform + DELIMITER + "\n";
        return str;
    }

    public String toString() {
        return this.serialize();
    }

    public void setToolName(String toolName) {
        this.tool = toolName;
    }

    public void setPlatformName(String platformName) {
        this.platform = platformName;
    }

    public String getProjectUUID() {
        return this.prjUUID;
    }

    public String getAssessUUID() {
        return this.assessUUID;
    }

    public void updateStatus(String status) {
        this.status = status;
    }

    public void setBugCount(int bugCount) {
        this.bugCount = Integer.toString(bugCount);
    }

    public String getFilepath() {
        return this.resultsFilepath;
    }
}

