/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ImprovedClasspathHandler {
    private static final String SOURCE_VERSION_OPTION = "org.eclipse.jdt.core.compiler.source";
    private static final String TARGET_VERSION_OPTION = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String SWAMPBIN_DIR = "swampbin";
    private static final char DASH = '-';
    private IPath SWAMPBIN_PATH = null;
    private List<IClasspathEntry> sources = null;
    private List<IClasspathEntry> libs = null;
    private List<IClasspathEntry> systemLibs = null;
    private List<IClasspathEntry> exportedEntries = null;
    private List<ImprovedClasspathHandler> dependentProjects = null;
    private Map<String, ImprovedClasspathHandler> visitedProjects = null;
    private ImprovedClasspathHandler root = null;
    private Set<String> filesToArchive = null;
    private boolean excludeSysLibs = false;
    private boolean hasSwampbinDependencies = false;
    private IJavaProject project;
    private String srcVersion;
    private String targetVersion;
    private SubMonitor subMonitor;

    public ImprovedClasspathHandler(IJavaProject project, ImprovedClasspathHandler root, boolean exclSysLibs, SubMonitor subMonitor) {
        this.excludeSysLibs = exclSysLibs;
        this.sources = new ArrayList<IClasspathEntry>();
        this.libs = new ArrayList<IClasspathEntry>();
        this.systemLibs = new ArrayList<IClasspathEntry>();
        this.dependentProjects = new ArrayList<ImprovedClasspathHandler>();
        this.exportedEntries = new ArrayList<IClasspathEntry>();
        this.project = project;
        this.srcVersion = this.project.getOption(SOURCE_VERSION_OPTION, true);
        this.targetVersion = this.project.getOption(TARGET_VERSION_OPTION, true);
        if (root == null) {
            this.root = this;
            this.subMonitor = subMonitor;
            this.subMonitor.setWorkRemaining(100);
            this.visitedProjects = new HashMap<String, ImprovedClasspathHandler>();
            this.SWAMPBIN_PATH = this.setupBinDir(project.getProject());
            this.filesToArchive = new HashSet<String>();
        } else {
            this.root = root;
            this.visitedProjects = root.visitedProjects;
            this.SWAMPBIN_PATH = root.SWAMPBIN_PATH;
            this.filesToArchive = root.filesToArchive;
        }
        try {
            project.getProject().build(15, null);
        }
        catch (CoreException e1) {
            System.err.println("Unable to do a clean build on the project for some reason");
            e1.printStackTrace();
        }
        IClasspathEntry[] entries = null;
        try {
            entries = project.getRawClasspath();
            if (entries == null || entries.length == 0) {
                return;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int kind = entry.getEntryKind();
                if (this.subMonitor != null) {
                    if (this.subMonitor.isCanceled()) {
                        System.out.println("Sub monitor got cancelled!");
                    }
                    this.subMonitor.split(20);
                }
                if (kind == 3) {
                    this.handleSource(entry, wsRoot);
                } else if (kind == 1) {
                    this.handleLibrary(entry, wsRoot);
                } else if (kind == 2) {
                    this.handleProject(entry, wsRoot);
                } else if (kind == 4) {
                    this.handleVariable(entry, wsRoot);
                } else {
                    this.handleContainer(entry, wsRoot);
                }
                ++n2;
            }
        }
        catch (IOException | JavaModelException e) {
            e.printStackTrace();
        }
        if (this.hasSwampbinDependencies) {
            this.filesToArchive.add(this.SWAMPBIN_PATH.toOSString());
        }
    }

    private IPath setupBinDir(IProject project) {
        String path = String.valueOf(project.getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString()) + File.separator + SWAMPBIN_DIR;
        File f = new File(path);
        if (f.exists()) {
            System.out.println("SWAMPBIN already exists but we should be deleting it now!");
            try {
                FileUtils.deleteDirectory((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        f.mkdir();
        return new Path(path);
    }

    private void handleSource(IClasspathEntry entry, IWorkspaceRoot root) {
        this.sources.add(entry);
        IFile file = root.getFile(entry.getPath());
        IProject project = file.getProject();
        IPath projectPath = project.getLocation();
        System.out.println("Source location: " + projectPath.toOSString());
        File src = new File(projectPath.toOSString());
        File dst = new File(String.valueOf(this.getRootProjectPluginLocation()) + File.separator + project.getName());
        System.out.println("Src path: " + src.getPath());
        System.out.println("Dst path: " + dst.getPath());
        try {
            FileUtils.copyDirectory((File)src, (File)dst);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.filesToArchive.add(dst.getPath().toString());
    }

    private void handleLibrary(IClasspathEntry entry, IWorkspaceRoot root) throws IOException {
        System.out.println("\n\n\n\n");
        System.out.println("Library absolute path: " + entry.getPath().makeAbsolute());
        IFile file = root.getFile(entry.getPath());
        System.out.println("File project: " + file.getProject().getName());
        if (file.getProject().equals((Object)this.project.getProject())) {
            System.out.println("Is inside project");
            this.libs.add(entry);
        } else {
            IPath destPath;
            System.out.println("Is outside project");
            IFile libFile = root.getFile(entry.getPath());
            IProject libProject = libFile.getProject();
            String filename = ImprovedClasspathHandler.getLibraryFileName(entry.getPath());
            if (libProject.exists()) {
                String srcPath;
                if (libProject.isOpen()) {
                    try {
                        System.out.println("Local project");
                        destPath = ImprovedClasspathHandler.copyWorkspacePathIntoBinDir(libFile, filename, this.SWAMPBIN_PATH);
                    }
                    catch (Exception exception) {
                        System.out.println("Local project that failed");
                        srcPath = ImprovedClasspathHandler.getProjectLibraryLocation(libProject, entry.getPath());
                        destPath = ImprovedClasspathHandler.copyAbsolutePathIntoBinDir(srcPath, filename, this.SWAMPBIN_PATH);
                    }
                } else {
                    System.out.println("Local project that's closed");
                    srcPath = ImprovedClasspathHandler.getProjectLibraryLocation(libProject, entry.getPath());
                    destPath = ImprovedClasspathHandler.copyAbsolutePathIntoBinDir(srcPath, filename, this.SWAMPBIN_PATH);
                }
            } else {
                System.out.println("Not a project - just an absolute path");
                destPath = ImprovedClasspathHandler.copyAbsolutePathIntoBinDir(entry.getPath().toOSString(), filename, this.SWAMPBIN_PATH);
            }
            this.hasSwampbinDependencies = true;
            System.out.println("SWAMPBIN path: " + destPath);
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)destPath, (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath());
            System.out.println("New entry path: " + newEntry.getPath());
            this.libs.add(newEntry);
            if (entry.isExported()) {
                this.exportedEntries.add(newEntry);
            }
        }
    }

    private void handleProject(IClasspathEntry entry, IWorkspaceRoot root) {
        ImprovedClasspathHandler ich;
        String path = entry.getPath().toOSString();
        if (this.visitedProjects.containsKey(path)) {
            ich = this.visitedProjects.get(path);
            this.dependentProjects.add(ich);
        } else {
            IProject project = root.getProject(entry.getPath().toOSString());
            ich = new ImprovedClasspathHandler(JavaCore.create((IProject)project), this.root, this.root.excludeSysLibs, null);
            this.dependentProjects.add(ich);
            this.visitedProjects.put(path, ich);
        }
        for (IClasspathEntry e : ich.getExportedEntries()) {
            this.libs.add(e);
            if (!entry.isExported()) continue;
            this.exportedEntries.add(e);
        }
    }

    private void handleVariable(IClasspathEntry entry, IWorkspaceRoot root) throws IOException {
        IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        if (resolvedEntry.getEntryKind() == 1) {
            this.handleLibrary(resolvedEntry, root);
        } else {
            this.handleProject(resolvedEntry, root);
        }
    }

    public void handleContainer(IClasspathEntry entry, IWorkspaceRoot root) throws IOException, JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.project);
        System.out.println("Here's a container" + container);
        int kind = container.getKind();
        if (this.excludeSysLibs && (kind == 1 || kind == 3)) {
            System.out.println("System library container");
            System.out.println(entry.getPath());
            return;
        }
        IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry subEntry = iClasspathEntryArray[n2];
            if (subEntry.getEntryKind() == 1) {
                this.handleLibrary(subEntry, root);
            } else {
                this.handleProject(subEntry, root);
            }
            ++n2;
        }
    }

    public void deleteSwampBin() throws IOException {
        File f = this.SWAMPBIN_PATH.toFile();
        if (f.exists()) {
            FileUtils.forceDelete((File)f);
        }
    }

    private static String getProjectLibraryLocation(IProject project, IPath entryPath) {
        String projectDir = project.getLocation().toOSString();
        String srcFile = String.valueOf(projectDir) + File.separator + entryPath.removeFirstSegments(1);
        return srcFile;
    }

    private static IPath copyWorkspacePathIntoBinDir(IFile file, String filename, IPath swampBinPath) throws CoreException {
        String filePath = String.valueOf(swampBinPath.toOSString()) + File.separator + filename;
        Path destPath = new Path(filePath);
        file.copy((IPath)destPath, true, null);
        return new Path(String.valueOf(File.separator) + SWAMPBIN_DIR + File.separator + filename);
    }

    private static IPath copyAbsolutePathIntoBinDir(String srcStr, String filename, IPath swampBinPath) throws IOException {
        String destStr = String.valueOf(swampBinPath.toOSString()) + File.separator + filename;
        java.nio.file.Path destPath = new File(destStr).toPath();
        java.nio.file.Path srcPath = new File(srcStr).toPath();
        System.out.println("Path we're reading from: " + srcPath);
        byte[] bytes = Files.readAllBytes(srcPath);
        System.out.println("Length of file in bytes: " + bytes.length);
        OpenOption[] options = new OpenOption[]{StandardOpenOption.DSYNC, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        System.out.println("Path we're writing to: " + destPath);
        Files.write(destPath, bytes, options);
        return new Path(String.valueOf(File.separator) + SWAMPBIN_DIR + File.separator + filename);
    }

    private static String getLibraryFileName(IPath path) {
        String strPath = path.toOSString();
        if (strPath.charAt(0) == File.separatorChar) {
            strPath = strPath.substring(1);
        }
        strPath = strPath.replace(File.separatorChar, '-');
        strPath = strPath.replace(':', '-');
        return strPath;
    }

    public Set<String> getFilesToArchive() {
        System.out.println("FILES TO ARCHIVE");
        for (String s : this.filesToArchive) {
            System.out.println(s);
        }
        return this.filesToArchive;
    }

    public String getProjectName() {
        return this.project.getProject().getName();
    }

    public String getSourceVersion() {
        return this.srcVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public List<IClasspathEntry> getLibraryClasspath() {
        return this.libs;
    }

    public List<IClasspathEntry> getSystemLibraryClasspath() {
        return this.systemLibs;
    }

    public List<IClasspathEntry> getSourceClasspath() {
        return this.sources;
    }

    public List<IClasspathEntry> getExportedEntries() {
        return this.exportedEntries;
    }

    public IPath getDefaultOutputLocation() {
        try {
            System.out.println("Absolute default output location: " + this.project.getOutputLocation().makeAbsolute());
            System.out.println("Relative default output location: " + this.project.getOutputLocation().makeRelative());
            return this.project.getOutputLocation().makeAbsolute();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getRootProjectPluginLocation() {
        return this.root.project.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
    }

    public String getProjectPluginLocation() {
        return this.project.getProject().getWorkingLocation("org.continuousassurance.swamp.eclipse").toOSString();
    }

    public String getEncoding() {
        String encoding = "";
        try {
            encoding = this.project.getProject().getDefaultCharset(true);
        }
        catch (CoreException coreException) {}
        return encoding;
    }

    public List<ImprovedClasspathHandler> getDependentProjects() {
        return this.dependentProjects;
    }

    public static void getReferencedProjects(IJavaProject jp, Set<IProject> projectSet) {
        projectSet.add(jp.getProject());
        try {
            IProject[] prjArray;
            IProject[] iProjectArray = prjArray = jp.getProject().getReferencedProjects();
            int n = prjArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                ImprovedClasspathHandler.getReferencedProjects(JavaCore.create((IProject)p), projectSet);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

