/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.continuousassurance.swamp.api.Tool;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.eclipse.SubmissionInfo;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolDialog
extends TitleAreaDialog {
    private List<Tool> tools;
    private org.eclipse.swt.widgets.List swtToolList;
    private SwampApiWrapper api;
    private SubmissionInfo submissionInfo;
    private Shell shell;
    private static final String TOOL_TITLE = "Tool Selection";
    private static final String TOOL_HELP = "Select one or more tools to run your assessment on.";
    private static final String TOOLS_LABEL = "Tools: ";
    private static final String SELECT_AT_LEAST_ONE_TOOL_MESSAGE = "Select at least one tool.";

    public ToolDialog(Shell parentShell, SubmissionInfo si) {
        super(parentShell);
        this.shell = parentShell;
        this.submissionInfo = si;
        this.api = this.submissionInfo.getApi();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        this.setTitle(TOOL_TITLE);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        DialogUtil.initializeLabelWidget(TOOLS_LABEL, 0, container);
        this.tools = this.api.getTools(this.submissionInfo.getPackageType(), this.submissionInfo.getSelectedProjectID());
        this.swtToolList = DialogUtil.initializeListWidget(container, new GridData(4, 0, true, false), this.convertToolListToStringArray());
        this.swtToolList.addHelpListener(e -> MessageDialog.openInformation((Shell)this.shell, (String)"Help", (String)TOOL_HELP));
        if (this.submissionInfo.toolsInitialized()) {
            System.out.println("Tools initialized");
            List<String> toolUUIDs = this.submissionInfo.getSelectedToolIDs();
            this.setSelectedTools(toolUUIDs);
        } else {
            this.swtToolList.selectAll();
        }
        return area;
    }

    private String[] convertToolListToStringArray() {
        int numTools = this.tools.size();
        String[] toolArray = new String[numTools];
        int i = 0;
        while (i < numTools) {
            toolArray[i] = this.tools.get(i).getName();
            ++i;
        }
        return toolArray;
    }

    private void setSelectedTools(List<String> toolUUIDs) {
        int count = 0;
        int numIDs = toolUUIDs.size();
        int i = 0;
        while (i < this.tools.size() && count < numIDs) {
            String id = this.tools.get(i).getUUIDString();
            if (toolUUIDs.contains(id)) {
                this.swtToolList.select(i);
                ++count;
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Button clear = this.createButton(parent, 3, "Clear", false);
        clear.addSelectionListener((SelectionListener)new ClearButtonSelectionListener());
        this.createButton(parent, 14, "Back", false);
        this.createButton(parent, 0, "OK", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    public void buttonPressed(int buttonID) {
        switch (buttonID) {
            case 0: {
                this.okPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
    }

    private void backPressed() {
        this.submissionInfo.setSelectedToolIDs(this.getSelectedIDs());
        super.setReturnCode(14);
        super.close();
    }

    protected void okPressed() {
        if (this.swtToolList.getSelectionCount() < 1) {
            this.setMessage(SELECT_AT_LEAST_ONE_TOOL_MESSAGE);
        }
        this.submissionInfo.setSelectedToolIDs(this.getSelectedIDs());
        super.okPressed();
    }

    private List<String> getSelectedIDs() {
        int[] selectedIndices = this.swtToolList.getSelectionIndices();
        ArrayList<String> selectedToolIDs = new ArrayList<String>(selectedIndices.length);
        int[] nArray = selectedIndices;
        int n = selectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Tool tool = this.tools.get(i);
            selectedToolIDs.add(tool.getUUIDString());
            ++n2;
        }
        return selectedToolIDs;
    }

    private class ClearButtonSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            ToolDialog.this.swtToolList.deselectAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

