/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.continuousassurance.swamp.eclipse.SubmissionInfo;
import org.continuousassurance.swamp.eclipse.Utils;

public class FileSerializer {
    private static String DELIMITER = ",";
    private static String NEEDS_BUILD_FILE = "NEEDSBUILDFILE";
    private static String HAS_BUILD_FILE = "HASBUILDFILE";
    private static String LINE_SEPARATOR = System.lineSeparator();

    public static boolean deserializeSubmissionInfo(String filepath, SubmissionInfo si) {
        BufferedReader reader;
        block4: {
            File file = new File(filepath);
            if (!file.exists()) {
                System.out.println("File does not exist");
                return false;
            }
            InputStreamReader filereader = null;
            reader = null;
            try {
                filereader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                reader = new BufferedReader(filereader);
                if (FileSerializer.deserializeConfigInfo(reader, si)) break block4;
                return false;
            }
            catch (Exception e) {
                System.err.println("Unable to deserialize file");
                e.printStackTrace();
                return false;
            }
        }
        si.setConfigInitialized(true);
        FileSerializer.deserializeSelectionInfo(reader, si);
        reader.close();
        return true;
    }

    public static void serializeSubmissionInfo(String filepath, SubmissionInfo si) {
        File file = new File(filepath);
        if (file.exists()) {
            FileSerializer.deleteFile(filepath);
        }
        OutputStreamWriter filewriter = null;
        BufferedWriter writer = null;
        try {
            filewriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            writer = new BufferedWriter(filewriter);
            FileSerializer.serializeConfigInfo(writer, si);
            FileSerializer.serializeSelectionInfo(writer, si);
            writer.close();
        }
        catch (Exception e) {
            System.err.println("Unable to serialize file");
            e.printStackTrace();
        }
    }

    private static boolean deserializeSelectionInfo(BufferedReader reader, SubmissionInfo si) throws IOException {
        String str = reader.readLine();
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        List<String> platformList = Utils.convertDelimitedStringToList(str, DELIMITER);
        si.setSelectedPlatformIDs(platformList);
        str = reader.readLine();
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        List<String> toolList = Utils.convertDelimitedStringToList(str, DELIMITER);
        si.setSelectedToolIDs(toolList);
        return true;
    }

    private static boolean deserializeConfigInfo(BufferedReader reader, SubmissionInfo si) throws IOException {
        String str = reader.readLine();
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        si.setSelectedProjectID(str);
        str = reader.readLine();
        if (str != null && !str.equals(LINE_SEPARATOR)) {
            si.setPackageType(str, true);
        }
        String prjName = null;
        String prjPath = null;
        str = reader.readLine();
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        prjName = str;
        str = reader.readLine();
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        prjPath = str;
        if (!si.initializeProject(prjName, prjPath)) {
            reader.close();
            System.out.println("We were unable to find the last selected project");
            return false;
        }
        String pkgUUID = null;
        str = reader.readLine();
        if (str != null && !str.equals(LINE_SEPARATOR)) {
            char c = str.charAt(0);
            if (c == '\t') {
                pkgUUID = str.substring(1, str.length());
                if (!si.setSelectedPackageID(pkgUUID)) {
                    reader.close();
                    System.out.println("We were unable to find the last SWAMP Package. This package must have been deleted.");
                    return false;
                }
            } else {
                String name = str;
                if (!si.setPackageIDFromName(name)) {
                    reader.close();
                    System.out.println("We were unable to find the last SWAMP Package. This package was probably deleted.");
                    return false;
                }
            }
        }
        String buildSys = reader.readLine();
        str = reader.readLine();
        boolean needsBuildFile = false;
        if (str == null || str.equals(LINE_SEPARATOR)) {
            return false;
        }
        needsBuildFile = str.equals(NEEDS_BUILD_FILE);
        String buildFile = reader.readLine();
        String buildDir = reader.readLine();
        String buildTarget = reader.readLine();
        String buildOpts = reader.readLine();
        String configDir = reader.readLine();
        String configCmd = reader.readLine();
        String configOpts = reader.readLine();
        String pkgSysLibsStr = reader.readLine();
        boolean pkgSysLibs = Boolean.parseBoolean(pkgSysLibsStr);
        si.setBuildInfo(buildSys, needsBuildFile, buildDir, buildFile, buildTarget, buildOpts, pkgSysLibs);
        si.setConfigInfo(configDir, configCmd, configOpts);
        return true;
    }

    public static void serializeSelectionInfo(BufferedWriter writer, SubmissionInfo si) throws IOException {
        List<String> platformIDList = si.getSelectedPlatformIDs();
        String platformIDString = Utils.convertListToDelimitedString(platformIDList, DELIMITER);
        writer.write(platformIDString);
        writer.write(LINE_SEPARATOR);
        List<String> toolIDList = si.getSelectedToolIDs();
        String toolIDString = Utils.convertListToDelimitedString(toolIDList, DELIMITER);
        writer.write(toolIDString);
        writer.write(LINE_SEPARATOR);
    }

    private static void serializeConfigInfo(BufferedWriter writer, SubmissionInfo si) throws IOException {
        String projectUUID = si.getSelectedProjectID();
        writer.write(projectUUID);
        writer.write(LINE_SEPARATOR);
        String packageType = si.getPackageType();
        writer.write(packageType);
        writer.write(LINE_SEPARATOR);
        String projectName = si.getProjectName();
        writer.write(projectName);
        writer.write(LINE_SEPARATOR);
        String projectPath = si.getProjectPath();
        writer.write(projectPath);
        writer.write(LINE_SEPARATOR);
        if (si.isNewPackage()) {
            writer.write(si.getPackageName());
        } else {
            writer.write("\t" + si.getSelectedPackageID());
        }
        writer.write(LINE_SEPARATOR);
        String buildSystem = si.getBuildSystem();
        writer.write(buildSystem);
        writer.write(LINE_SEPARATOR);
        if (si.needsBuildFile()) {
            writer.write(NEEDS_BUILD_FILE);
        } else {
            writer.write(HAS_BUILD_FILE);
        }
        writer.write(LINE_SEPARATOR);
        String buildFile = si.getBuildFile();
        writer.write(buildFile);
        writer.write(LINE_SEPARATOR);
        String buildDirectory = si.getBuildDirectory();
        writer.write(buildDirectory);
        writer.write(LINE_SEPARATOR);
        String buildTarget = si.getBuildTarget();
        writer.write(buildTarget);
        writer.write(LINE_SEPARATOR);
        String buildOpts = si.getBuildOpts();
        writer.write(buildOpts);
        writer.write(LINE_SEPARATOR);
        String configDir = si.getConfigDir();
        writer.write(configDir);
        writer.write(LINE_SEPARATOR);
        String configCmd = si.getConfigCmd();
        writer.write(configCmd);
        writer.write(LINE_SEPARATOR);
        String configOpts = si.getConfigOpts();
        writer.write(configOpts);
        writer.write(LINE_SEPARATOR);
        boolean pkgSysLibs = si.packageSystemLibraries();
        writer.write(Boolean.toString(pkgSysLibs));
        writer.write(LINE_SEPARATOR);
    }

    private static void deleteFile(String filepath) {
        File file = new File(filepath);
        file.delete();
    }
}

