/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.continuousassurance.swamp.api.AssessmentRecord;
import org.continuousassurance.swamp.cli.SwampApiWrapper;
import org.continuousassurance.swamp.cli.exceptions.InvalidIdentifierException;
import org.continuousassurance.swamp.eclipse.Activator;
import org.continuousassurance.swamp.eclipse.AssessmentDetails;
import org.continuousassurance.swamp.eclipse.Controller;
import org.continuousassurance.swamp.eclipse.exceptions.ResultsRetrievalException;
import org.eclipse.swt.widgets.Display;

public class ResultsRetriever {
    private static final String USER_NOT_LOGGED_IN_STATUS = "User not logged in";
    private static final String FINISHED = "Finished";
    private static final String FINISHED_WITH_ERRORS = "Finished with Errors";
    private static final String FAILED_TO_VALIDATE_ASSESSMENT_DATA = "FAILED TO VALIDATE ASSESSMENT DATA";
    private static final String FAILED_TO_START = "FAILED TO START";
    private static final String FINISHED_WITH_ERRORS_RETRY = "Finished with Errors - Retry";
    private static final Set<String> assessmentsToDelete = new HashSet<String>();
    private static final Lock lock = new ReentrantLock();

    public static synchronized void retrieveResults() throws ResultsRetrievalException {
        SwampApiWrapper api = null;
        if (Activator.getLoggedIn()) {
            try {
                api = new SwampApiWrapper();
                if (!api.restoreSession()) {
                    api = null;
                }
            }
            catch (Exception exception) {
                api = null;
            }
        }
        ArrayList<String> statuses = new ArrayList<String>();
        boolean refreshNeeded = ResultsRetriever.addUnfinishedFileStatuses(statuses, api);
        boolean bl = refreshNeeded = ResultsRetriever.addFinishedFileStatuses(statuses) || refreshNeeded;
        if (refreshNeeded) {
            System.out.println("Refresh Needed!");
            ResultsRetriever.refreshWS();
        } else {
            System.out.println("No refresh needed!");
        }
        System.out.println("Updating status view");
        ResultsRetriever.updateStatusView(statuses);
    }

    public static void addAssessmentToDelete(String assessUUID) {
        lock.lock();
        assessmentsToDelete.add(assessUUID);
        lock.unlock();
    }

    public static boolean addUnfinishedFileStatuses(List<String> statuses, SwampApiWrapper api) throws ResultsRetrievalException {
        File oldFile = new File(Activator.getUnfinishedAssessmentsPath());
        if (!oldFile.exists()) {
            return false;
        }
        Scanner sc = null;
        try {
            sc = new Scanner(oldFile, "UTF-8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        File tmp = new File(String.valueOf(Activator.getUnfinishedAssessmentsPath()) + ".tmp");
        if (tmp.exists()) {
            tmp.delete();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp, true), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            sc.close();
            throw new ResultsRetrievalException();
        }
        System.out.println("Now to parse stuff from unfinished file");
        boolean refreshNeeded = false;
        while (sc.hasNextLine()) {
            String assessmentDetails = sc.nextLine();
            System.out.println("New line: " + assessmentDetails);
            String newStatusStr = ResultsRetriever.updateStatus(writer, api, assessmentDetails);
            System.out.println("New status string: " + newStatusStr);
            if (newStatusStr != null) {
                statuses.add(newStatusStr);
                continue;
            }
            refreshNeeded = true;
        }
        sc.close();
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (api != null) {
            Path dst = oldFile.toPath();
            Path src = tmp.toPath();
            try {
                Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return refreshNeeded;
    }

    private static boolean addFinishedFileStatuses(List<String> statuses) throws ResultsRetrievalException {
        System.out.println("Now reading stuff from finished file");
        File f = new File(Activator.getFinishedAssessmentsPath());
        if (!f.exists()) {
            return false;
        }
        Scanner sc = null;
        try {
            sc = new Scanner(f);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            return false;
        }
        File tmp = new File(String.valueOf(Activator.getFinishedAssessmentsPath()) + ".tmp");
        if (tmp.exists()) {
            tmp.delete();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp, true), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            sc.close();
            throw new ResultsRetrievalException();
        }
        boolean refreshNeeded = false;
        while (sc.hasNext()) {
            String status = sc.nextLine();
            AssessmentDetails ad = new AssessmentDetails(status);
            String assessUUID = ad.getAssessUUID();
            lock.lock();
            if (!assessmentsToDelete.contains(assessUUID)) {
                statuses.add(status);
                try {
                    writer.write(String.valueOf(status) + "\n");
                }
                catch (IOException iOException) {}
            } else {
                refreshNeeded = true;
                assessmentsToDelete.remove(assessUUID);
            }
            lock.unlock();
        }
        sc.close();
        try {
            writer.close();
        }
        catch (IOException iOException) {}
        Path dst = f.toPath();
        Path src = tmp.toPath();
        try {
            Files.move(src, dst, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return refreshNeeded;
    }

    private static void updateStatusView(final List<String> statuses) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                System.out.println("Actually attempting to update status view");
                Controller.updateStatusView(statuses);
            }
        });
    }

    private static void refreshWS() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                System.out.println("Actually attempting to refresh workspace");
                Controller.refreshWorkspace();
            }
        });
    }

    private static void writeToFinishedFile(String newDetailInfo) throws IOException {
        File f = new File(Activator.getFinishedAssessmentsPath());
        if (!f.exists()) {
            f.createNewFile();
        }
        OutputStreamWriter finishedWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), "UTF-8");
        finishedWriter.write(newDetailInfo);
        finishedWriter.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String updateStatus(OutputStreamWriter writer, SwampApiWrapper api, String serializedAssessmentDetails) {
        AssessmentDetails ad = new AssessmentDetails(serializedAssessmentDetails);
        String prjUUID = ad.getProjectUUID();
        String assessUUID = ad.getAssessUUID();
        lock.lock();
        if (assessmentsToDelete.contains(assessUUID)) {
            assessmentsToDelete.remove(assessUUID);
            lock.unlock();
            return null;
        }
        lock.unlock();
        if (api == null) {
            ad.updateStatus(USER_NOT_LOGGED_IN_STATUS);
            return ad.serialize();
        }
        AssessmentRecord rec = null;
        try {
            rec = api.getAssessmentRecord(prjUUID, assessUUID);
        }
        catch (InvalidIdentifierException invalidIdentifierException) {
            System.out.println("Assessment has been deleted on SWAMP");
            return null;
        }
        if (rec == null) {
            return null;
        }
        String status = rec.getStatus();
        System.out.println("Status: " + status);
        ad.updateStatus(status);
        String newDetailInfo = "";
        try {
            if (FINISHED.equals(status)) {
                System.out.println("Finished with no errors!");
                System.out.println("Bug count: " + rec.getWeaknessCount());
                ad.setBugCount(rec.getWeaknessCount());
                String filepath = ad.getFilepath();
                File f = new File(filepath);
                if (f.exists()) {
                    f.delete();
                }
                newDetailInfo = ad.serialize();
                try {
                    api.getAssessmentResults(prjUUID, rec.getAssessmentResultUUID(), filepath);
                    System.out.println("Saved results to filepath: " + filepath);
                    System.out.println("Here's the details I just wrote out: " + newDetailInfo);
                    ResultsRetriever.writeToFinishedFile(newDetailInfo);
                    return null;
                }
                catch (Exception exception) {
                    System.err.println("Error in saving results for file");
                    writer.write(newDetailInfo);
                    return newDetailInfo;
                }
            }
            if (ResultsRetriever.isErrorStatus(status)) {
                System.out.println("Finished with errors!");
                newDetailInfo = ad.serialize();
                ResultsRetriever.writeToFinishedFile(newDetailInfo);
                return null;
            }
            newDetailInfo = ad.serialize();
            writer.write(newDetailInfo);
            return newDetailInfo;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newDetailInfo;
    }

    private static boolean isErrorStatus(String status) {
        if (status == null) {
            return false;
        }
        return FINISHED_WITH_ERRORS.equals(status) || FAILED_TO_VALIDATE_ASSESSMENT_DATA.equals(status) || FAILED_TO_START.equals(status) || FINISHED_WITH_ERRORS_RETRY.equals(status);
    }
}

