/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse.dialogs;

import java.net.URL;
import org.continuousassurance.swamp.eclipse.dialogs.DialogUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AboutSWAMPDialog
extends TitleAreaDialog {
    private static final String ABOUT_SWAMP_TITLE = "About SWAMP";
    private static final String ABOUT_SWAMP_NAME = "SWAMP Eclipse Plugin\n";
    private static final String ABOUT_SWAMP_LICENSE_LINK = "Please visit <a href=\"https://www.apache.org/licenses/LICENSE-2.0\">Apache License</a> for licensing information.\n";
    private static final String ABOUT_SWAMP_SUPPORT_INFO = "Please visit <a href=\"https://continuousassurance.org/support/\"> Continuous Assurance Support</a> for technical support.\n";
    private static final String ABOUT_SWAMP_GITHUB_LINK = "Source code is available at the SWAMP Eclipse Plug-in <a href=\"https://github.com/mirswamp/swamp-eclipse-plugin\">GitHub</a> repository.\n";
    private static final String ABOUT_SWAMP_SEMANTIC_VERSION_NUMBER = "1.0.0";
    private static final String ABOUT_SWAMP_RELEASE_DATE = "03/30/2017";
    private static final String RELEASE_DATE_LABEL = "Release Date: ";
    private static final String RELEASE_VERSION_LABEL = "Release Version: ";

    public AboutSWAMPDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.setTitle(ABOUT_SWAMP_TITLE);
        String relDate = this.getFormattedReleaseDate();
        String releaseVersion = this.getReleaseVersion();
        DialogUtil.initializeLabelWidget("SWAMP Eclipse Plugin\n\nRelease Date: " + relDate + "\n\n" + RELEASE_VERSION_LABEL + releaseVersion + "\n", 0, container);
        AboutSWAMPDialog.addLink(container, ABOUT_SWAMP_LICENSE_LINK);
        AboutSWAMPDialog.addLink(container, ABOUT_SWAMP_SUPPORT_INFO);
        AboutSWAMPDialog.addLink(container, ABOUT_SWAMP_GITHUB_LINK);
        return area;
    }

    private static void addLink(Composite container, String text) {
        Link link = new Link(container, 0);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new LinkSelectionAdapter());
    }

    private String getFormattedReleaseDate() {
        return ABOUT_SWAMP_RELEASE_DATE;
    }

    private String getReleaseVersion() {
        return ABOUT_SWAMP_SEMANTIC_VERSION_NUMBER;
    }

    public static class LinkSelectionAdapter
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(e.text));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

