/*
 * Decompiled with CFR 0.152.
 */
package org.continuousassurance.swamp.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.continuousassurance.swamp.eclipse.ImprovedClasspathHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BuildfileGenerator {
    private static final String CLASSPATH_NAME = "project.classpath";
    private static final String BOOTCLASSPATH_NAME = "project.bootclasspath";
    private static final String SOURCEPATH_NAME = "project.sourcepath";
    private static final String SWAMPBIN_NAME = "swampbin";
    private static final String SWAMPBIN_REL_PATH = "swampbin";
    public static final String BUILDFILE_EXT = ".xml";
    private static final int INDENT_SPACES = 4;
    private static final String ANT_INDENT_NUMBER = "indent-number";
    private static final String ANT_YES = "yes";
    private static final String ANT_PROJECT = "project";
    private static final String ANT_DEFAULT = "default";
    private static final String ANT_BUILD = "build";
    private static final String ANT_NAME = "name";
    private static final String ANT_SOURCE = "source";
    private static final String ANT_TARGET = "target";
    private static final String ANT_VALUE = "value";
    private static final String ANT_PROPERTY = "property";
    private static final String ANT_PATH = "path";
    private static final String ANT_ID = "id";
    private static final String ANT_PATH_ELEMENT = "pathelement";
    private static final String ANT_LOCATION = "location";
    private static final String ANT_INIT = "init";
    private static final String ANT_MKDIR = "mkdir";
    private static final String ANT_DIR = "dir";
    private static final String ANT_DEPENDS = "depends";
    private static final String ANT_ANT = "ant";
    private static final String ANT_ANTFILE = "antfile";
    private static final String ANT_JAVAC = "javac";
    private static final String ANT_INCLUDE_ANT_RUNTIME = "includeantruntime";
    private static final String ANT_FALSE = "false";
    private static final String ANT_CLASSPATHREF = "classpathref";
    private static final String ANT_BOOTCLASSPATHREF = "bootclasspathref";
    private static final String ANT_SOURCEPATHREF = "sourcepathref";
    private static final String ANT_SOURCEPATH = "sourcepath";
    private static final String ANT_ENCODING = "encoding";
    private static final String ANT_DESTDIR = "destdir";
    private static final String ANT_INCLUDE = "include";
    private static final String ANT_EXCLUDE = "exclude";
    private static final String ANT_SRC = "src";

    private BuildfileGenerator() {
    }

    public static void generateBuildFile(ImprovedClasspathHandler project, Set<String> filePaths) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = BuildfileGenerator.generateRoot(doc, project.getProjectName());
            doc.appendChild(root);
            BuildfileGenerator.setProperties(doc, root, "swampbin", project.getSourceVersion(), project.getTargetVersion());
            BuildfileGenerator.setLibraryClasspath(doc, root, project.getLibraryClasspath(), project.getExportedEntries(), project.getSourceClasspath(), project.getDependentProjects(), project.getDefaultOutputLocation().toOSString());
            BuildfileGenerator.setBootClasspath(doc, root, project.getSystemLibraryClasspath());
            BuildfileGenerator.setSourcepath(doc, root, project.getSourceClasspath(), project.getDependentProjects());
            String prjName = project.getProjectName();
            BuildfileGenerator.setBuildTarget(doc, root, project.getDefaultOutputLocation().toOSString(), project.getDependentProjects(), project.getSourceClasspath(), prjName, filePaths, project.getEncoding());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute(ANT_INDENT_NUMBER, 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", ANT_YES);
            DOMSource source = new DOMSource(doc);
            String buildFilePath = String.valueOf(project.getRootProjectPluginLocation()) + File.separator + project.getProjectName() + BUILDFILE_EXT;
            File buildFile = new File(buildFilePath);
            if (buildFile.exists()) {
                System.out.println("Build file exists");
                buildFile.delete();
                try {
                    buildFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("File written to: " + buildFilePath);
            StreamResult result = new StreamResult(buildFile);
            transformer.transform(source, result);
            filePaths.add(buildFilePath);
        }
        catch (ParserConfigurationException p) {
            p.printStackTrace();
        }
        catch (TransformerException t) {
            t.printStackTrace();
        }
    }

    private static Element generateRoot(Document doc, String projectName) {
        Element root = doc.createElement(ANT_PROJECT);
        Attr defaultTask = doc.createAttribute(ANT_DEFAULT);
        defaultTask.setValue(ANT_BUILD);
        root.setAttributeNode(defaultTask);
        Attr prjName = doc.createAttribute(ANT_NAME);
        prjName.setValue(projectName);
        root.setAttributeNode(prjName);
        return root;
    }

    private static void setProperties(Document doc, Element root, String binPath, String srcVersion, String targetVersion) {
        Element swampbinProperty = BuildfileGenerator.getProperty(doc, "swampbin", binPath);
        root.appendChild(swampbinProperty);
        Element srcVersionProperty = BuildfileGenerator.getProperty(doc, ANT_SOURCE, srcVersion);
        root.appendChild(srcVersionProperty);
        Element targetVersionProperty = BuildfileGenerator.getProperty(doc, ANT_TARGET, targetVersion);
        root.appendChild(targetVersionProperty);
    }

    private static Element getProperty(Document doc, String name, String value) {
        Element property = doc.createElement(ANT_PROPERTY);
        property.setAttribute(ANT_NAME, name);
        property.setAttribute(ANT_VALUE, value);
        return property;
    }

    private static void setLibraryClasspath(Document doc, Element root, List<IClasspathEntry> libEntries, List<IClasspathEntry> dependentProjectExports, List<IClasspathEntry> srcEntries, List<ImprovedClasspathHandler> dependentProjects, String defaultOutputDir) {
        Element path = doc.createElement(ANT_PATH);
        path.setAttribute(ANT_ID, CLASSPATH_NAME);
        BuildfileGenerator.addLibraryEntries(doc, path, libEntries);
        BuildfileGenerator.addLibraryEntries(doc, path, dependentProjectExports);
        String relPath = defaultOutputDir.substring(1);
        BuildfileGenerator.addPathElement(doc, path, relPath);
        BuildfileGenerator.addSourceOutputEntries(doc, root, srcEntries);
        for (ImprovedClasspathHandler i : dependentProjects) {
            relPath = i.getDefaultOutputLocation().toOSString().substring(1);
            BuildfileGenerator.addPathElement(doc, path, relPath);
            BuildfileGenerator.addSourceOutputEntries(doc, root, i.getSourceClasspath());
        }
        root.appendChild(path);
    }

    private static void addLibraryEntries(Document doc, Element path, List<IClasspathEntry> entries) {
        for (IClasspathEntry entry : entries) {
            String rootedPath = entry.getPath().toOSString();
            String relativePath = rootedPath.substring(1);
            BuildfileGenerator.addPathElement(doc, path, relativePath);
        }
    }

    private static void addSourceOutputEntries(Document doc, Element path, List<IClasspathEntry> srcEntries) {
        if (srcEntries != null) {
            HashSet<String> dirs = new HashSet<String>();
            for (IClasspathEntry entry : srcEntries) {
                String relativePath;
                IPath outputPath = entry.getOutputLocation();
                if (outputPath == null || dirs.contains(relativePath = outputPath.toOSString().substring(1))) continue;
                dirs.add(relativePath);
                BuildfileGenerator.addPathElement(doc, path, relativePath);
            }
        }
    }

    private static void setBootClasspath(Document doc, Element root, List<IClasspathEntry> entries) {
        Element path = doc.createElement(ANT_PATH);
        path.setAttribute(ANT_ID, BOOTCLASSPATH_NAME);
        for (IClasspathEntry entry : entries) {
            String rootedPath = entry.getPath().toOSString();
            String relativePath = rootedPath.substring(1);
            BuildfileGenerator.addPathElement(doc, path, relativePath);
        }
        root.appendChild(path);
    }

    private static void setSourcepath(Document doc, Element root, List<IClasspathEntry> entries, List<ImprovedClasspathHandler> dependentProjects) {
        Element path = doc.createElement(ANT_PATH);
        path.setAttribute(ANT_ID, SOURCEPATH_NAME);
        BuildfileGenerator.addSourceEntries(doc, path, entries);
        for (ImprovedClasspathHandler i : dependentProjects) {
            BuildfileGenerator.addSourceEntries(doc, path, i.getSourceClasspath());
        }
        root.appendChild(path);
    }

    private static void addSourceEntries(Document doc, Element path, List<IClasspathEntry> entries) {
        for (IClasspathEntry entry : entries) {
            String rootedPath = entry.getPath().toOSString();
            String relativePath = rootedPath.substring(1);
            BuildfileGenerator.addPathElement(doc, path, relativePath);
        }
    }

    private static void addPathElement(Document doc, Element path, String strPath) {
        Element pe = doc.createElement(ANT_PATH_ELEMENT);
        pe.setAttribute(ANT_LOCATION, strPath);
        path.appendChild(pe);
    }

    private static Element setInitTarget(Document doc, Element root, String relOutputDir) {
        Element target = doc.createElement(ANT_TARGET);
        target.setAttribute(ANT_NAME, ANT_INIT);
        root.appendChild(target);
        Element mkdir = doc.createElement(ANT_MKDIR);
        mkdir.setAttribute(ANT_DIR, relOutputDir);
        target.appendChild(mkdir);
        return target;
    }

    private static void setBuildTarget(Document doc, Element root, String outputDirectory, List<ImprovedClasspathHandler> dependentProjects, List<IClasspathEntry> srcEntries, String projectName, Set<String> filePaths, String prjEncoding) {
        String prjOutputDirectory = outputDirectory.substring(1);
        System.out.println("Relative output directory: " + prjOutputDirectory);
        Element target = doc.createElement(ANT_TARGET);
        target.setAttribute(ANT_NAME, ANT_BUILD);
        Element init = BuildfileGenerator.setInitTarget(doc, root, prjOutputDirectory);
        target.setAttribute(ANT_DEPENDS, ANT_INIT);
        root.appendChild(target);
        for (ImprovedClasspathHandler ich : dependentProjects) {
            BuildfileGenerator.generateBuildFile(ich, filePaths);
            String buildFilePath = String.valueOf(ich.getProjectName()) + BUILDFILE_EXT;
            Element ant = doc.createElement(ANT_ANT);
            ant.setAttribute(ANT_ANTFILE, buildFilePath);
            ant.setAttribute(ANT_TARGET, ANT_BUILD);
            target.appendChild(ant);
        }
        for (IClasspathEntry entry : srcEntries) {
            String destDir;
            IPath[] inclusionPatterns = entry.getInclusionPatterns();
            IPath[] exclusionPatterns = entry.getExclusionPatterns();
            Element javac = doc.createElement(ANT_JAVAC);
            javac.setAttribute(ANT_INCLUDE_ANT_RUNTIME, ANT_FALSE);
            javac.setAttribute(ANT_CLASSPATHREF, CLASSPATH_NAME);
            javac.setAttribute(ANT_BOOTCLASSPATHREF, BOOTCLASSPATH_NAME);
            if (inclusionPatterns.length == 0 && exclusionPatterns.length == 0) {
                javac.setAttribute(ANT_SOURCEPATHREF, SOURCEPATH_NAME);
            } else {
                javac.setAttribute(ANT_SOURCEPATH, BuildfileGenerator.getModifiedSourcePath(entry, srcEntries));
            }
            String srcEncoding = BuildfileGenerator.getEncodingAttribute(entry);
            if (!"".equals(srcEncoding)) {
                javac.setAttribute(ANT_ENCODING, srcEncoding);
            } else if (!"".equals(prjEncoding) && prjEncoding != null) {
                System.out.println("Project encoding: " + prjEncoding);
                javac.setAttribute(ANT_ENCODING, prjEncoding);
            }
            IPath destPath = entry.getOutputLocation();
            if (destPath != null) {
                String strPath = destPath.toOSString();
                destDir = strPath.substring(1);
            } else {
                destDir = prjOutputDirectory;
            }
            Element mkdir = doc.createElement(ANT_MKDIR);
            mkdir.setAttribute(ANT_DIR, destDir);
            init.appendChild(mkdir);
            javac.setAttribute(ANT_DESTDIR, destDir);
            javac.setAttribute(ANT_SOURCE, "${source}");
            javac.setAttribute(ANT_TARGET, "${target}");
            Element src = doc.createElement(ANT_SRC);
            BuildfileGenerator.addInclusionExclusionPatterns(doc, javac, ANT_INCLUDE, entry.getInclusionPatterns());
            BuildfileGenerator.addInclusionExclusionPatterns(doc, javac, ANT_EXCLUDE, entry.getExclusionPatterns());
            String absPath = entry.getPath().toOSString();
            String strRelPath = absPath.substring(1);
            System.out.println("Relative path: " + strRelPath);
            src.setAttribute(ANT_PATH, strRelPath);
            javac.appendChild(src);
            target.appendChild(javac);
        }
    }

    private static String getModifiedSourcePath(IClasspathEntry currentEntry, List<IClasspathEntry> entries) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < entries.size()) {
            IClasspathEntry entry = entries.get(i);
            if (!currentEntry.equals(entry)) {
                String rootedPath = entry.getPath().toOSString();
                String relativePath = rootedPath.substring(1);
                String str = i == 0 ? relativePath : "," + relativePath;
                sb.append(str);
            }
            ++i;
        }
        return sb.toString();
    }

    private static void addInclusionExclusionPatterns(Document doc, Element parent, String taskName, IPath[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return;
        }
        IPath[] iPathArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            IPath pattern = iPathArray[n2];
            Element include = doc.createElement(taskName);
            include.setAttribute(ANT_NAME, pattern.toString());
            parent.appendChild(include);
            ++n2;
        }
    }

    private static String getEncodingAttribute(IClasspathEntry entry) {
        IClasspathAttribute[] attributes;
        IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if (attr.getName().equals("source_encoding")) {
                return attr.getValue();
            }
            ++n2;
        }
        return "";
    }
}

